import { IafProj, IafSession } from "@dtplatform/platform-api";

/**
 * @function  getCurrentProjectInfo
 * Get the current project information
 * @return {project,Ctx}
 */
const getCurrentProjectInfo = async () => {
  try {
    let project = await IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    ctx.authToken = await IafSession.getAuthToken();
    let token = ctx.authToken;
    let _namespaces = ctx._namespaces;
    let configUrl = await IafSession.getConfig();

    return { project, ctx, token, configUrl, _namespaces };
  } catch (err) {
    return err;
  }
};
const refAppQAFlag = async () => {
  let configUrl = await IafSession.getConfig();
  const refAppQA =
    configUrl.baseRoot.startsWith("https://qa") ||
    configUrl.baseRoot.startsWith("https://staging");
  return { refAppQA };
};

/**
 * @function  getUniqueFileItemName
 * Get a unique name of a file item based on their version
 * @param {fileItemData,shorten}
 * @return {String}
 */
const getUniqueFileItemName = (item, shorten = false) => {
  let uid =
    item.version !== "" ? item.name + " (" + item.version + ")" : item.name;

  if (shorten && uid.length > 20) {
    return uid.substring(0, 19) + "...";
  }

  return uid;
};

/**
 * @function  getFileExtension
 * get the extention of file
 */
const getFileExtension = (filename) => {
  const extension = filename.split(".").pop();
  return extension;
};

export default {
  getCurrentProjectInfo,
  refAppQAFlag,
  getUniqueFileItemName,
  getFileExtension,
};
