/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2020] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React from "react"
import * as PropTypes from "prop-types"
import _ from 'lodash'

import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import {StackableDrawer} from "@dtplatform/platform-app-conflux/modules/IpaControls";
import {EnhancedFetchControl} from "@dtplatform/platform-app-conflux/modules/IpaControls";
// import {applyFilters} from "@dtplatform/platform-app-conflux/modules/IpaControls"
import * as EntityDataContainer from "./EntityDataContainer";
import {EntityListView} from "./EntityListView";
import EntitySelectionPanel, {TreeSelectMode} from "./EntitySelectionPanel"
import EntityDetailPanel from "./EntityDetailPanel"
import {connect} from "react-redux";
// import {
//     getAllCurrentEntities,
//     getAppliedFilters, getAppliedGroups,
//     getFetchingCurrent,
//     getFilteredEntities
// } from "@dtplatform/platform-app-conflux/modules/IpaRedux";
import { Entities } from "@dtplatform/platform-app-conflux/modules/IpaRedux";
import {compose} from "redux";
import withEntitySearchNav from "../newNavigator/WithEntitySearchNav";
import { branchNodeRendererOld as branchNodeRenderer,
    leafNodeRendererOld as leafNodeRenderer} from "@dtplatform/platform-app-conflux/modules/IpaUtils"
import {getFilteredEntitiesBy} from "@dtplatform/platform-app-conflux/modules/IpaUtils";
import Select from "react-select";
import {IafProj, IafItemSvc, IafHelper, IafSession, IafPassSvc} from '@dtplatform/platform-api';
import { IafScriptEngine } from "@dtplatform/iaf-script-engine";
import ModelPanel from "./ModelPanel";
import './EntityView.scss'

const tableComponents = {
    'EntityListView': EntityListView,
};

class EntityView extends React.Component {

    state = {
        displayDetail: false,
        telemetryClick: false
    };
    
    openDetail = entity => {
        this.setState({displayDetail: true})
        this.props.entitiesSelected([entity]);
    }

    openSummary = () => {
        this.setState({displayDetail: false})
        this.props.entitiesSelected([]);
    }

    onTreeSelect = (entities) => {
        if (this.state.displayDetail == true && entities.length > 1) {
            this.setState({displayDetail: false})
        }
        this.props.entitiesSelected(entities)
    }

    tableEntities = () => _.isEmpty(this.props.selectedEntities) ? this.props.currentEntities : this.props.selectedEntities;

    onGroupOrFilterChange = (changes) => {
      this.setState({displayDetail: false})
      this.props.onGroupOrFilterChange(changes)
    }
    
    actionSuccess = (actionType, newEntity, result) => {
    if (actionType === 'delete') this.openSummary();
    if (actionType === 'edit') {  
        var updatedEntities = this.props.allEntities.map(a => {
            return a._id === newEntity._id ? newEntity : a;
        });
        const filteredEntities = getFilteredEntitiesBy(updatedEntities, this.props.appliedFilters)
        if(!_.isEmpty(filteredEntities) && _.isEmpty(filteredEntities.find(e => e._id === newEntity._id))) this.openSummary()
      }
      this.props.onEntityChange(actionType, newEntity, result);
      
    }

    _doFetch = (...args) => {
        const scriptName = this.props.handler.config.entityData[this.props.entitySingular].script
        console.log("this.props",this.props);
        console.log("scriptName",scriptName)
        this.setState({displayDetail: false})
        this.props.getFetcher(scriptName)(...args);
    }

    _telemetryClick = () => {
        this.setState({displayDetail: false, telemetryClick: true});
      
        const clickButton = () => { // use an arrow function here instead of a regular function
          setTimeout(() => {
            const buttonFetch = document.getElementsByClassName('MuiButtonBase-root MuiButton-root MuiButton-contained fetch-button')[0];
            buttonFetch.click();
            const delay = (time) => new Promise((resolve) => setTimeout(resolve, time));
      
            const clickElement = async (selector) => {
              const element = document.querySelector(selector);
              if (element) {
                element.click();
                await delay(2000);
              }
            };
      
            const checkCheckbox = (checkbox) => {
              if (checkbox.nextElementSibling.innerText !== "Telemetry Collection") {
                if (checkbox.checked) {
                  checkbox.click();
                }
              } else {
                if (!checkbox.checked) {
                  checkbox.click();
                }
              }
            };
      
            (async () => { // use an arrow function here instead of a regular function
              await delay(2000);
              const liElement = document.querySelector("li[data-node-id='63f71ccf33912b8066d62858']");
              if (liElement) {
                liElement.click();
                await delay(2000);
                await clickElement(".content-column.first");
                const parentDiv = document.querySelector(".entity-data-groups-selector");
                const checkboxes = parentDiv.querySelectorAll('input[type="checkbox"]');
                checkboxes.forEach(checkCheckbox);
              }
              this.setState({telemetryClick: false}); // use `this` to call `setState` here
            })();
          }, 1000);
        };
        clickButton();
      }

    render() {
        const {handler, entitySingular} = this.props;
        const {telemetryClick} = this.state;

        console.log("entity view state: ", this.state);
        console.log("entity view props: ", this.props);

        if (this.props.isPageLoading) return null;

        const TableComponent = tableComponents[_.get(handler, 'config.tableView.component.name')];

        let actions = {}
        let tableActions = {}
        if (this.props.handler.config.actions) {
            actions = Object.assign({}, this.props.handler.config.actions)
            actions.onSuccess = this.actionSuccess
            actions.doEntityAction = this.props.doEntityAction

            tableActions.onSuccess = this.actionSuccess
            tableActions.doEntityAction = this.props.doEntityAction

            let actionNames = Object.keys(actions);
            actionNames.forEach((action) => {
                if (actions[action].showOnTable)
                    tableActions[action] = actions[action];
            });

        }

        let pageContent;
        if (this.props.fetching) {
            pageContent = <span className="info-message">Retrieving data</span>
        } else if (this.props.currentEntities.length > 0) {
            if (this.state.displayDetail == true) {
                pageContent = <EntityDetailPanel
                    context={this.context}
                    onSummary={this.openSummary}
                    entity={this.props.selectedEntities[0]}
                    config={this.props.handler.config}
                    actions={actions}
                    availableDataGroups={this.props.availableDataGroups}
                    entityType={this.props.entitySingular}
                    loadingDataGroups={this.props.loadingAvailableDataGroups}
                    getData={this.props.getEntityExtendedData(this.props.handler.config.data)}
                />

            } else {

                pageContent = <TableComponent
                    config={handler.config.tableView.component}
                    onDetail={this.openDetail}
                    entities={this.tableEntities()}
                    actions={tableActions}
                    context={this.context}
                    entityPlural={this.props.entityPlural}
                    entitySingular={this.props.entitySingular}

                />
            }
        } else {
            pageContent = <span className="info-message">No data</span>
        }
        
        // make sure query id is numeric
        let fetchQuery = Object.assign({}, this.props.queryParams && this.props.queryParams.query ? this.props.queryParams.query : {})
        if (fetchQuery.id && _.isNaN(parseInt(fetchQuery.id))) {
            fetchQuery.id = "" + handler.config.selectBy.findIndex(sb => fetchQuery.id == sb.id)
        }

        let telemetryQuery={
            id:0,
            type:"<<SCRIPTED_LINKED_SELECTS>>",
            value:{ ElementCategory : ['Sensor'],
            ElementType : ['Tank Probe Temperature']}   
        };

        const nonGroupableProps = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.nonGroupableProperties : []) || [];
        const nonFilterableProps = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.nonFilterableProperties : []) || [];
        const defaultGroups = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.defaultGroups : []) || [];
        const multiModel = this.props.selectedItems?.selectedProject?.multiModel;
        return (
            <div className='entities-view'>
                { 
                    <StackableDrawer level={1} iconKey={'fa-table'}>
                        <ModelPanel props={this.props}/>
                    </StackableDrawer>
                }
                <StackableDrawer level={2} iconKey={'fa-search'}>
                    <div className='fetch-container'>
                    {!telemetryClick ?(
                        <EnhancedFetchControl
                        key={`fetch-${telemetryClick}`}
                            initialValue={fetchQuery}
                            selectors={handler.config.selectBy}
                            doFetch={this._doFetch}
                        />
                        ):(
                        <EnhancedFetchControl
                        key={`telemetry-${telemetryClick}`}
                            initialValue={telemetryQuery}
                            selectors={handler.config.selectBy}
                            doFetch={this._doFetch}
                        />
                        )
                    }
                    <GenericMatButton onClick={this._telemetryClick} customClasses= {'attention telemetry-button'}>
                        Telemetry
                    </GenericMatButton>
                    </div>
                </StackableDrawer>
                <StackableDrawer level={3} iconKey={'fa-sitemap'}>
                    <div className='tree-container'>
                        <EntitySelectionPanel
                            selectedGroups={this.props.groups}
                            selectedFilters={this.props.appliedFilters}
                            selectedEntities={this.props.selectedEntities}
                            fetching={this.props.fetching}
                            entities={this.props.allEntities}
                            onSelect={this.onTreeSelect}
                            treeSelectMode={TreeSelectMode.NONE_MEANS_NONE}
                            onGroupOrFilterChange={this.onGroupOrFilterChange}
                            leafNodeRenderer={leafNodeRenderer}
                            branchNodeRenderer={branchNodeRenderer}
                            nonFilterableProperties={nonFilterableProps}
                            nonGroupableProperties={nonGroupableProps}
                            name={this.props.entitySingular + "_selection_panel"}
                            entitySingular={this.props.entitySingular}
                            entityPlural={this.props.entityPlural}
                            defaultGroups={defaultGroups}
                        />
                    </div>
                </StackableDrawer>
                <div className='content'>{pageContent}</div>
            </div>
        )
    }
}

EntityView.contextTypes = {
    actions: PropTypes.object,
    ifefPlatform: PropTypes.object,
    ifefSnapper: PropTypes.object,
    ifefNavDirection: PropTypes.string,
    ifefShowPopover: PropTypes.func,
    ifefUpdatePopover: PropTypes.func,
    ifefUpdatePopup: PropTypes.func,
    ifefShowModal: PropTypes.func
};

const {
    getAllCurrentEntities,
    getAppliedFilters, getAppliedGroups,
    getFetchingCurrent,
    getFilteredEntities
      } = Entities;

const mapStateToProps = state => ({
    allEntities: getAllCurrentEntities(state),
    fetching: getFetchingCurrent(state),
    currentEntities: getFilteredEntities(state),
    appliedFilters: getAppliedFilters(state),
});

export default compose(
    withEntitySearchNav,
    connect(mapStateToProps),
)(EntityView)
