import React, { useState, useMemo, useEffect, createRef } from 'react';
import { useApplicationContext, useContextModelId } from '../../Hooks/appCtxHook';
import Select from "react-select";
import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import { IafProj, IafItemSvc, IafSession } from '@dtplatform/platform-api';

const ModelPanel = ({ props }) => {
  console.log('ModelPanel props: ', props)
  const [selectedItems, setSelectedItems] = useState(props.selectedItems);
  const [multiModel, setMultiModel] = useState(false);
  const [orderedModels, setOrderedModels] = useState([]);
  const [currentModel, setCurrentModel] = useState(null);
  const applicationContext = useApplicationContext();
  const contextModelId = useContextModelId();
  const [initialModelId, setCurrentModelId] = useState(contextModelId);

  useEffect(() => {
    if (contextModelId !== initialModelId) {
      applicationContext.actions.restartApp(true, false);    
    }
  }, [contextModelId]);

  useEffect( () => { 
    async function orderModels() {
      console.log(
        'selectedItems.selectedProject.multiModel: ', selectedItems.selectedProject._userAttributes.multiModel
      )
      if (multiModel !== selectedItems.selectedProject._userAttributes.multiModel) {
        setMultiModel(selectedItems.selectedProject._userAttributes.multiModel)
      } 
      const selectedModel = selectedItems.selectedModel;
      let orderedModels = [selectedModel];
      const models = await IafProj.getModels({ 
        _namespaces: selectedItems.selectedProject._namespaces 
      });
      const otherModels = models?.filter(m => m._id !== selectedModel._id);
      if (otherModels?.length) {
        orderedModels = [...orderedModels, ...otherModels];
      }
      setOrderedModels(orderedModels);
    }

    orderModels();

  }, [selectedItems] );

  const modelOptions = useMemo(() => {
    return orderedModels?.map(m => ({
      value: m?._id,
      label: m?._name,
    }));
  }, [orderedModels]);

  useEffect(() => {
    setCurrentModel(modelOptions[0] || null);
  }, [modelOptions]);

  const updateCurrentProjModel = async () => {
    const newPrimary = orderedModels.find(m => m._id === currentModel.value);
    console.log("newPrimary", newPrimary)
    try {
      IafSession.setSessionStorage('model', newPrimary);
      applicationContext.actions.setSelectedItems({
        selectedModel: newPrimary
      })
    } catch (error) {
      console.error("Error updating project model:", error);
    }
  };

  return (
    <>
      { 
        <div className='models-container'>
          <div>
            <label className="select-label">
              Current Model
            </label>
            <Select
              options={modelOptions}
              onChange={setCurrentModel}
              value={currentModel}
              placeholder={'Select Model'}
            />
          </div>
          { multiModel &&
            <GenericMatButton 
              onClick={updateCurrentProjModel} 
              customClasses='attention telemetry-button'
            >
              Change model
            </GenericMatButton>          
          }
        </div>    
      }
    </> 
  );
};

export default ModelPanel;