/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React from "react"
import {IfefContent, IfefSubHeaderBar} from '@dtplatform/react-ifef';
import {mobiscroll} from '@dtplatform/iaf-lib';
import '@dtplatform/iaf-lib/dist/iaf-lib.css';
import ContainerView from "./ContainerView";

export default class ListView extends React.Component {
  render() {
    const { subtitle, listItem, data, itemTap } = this.props;
    return (
      <ContainerView {...this.props}>
        <IfefSubHeaderBar {...this.props}>
          <h2 className="title">{subtitle}</h2>
        </IfefSubHeaderBar>
        <IfefContent customClasses="padding" {...this.props}>
          <div style={{ height: "calc(88vh - 60px)", overflow: "auto" }}>
            <mobiscroll.Listview
              theme="ios"
              itemType={listItem}
              sortable={true}
              onItemTap={itemTap}
              data={data}
            />
          </div>
        </IfefContent>
      </ContainerView>
    );
  }
}
