


/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, { useState } from "react";
import { useTable } from 'react-table';
import Select from "react-select";
import common from "../../helpers/common";
import { IafItemSvc, IafSession, IafObjectModelAPISvc } from "@dtplatform/platform-api";
import { IafScriptEngine } from "@dtplatform/iaf-script-engine";
import TreeView from "../../helpers/TreeView";
import ModelManager from "./ModelManager";
import "@dtplatform/iaf-lib/dist/iaf-lib.css";
import "./ModelImportView.css";
import MapboxSecretSubmit from "../../components/Input/MapboxSecretSubmit";

class ModelImportView extends React.Component {
  constructor(props) {
    super(props);
    this.DEFAULT_PAGE_NAME = "Model Import";

    this.state = {
      nodeIds: [],
      expanded: [],
      uploadPercentage: null,
      isPageLoading: false, //is the page doign an initial loading
      isPageWorking: false, //is the page doing an operation like import
      isAPIConfigPresent: false,
      apiConfigData: null,
      project: null,
      handler: null,
      bimpks: [], //list of bimpk files in the project with their versions
      bimpkOptions: [], //options for the file select dropdown
      selectedBimpk: null, //selected option from the file select dropdown
      selectedBimpkVersions: [], //the versions of teh selected bimpk file
      columns: [],
      missingRelations: [],
      entitiesMissingRelations: [],
      missingRelationsColumns: [],
      selectedVersionToImport: null, //the version fo the bimpk file which has been selected
      throbberMessage: "",
      bimpkOrch: null, //the bimpk orchestrator in the project
      sgpkOrch: null, //the sgpk orchestrator for navisworks models
      mappingOrch: null, //the orchestrator for mapping model elements to type map
      importIntervalId: null, //interval for polling the import orchestrator
      orchRunStatus: null, //current status fo the orchestrator
      orchStepRunStatus: [], //current status of the current step of the orchestrator
      stepStatus: [], //the current step status of import and link
      createLinks: false,
      file: [], //whether or not we shoudl do auot-linking to documents,
      deleteModal: false,
      deleteVersionModal: false,
      deletePreviousModal: false,
      selectedFiles: null,
      refAppQA: null,
      omapiSelected: null,
      graphQueryData: null,
      secondaryModel: false,
      addBimpk: null,
      multiModel: false
    };
    this.omapiOptions = [
      { value: "Validate Element", label: "Validate Element Height & Width" },
      { value: "View API Config", label: "View API Config" },
      { value: "Model Element Exists", label: "Model Element Exists (custom http error response code)" },
    ];
    this.graphQueryOptions = [
      { value: "Path Building", label: "Path Building" },
      { value: "Path Discovery", label: "Path Discovery" },
    ];

    this._loadAsyncData = this._loadAsyncData.bind(this);
    this.getAPIConfig = this.getAPIConfig.bind(this);
    this.viewAPIConfig = this.viewAPIConfig.bind(this);
    this.validateElementCall = this.validateElementCall.bind(this);
    this.modelElemExistsCall = this.modelElemExistsCall.bind(this);
    this.onOmapiSelectChange = this.onOmapiSelectChange.bind(this);
    this.firePathBuildingQuery = this.firePathBuildingQuery.bind(this);
    this.onGraphQuerySelectChange = this.onGraphQuerySelectChange.bind(this);
    this.handleUpdateProj = this.handleUpdateProj.bind(this);
  }


  handleAddBimpk = (bimpkFile) => {
    console.log('handleAddBimpk, Updating state to true');
    this.setState({
      addBimpk: bimpkFile, 
    });
  };

  handleUpdateProj = (proj) => {
    console.log('handleUpdateProj: ', proj);
    this.props.actions.setSelectedItems({
      selectedProject: proj
    })
  }

  getAllNodes(node, nodes) {
    if (typeof node === "object" && node !== null) {
      if (Array.isArray(node)) {
        node.forEach((item) => this.getAllNodes(item, nodes));
      } else {
        nodes.push(node);
        Object.keys(node).forEach((key) => this.getAllNodes(node[key], nodes));
      }
    }
    return nodes;
  }

  async componentDidMount() {
    console.log("ModelImportView is running now")
    this.setState({ isPageLoading: true });

    await this._loadAsyncData();
    await this.getAPIConfig();

    this.setState(
      {
        isPageLoading: false,
      },
      this.props.onLoadComplete
    );
    const { refAppQA } = await common.refAppQAFlag();
    this.setState({ refAppQA });
  }

  updateSecondaryModel(boolean) {
    this.setState({ secondaryModel: boolean })
  }

  async _loadAsyncData() {
    //Loads data necessary for displaying the page
    let handler = this.props.handler;

    let project = this.props.selectedItems.selectedProject;
    console.log("model import view proj: ", project)

    //update the UI while we load the script after
    await this.setState({ handler, project });
  }

  async getAPIConfig() {
    try {
      let ctx = { isFormData: false };
      let apiConfigUrl = await IafObjectModelAPISvc.getApiConfig(
        { _isconfigadded: true, nsfilter: this.state.project._namespaces[0] },
        ctx
      );
      this.setState({ isAPIConfigPresent: true });
      return apiConfigUrl;
    } catch (error) {
      this.setState({ isAPIConfigPresent: false });
    }
  }

  async viewAPIConfig() {
    let apiConfigUrl = await this.getAPIConfig();
    const result = apiConfigUrl._result[0]._inputconfig;
    this.setState({
      apiConfigData: {
        title: "API CONFIG DATA",
        data: result,
      },
    });
    console.log(this.state.apiConfigData);
  }

  async modelElemExistsCall() {
    try {
      const { project } = await common.getCurrentProjectInfo();
      const NON_EXISTANT_ID = "123a4b567c8d89012ef3g45f";
      const root = endPointConfig.objectModelServiceOrigin;
      const url = `${root}/omapi/${project._namespaces[0]}/modelElements/${NON_EXISTANT_ID}/modelElemExists`;
      const authToken = IafSession.getAuthToken();

      const response = await fetch(url, {
        method: "GET",
        mode: "cors",
        headers: {
          Authorization: "Bearer " + authToken,
        },
      });
      console.log('http response: ', response)

      const jsonData = await response.json();
      console.log('jsonData: ', jsonData)
      this.setState({
        apiConfigData: {
          title: "MODEL ELEMENT EXISTS",
          responseStatus: response.status, 
          data: jsonData,
        },
      });

    } catch (error) {
      console.error("Error:", error);
      this.setState({
        apiConfigData: {
          title: "MODEL ELEMENT EXISTS",
          data: `${error}`,
        },
      });
    }
  }

  // Fetch call to omapi
  async validateElementCall() {
    try {
      const { project, ctx } = await common.getCurrentProjectInfo();
      // Get an sample element that conatins width height property
      const query = {
        $findWithRelated: {
          parent: {
            collectionDesc: {
              _userType: "rvt_element_props",
            },
            query: {
              "properties.Height": { $exists: true },
              "properties.Width": { $exists: true },
            },
            options: {
              page: {
                _pageSize: 1,
                _offset: 0,
                getAllItems: true,
              },
            },
            sort: {
              _id: 1,
            },
          },
        },
      };
      let res = await IafItemSvc.searchRelatedItems(query, ctx);
      console.log('res', res)
      const element = res?._list?.[0]?._versions?.[0]?._relatedItems;
      const id = element._list[0]?._id;

      if (!id) {
        throw new Error("Element not found");
      } else {
        const root = endPointConfig.objectModelServiceOrigin;
        const url = `${root}/omapi/${project._namespaces[0]}/modelElements/${id}/isValidElement`;
        const authToken = IafSession.getAuthToken();

        const response = await fetch(url, {
          method: "GET",
          mode: "cors",
          headers: {
            Authorization: "Bearer " + authToken,
          },
        });

        console.log('http response: ', response)

        if (!response.ok) {
          throw new Error(`HTTP error! status: ${response.status}`);
        }

        const jsonData = await response.json();
        console.log('jsonData: ', jsonData)
        this.setState({
          apiConfigData: {
            title: "VALIDATE ELEMENT RESULT",
            responseStatus: response.status, 
            data: jsonData,
          },
        });
      }
    } catch (error) {
      console.error("Error:", error);
      this.setState({
        apiConfigData: {
          title: "VALIDATE ELEMENT RESULT",
          data: `${error}`,
        },
      });
    }
  }

  onOmapiSelectChange(selectedOption) {
    switch (selectedOption.value) {
      case "Validate Element":
        this.validateElementCall();
        break;
      case "Model Element Exists":
        this.modelElemExistsCall();
        break;
      case "View API Config":
        this.viewAPIConfig();
        break;
    }
  }

  async onGraphQuerySelectChange(selectedOption) {
    switch (selectedOption.value) {
      case "Path Building":
        await this.firePathBuildingQuery();
        break;
      case "Path Discovery":
        await this.firePathDiscoveryQuery();
        break;
      default:
        return null;
    }
  }

  // Construct path building query and trigger
  async firePathBuildingQuery() {
    try {
      const graphQuery = {
        start: {
          collectionDesc: {
            _userType: "rvt_elements",
          },
          options: {
            page: {
              _pageSize: 1,
              _offset: 0,
            },
            project: {
              _id: 1,
            },
          },
        },
        to: {
          segments: [
            {
              relatedDesc: {
                _relatedUserType: "rvt_type_elements",
              },
              as: "Revit_Elems",
              options: {
                project: {
                  _id: 1,
                },
              },
            },
          ],
          as: "paths",
          response: "path",
          options: {
            page: {
              _offset: 0,
            },
          },
        },
      };
      const result = await IafScriptEngine.findWithRelatedGraph(graphQuery);
      console.log("Path Building", result);
      this.setState({
        graphQueryData: {
          title: "PATH BUILDING RESULT",
          data: result,
        },
      });
    } catch (error) {
      this.setState({
        graphQueryData: {
          title: "PATH BUILDING RESULT",
          data: `${error}`,
        },
      });
    }
  }

  // Construct path discovery query and trigger
  async firePathDiscoveryQuery() {
    try {
      const graphQuery = {
        start: {
          collectionDesc: {
            _userType: "rvt_elements",
          },
          query: {
            ElementCategory: "Mechanical and Plumbing Equipment",
          },
          options: {
            page: {
              _pageSize: 1,
            },
            project: {
              _id: 1,
              ElementCategory: 1,
              ElementType: 1,
            },
          },
        },
        to: {
          segments: [
            {
              relatedDesc: {
                _relatedUserType: "rvt_element_props",
              },
              minDepth: 1,
              maxDepth: 5,
              options: {
                project: {
                  ElementCategory: 1,
                  ElementType: 1,
                },
              },
              as: "sys",
            },
          ],
          as: "paths",
          response: "path",
          options: {
            page: {
              _offset: 0,
            },
          },
        },
      };
      const result = await IafScriptEngine.findWithRelatedGraph(graphQuery);
      console.log("Path Discovery", result);
      this.setState({
        graphQueryData: {
          title: "PATH DISCOVERY RESULT",
          data: result,
        },
      });
    } catch (error) {
      this.setState({
        graphQueryData: {
          title: "PATH DISCOVERY RESULT",
          data: `${error}`,
        },
      });
    }
  }

  render() {
    const { apiConfigData, expanded, refAppQA, graphQueryData } = this.state;
    return (
      <div>
        {!this.state.isPageLoading && (
          <div
            className="tableContainer"
            style={{
              paddingLeft: "25%",
              paddingRight: "25%",
              paddingTop: "20px",
              paddingBottom: "20px",
            }}
          >
            {
              <div 
                style={{ 
                  display: "flex", 
                  flexDirection: "column", 
                  alignItems: "center", 
                }}
              >
                <ModelManager { ...this.props } onUpdateProj={(p) => this.handleUpdateProj(p)}/>
              </div>
            } 
            <hr style={{ marginTop: "80px" }} />
            <div
              id="upload-div"
              style={{
                textAlign: "center",
                marginTop: "10px",
                position: "relative",
              }}
            >
              <h4>Mapbox temp token config</h4>
            </div>
            <MapboxSecretSubmit/>
            <hr style={{ marginTop: "80px" }} />
            <div
              style={{
                textAlign: "center",
                marginTop: "10px",
                position: "relative",
              }}
            >
              <h4>Find With Related Graph</h4>
            </div>

            <div
              style={{
                marginTop: "15px",
              }}
            >
              <Select
                name="graphQuerySelect"
                options={this.graphQueryOptions}
                placeholder="Select an option"
                className="custom-single omapi-select"
                classNamePrefix="select"
                onChange={this.onGraphQuerySelectChange}
              />
            </div>
            {graphQueryData && (
              <TreeView
                treeData={graphQueryData.data}
                title={graphQueryData.title}
              />
            )}

            <hr style={{ marginTop: "80px" }} />
            <div
              id="upload-div"
              style={{
                textAlign: "center",
                marginTop: "10px",
                position: "relative",
              }}
            >
              <h4>Manage Object Model API Config</h4>
            </div>
            <div
              style={{
                marginTop: "15px",
              }}
            >
              <Select
                name="omapiSelect"
                options={this.omapiOptions}
                placeholder="Select an option"
                className="custom-single omapi-select"
                classNamePrefix="select"
                onChange={this.onOmapiSelectChange}
                isDisabled={!this.state.isAPIConfigPresent}
              />
            </div>
            {apiConfigData && (
              <TreeView
                treeData={apiConfigData.data}
                title={apiConfigData.title}
                responseStatus={apiConfigData.responseStatus}
              />
            )}
          </div>
        )}
      </div>
    );
  }
}

export default ModelImportView;
