/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, { useState } from "react";
import { useTable } from 'react-table';
// import "react-table/react-table.css";
import Select from "react-select";
import moment from "moment";
import { mobiscroll } from "@dtplatform/iaf-lib";
import DeleteConfirmationDialog from "../../helpers/DeleteConfirmationDialog";
import common from "../../helpers/common";
import {
  IafProj,
  IafFileSvc,
  IafDataSource,
  IafItemSvc,
  IafSession,
  IafFile,
  IafObjectModelAPISvc,
} from "@dtplatform/platform-api";
import { IafLocalFile, IafDataPlugin } from "@dtplatform/ui-utils";
import { IafScriptEngine } from "@dtplatform/iaf-script-engine";
import "@dtplatform/iaf-lib/dist/iaf-lib.css";
import { AppContext, ScriptHelper } from "@dtplatform/platform-app-conflux/modules/IpaUtils";
import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import "./ModelImportView.css";
import ProgressBar from "../../helpers/ProgressBar";
import DeleteRejectionDialog from "../../helpers/DeleteRejectionDialog";
import LongBimpkNameModal from "../../helpers/LongBimpkNameModal";
import LoadNewModelModal from "../../helpers/LoadNewModelModal";
import ModelLimitModal from "../../helpers/ModelLimitModal";

const TableComponent = ({ columns, data }) => {
  const tableInstance = useTable({ columns, data });

  return (
    <table className="-striped">
      <thead>
        {tableInstance.headerGroups.map(headerGroup => (
          <tr {...headerGroup.getHeaderGroupProps()}>
            {headerGroup.headers.map(column => (
              <th {...column.getHeaderProps()}>{column.render('Header')}</th>
            ))}
          </tr>
        ))}
      </thead>
      <tbody>
        {tableInstance.rows.map(row => {
          tableInstance.prepareRow(row);
          return (
            <tr {...row.getRowProps()}>
              {row.cells.map(cell => (
                <td {...cell.getCellProps()}>{cell.render('Cell')}</td>
              ))}
            </tr>
          );
        })}
      </tbody>
    </table>
  );
};

class ModelManager extends React.Component {
  constructor(props) {
    super(props);
    this.DEFAULT_PAGE_NAME = "Model Import";

    this.state = {
      nodeIds: [],
      expanded: [],
      uploadPercentage: null,
      isPageLoading: false, //is the page doign an initial loading
      isPageWorking: false, //is the page doing an operation like import
      isAPIConfigPresent: false,
      apiConfigData: null,
      project: null,
      handler: null,
      bimpks: [], //list of bimpk files in the project with their versions
      bimpkOptions: [], //options for the file select dropdown
      selectedBimpk: null, //selected option from the file select dropdown
      selectedBimpkVersions: [], //the versions of teh selected bimpk file
      columns: [],
      missingRelations: [],
      entitiesMissingRelations: [],
      missingRelationsColumns: [],
      selectedVersionToImport: null, //the version fo the bimpk file which has been selected
      throbberMessage: "",
      bimpkOrch: null, //the bimpk orchestrator in the project
      sgpkOrch: null, //the sgpk orchestrator for navisworks models
      mappingOrch: null, //the orchestrator for mapping model elements to type map
      importIntervalId: null, //interval for polling the import orchestrator
      orchRunStatus: null, //current status fo the orchestrator
      orchStepRunStatus: [], //current status of the current step of the orchestrator
      stepStatus: [], //the current step status of import and link
      createLinks: false,
      file: [], //whether or not we shoudl do auot-linking to documents,
      deleteLastModal: false,
      deleteModal: false,
      deleteVersionModal: false,
      deletePreviousModal: false,
      numPermittedModelsModal: false,
      longBimpkNameModal: false,
      selectedFiles: null,
      refAppQA: null,
      defaultSelected: null,
      showBimpkNameModal: false,
      projectModels: null,
      restartIfLastModel: false,
      newModel: null,
      loadNewModelModal: false
    };

    this._loadAsyncData = this._loadAsyncData.bind(this);
    this.prepData = this.prepData.bind(this);
    this._getOrchs = this._getOrchs.bind(this);
    this.onModelChange = this.onModelChange.bind(this);
    this.isCurrentModelAndVersion = this.isCurrentModelAndVersion.bind(this);
    this.isTipVersion = this.isTipVersion.bind(this);
    this.onVersionChecked = this.onVersionChecked.bind(this);
    this.uncheckAllVersions = this.uncheckAllVersions.bind(this);
    this.onImport = this.onImport.bind(this);
    this.onRemap = this.onRemap.bind(this);
    this.uploadExcelAndRemap = this.uploadExcelAndRemap.bind(this);
    this.deleteBimpk = this.deleteBimpk.bind(this);
    this.UploadBimpk = this.UploadBimpk.bind(this);
    this.onMissingEntitiesRequest = this.onMissingEntitiesRequest.bind(this);
    this._getMissingRelations = this._getMissingRelations.bind(this);
    this.onMissingEntitiesDownload = this.onMissingEntitiesDownload.bind(this);
    this.runOrchestrator = this.runOrchestrator.bind(this);
    this.getOrchStatus = this.getOrchStatus.bind(this);
    this.handleError = this.handleError.bind(this);
    this.handleClose = this.handleClose.bind(this);
    this.cancelUpload = this.cancelUpload.bind(this);
    this.deleteFirstVersionAndUploadNewVersion =
    this.deleteFirstVersionAndUploadNewVersion.bind(this);
    this.deleteOldModelAndUploadNewModel =
    this.deleteOldModelAndUploadNewModel.bind(this);
    this.uploadFile = this.uploadFile.bind(this);
    this.removeModelFromState = this.removeModelFromState.bind(this);
    this.addOtherColls = this.addOtherColls.bind(this);
    this.pollOrchestrator = this.pollOrchestrator.bind(this);
    this.cancelNewModelLoad = this.cancelNewModelLoad.bind(this);
    this.loadNewModel = this.loadNewModel.bind(this);
  }

  getAllNodes(node, nodes) {
    if (typeof node === "object" && node !== null) {
      if (Array.isArray(node)) {
        node.forEach((item) => this.getAllNodes(item, nodes));
      } else {
        nodes.push(node);
        Object.keys(node).forEach((key) => this.getAllNodes(node[key], nodes));
      }
    }
    return nodes;
  }

  async componentDidMount() {
    this.setState({ isPageLoading: true });
    console.log("ModelManager running...")
    console.log("ModelManager props: ", this.props)
    console.log("ModelManager state: ", this.state)

    await this._loadAsyncData();
    await this.prepData();
  }

  removeModelFromState(bimpkName) {
    //rm from bimpks
    console.log('this.state.bimpks:', this.state.bimpks)
    const updatedBimpks = this.state.bimpks.filter(b => !b._name.includes(bimpkName));
    console.log('updatedBimpks:', updatedBimpks)
    //rm from bimpkOpts
    console.log('this.state.bimpkOptions:', this.state.bimpkOptions)
    const updatedBimpkOpts = this.state.bimpkOptions.filter(b => !b.label.includes(bimpkName));
    console.log('updatedBimpkOpts:', updatedBimpkOpts)
    this.setState({
      bimpks: updatedBimpks,
      bimpkOptions: updatedBimpkOpts,
      selectedBimpk: updatedBimpkOpts[0]
    })
  }

  async loadNewModel(){
    const project = this.props.selectedItems.selectedProject;
    IafSession.setSessionStorage('model', this.state.newModel);
    console.log('restarting app')
    this.props.actions.restartApp()
  }
  
  cancelNewModelLoad(){
    this.setState({
      loadNewModelModal: false
    })
  }

  async _loadAsyncData() {
    //Loads data necessary for displaying the page
    let handler = this.props.handler;

    let project = this.props.selectedItems.selectedProject;

    this._getOrchs();

    //this._getMissingRelations();

    //get all bimpk files in the current project
    let bimpkCriteria = {
      _namespaces: project._namespaces,
      _name: ".*\.bimpk",
    };

    console.log("running getBimpks")
    let getBimpks = await IafFileSvc.getFiles(bimpkCriteria, null, {
      _pageSize: 100,
    });
    let bimpks = getBimpks._list;
    console.log("getBimpks: ", getBimpks)

    //get all bimpk files in the current project
    let sgpkCriteria = {
      _namespaces: project._namespaces,
      _parents: "root",
      _name: ".*sgpk",
    };

    let getSgpks = await IafFileSvc.getFiles(sgpkCriteria, null, {
      _pageSize: 100,
    });
    let sgpks = getSgpks._list;

    let modelFiles = [...bimpks, ...sgpks];

    //for each bimpk file
    //1. get its name with no extension
    //2. get its versions
    //3. sort the versions newest at top
    //4. for each version create a nice create date for display
    //5. set a property to be used in the table for the check box being checked or not
    for (var i = 0; i < modelFiles.length; i++) {
      let modelFile = modelFiles[i];

      modelFile.nameNoExt = modelFile._name
      let getVersions = await IafFileSvc.getFileVersions(modelFile._id);
      let versions = getVersions._list;
      console.log("versions: ", versions)

      //sort versions descending
      versions.sort((a, b) => {
        return b._version - a._version;
      });

      versions.forEach((ver) => {
        let created = moment(ver._metadata._createdAt);
        ver.displayCreateDate = created.format("MMM D YYYY, h:mm a");
        ver.checked = false;
      });

      modelFiles[i].versions = versions;
    }

    //update the UI while we load the script after
    await this.setState({ handler, project, bimpks: modelFiles });
  }

  async prepData() {

   //create options for dropdown menu for model
   let bimpkOptions = [{ value: "none", label: "No Models in Project" }];

   if (this.state.bimpks.length > 0) {
     bimpkOptions = this.state.bimpks.map((bimpk) => {
       return { value: bimpk._id, label: bimpk.nameNoExt };
     });
   }
   console.log('bimpkOptions: ', bimpkOptions)

  let defaultSelection = bimpkOptions[0];

   console.log('this.props.selectedItems.selectedModel: ', this.props.selectedItems.selectedModel)
   if (
     !!this.props.selectedItems.selectedModel &&
     Object.entries(this.props.selectedItems.selectedModel).length !== 0
   ) {
     let defaultSelections = bimpkOptions.filter((opt) => {
       return opt.label.includes(this.props.selectedItems.selectedModel._name);
     });
     console.log('defaultSelections: ', defaultSelections)
     if (defaultSelections.length) {
      defaultSelection = defaultSelections[0];
      } else {
        defaultSelection = bimpkOptions[0]
      }
   } 
   //get the version of the model for display
   let bversions = [];
   for (var i = 0; i < this.state.bimpks.length; i++) {
     if (this.state.bimpks[i]._id === defaultSelection.value) {
       bversions = this.state.bimpks[i].versions;
       break;
     }
   }

   let columns = [
     {
       Header: "",
       width: 50,
       id: "status",
       Cell: (row) => {
         return this.isCurrentModelAndVersion(row) ? (
           <div>
             <i
               title="Current Version"
               style={{ fontSize: "21px", color: "green" }}
               className="icon ion-arrow-right-a"
             ></i>
           </div>
         ) : this.isTipVersion(row) ? (
           <div>
             <input
               type="checkbox"
               checked={row.row.original.checked}
               onChange={() => this.onVersionChecked(row)}
               disabled={this.state.isPageWorking}
             />
           </div>
         ) : (
           <div>-</div>
         );
       },
       style: {
         textAlign: "center",
       },
     },
     {
       Header: "Version",
       width: 100,
       accessor: "_version",
       style: {
         textAlign: "center",
       },
       id: "version",
     },
     {
       Header: "Created on",
       accessor: "displayCreateDate",
       headerStyle: {
         textAlign: "left",
       },
       id: "createdon",
     },
   ];

   let missingRelationsColumns = [
     {
       Header: "Entity Type",
       width: 100,
       accessor: "EntityType",
       style: {
         textAlign: "center",
       },
       id: "entityType",
     },
     {
       Header: "Name",
       accessor: "Name",
       headerStyle: {
         textAlign: "left",
       },
       id: "name",
     },
   ];
   console.log("setting mm state ",  this.state)
   console.log({
     'bimpkOptions': bimpkOptions,
     'selectedBimpk': defaultSelection,
     'selectedBimpkVersions': bversions,
     'columns': columns,
     'isPageLoading': false,
     'missingRelationsColumns': missingRelationsColumns,
   })
   this.setState(
     {
       bimpkOptions: bimpkOptions,
       selectedBimpk: defaultSelection,
       selectedBimpkVersions: bversions,
       columns: columns,
       isPageLoading: false,
       missingRelationsColumns: missingRelationsColumns,
     },
     this.props.onLoadComplete
   );
   console.log("setting mm state ",  this.state)
   if (!this.state.selectedBimpk) {
     this.setState({ selectedBimpk: defaultSelection });
   }
   const { refAppQA } = await common.refAppQAFlag();
   this.setState({ refAppQA });
  }

  async _getOrchs() {
    //get the bimpk orcehstrator
    let bimpkOrch = null;
    let sgpkOrch = null;
    let mappingOrch = null;
    let datasources = await IafDataSource.getOrchestrators();

    //find the bimpk orchestrator
    if (datasources) {
      bimpkOrch = _.find(datasources._list, { _userType: "bimpk_import" });
      sgpkOrch = _.find(datasources._list, { _userType: "sgpk_uploader" });
      mappingOrch = _.find(datasources._list, {
        _userType: "map_revit_type",
      });
    }

    this.setState({ bimpkOrch, sgpkOrch, mappingOrch });
  }

  onModelChange(selectedOption) {
    //when a new model is changed get the selected model's versions for the table
    if ((this.state.selectedBimpk == null) || (selectedOption.value !== this.state.selectedBimpk?.value)) {
      this.uncheckAllVersions();
      let bversions = [];
      for (var i = 0; i < this.state.bimpks.length; i++) {
        if (selectedOption.value === this.state.bimpks[i]._id) {
          bversions = this.state.bimpks[i].versions;
          break;
        }
      }
      console.log("bversions: ", bversions)
      this.setState({
        selectedBimpk: selectedOption,
        selectedBimpkVersions: bversions,
      });
    }
  }

  uncheckAllVersions() {
    let { bimpks } = this.state;

    bimpks.forEach((bimpk) => {
      bimpk.versions.forEach((ver) => {
        ver.checked = false;
      });
    });

    this.setState({ bimpks: bimpks, selectedVersionToImport: null });
  }

  onVersionChecked(checkedRow) {
    //check the selected version and uncheck all others

    let { bimpks } = this.state;
    let checkedVer = checkedRow.row.original;

    if (
      !this.selectedVersionToImport ||
      (!!this.selectedVersionToImport &&
        checkedVer._id !== this.selectedVersionToImport._id)
    ) {
      bimpks.forEach((bimpk) => {
        bimpk.versions.forEach((ver) => {
          if (checkedVer._id === ver._id) {
            ver.checked = !ver.checked;
          } else {
            ver.checked = false;
          }
        });
      });

      this.setState({ bimpks: bimpks, selectedVersionToImport: checkedVer });
    }
  }

  isCurrentModelAndVersion(row) {
    let result = false;
    if (this.state.selectedBimpk && this.props.selectedItems.selectedModel) {
      if (
        this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/,"") ===
        this.props.selectedItems.selectedModel._name
      ) {
        //get current version of model
        let selectedModelVersion = _.find(
          this.props.selectedItems.selectedModel._versions,
          { _id: this.props.selectedItems.selectedModel._tipId }
        );
        if (
          selectedModelVersion._userAttributes &&
          selectedModelVersion._userAttributes.bimpk
        ) {
          return (
            row.row.original._id ===
            selectedModelVersion._userAttributes.bimpk.fileVersionId
          );
        }
      }
    }

    return result;
  }

  isTipVersion(row) {
    try {
      let result = false;
      
      if (this.state.selectedBimpk) {
        let bimpk = _.find(this.state.bimpks, {
          _id: this.state.selectedBimpk.value,
        });
        result = bimpk._tipId === row.row.original._id;
      }
      return result;      
    } catch (e) {
      console.log('no tip version for row')
    }
  }

  async onImport() {
    /*
          1. Get the model file extension to know what type of import to run
          2. Get the correct orchestrator to run from the state
          3. From the orchestrator get the task sequence type id
          4. call IafDataSource.runOrchestrator with the orchectrator id, sequence type id, fileid, and fileversionid and get a runid back
          5. poll IafDataSource.getOrchRunStatus(runid) and IafDataSource.getOrchRunStepStatus(runid) to find out when the orchestrator has completed
      */

    this.setState({
      isPageWorking: true,
      orchRunStatus: null,
      orchStepRunStatus: [],
      throbberMessage: "Importing Model",
    });

    //get the currently selected model file to import from state
    let modelFile = _.find(this.state.bimpks, {
      _id: this.state.selectedBimpk.value,
    });
    let modelFileExtension = (modelFile.nameNoExt = modelFile._name
      .split(".")
      .pop());

    let orch = null;
    let orchStepName = null;
    if (modelFileExtension === "bimpk") {
      orch = this.state.bimpkOrch;
      orchStepName = "default_script_target";
    } else if (modelFileExtension === "sgpk") {
      orch = this.state.bimpkOrch;
      orchStepName = "default_script_target";
    }

    //find the extractor task and get the seqtypeid (all tasks should be the same
    let task = _.find(orch.orchsteps, { _name: orchStepName });
    let seqTypeId = task._compid;
    // add warning if version is not selected
    let req = {
      orchestratorId: orch.id,
      _actualparams: [
        {
          sequence_type_id: seqTypeId,
          params: {
            _fileId: modelFile._id,
            _fileVersionId: this.state.selectedVersionToImport.fileVersionId
              ? this.state.selectedVersionToImport.fileVersionId
              : this.state.selectedVersionToImport._id,
          },
        },
      ],
    };
    let ctx = { isFormData: false };
    this.runOrchestrator(orch, req, ctx);
    // this.setState({
    //   isPageWorking: false,
    //   orchRunStatus: null,
    //   orchStepRunStatus: [],
    //   throbberMessage: "Importing Model",
    // });
  }

  async addOtherColls(model) {
    const ctx = { _namespaces: this.props.selectedItems.selectedProject._namespaces };

    const createTelemColl = async (elemColl, telemElems) => {
      let modelName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '')
      // Telemetry Collection
      console.log('telemColl modelName', modelName)
      const telemColl =
        await IafItemSvc.createNamedUserItems(
          [
            {
              _name: `${modelName} Telemetry Collection`,
              _shortName: "telemetry_coll",
              _description:
                "Named Telemetry Collection to store sensor and points data",
              _namespaces: ctx._namespaces,
              _userType: "ref_app_telementary_collection",
              _tsProperties: {
                _granularity: "minutes",
                _expiry: 1440,
              },
            },
          ],
          "NamedTelemetryCollection",
          ctx
        );
      console.log(
        `Started createTelementaryCollection`,
        "createTelementaryCollection ==== Created Telemetry collection response.",
        telemColl
      );

      if (telemElems.length > 0) {
        //* Telemetry Collection Relations
        let telemRelatedItems = [
          {
            floorname: "2nd Floor",
            roomname: "Lab",
            _sourceId: "e3e052f9-0156-11d5-9301-0000863f27ad-00000131",
          },
        ];

        let telementryRelatedItems =
          await IafItemSvc.createRelatedItems(
            telemColl._list[0]._id,
            telemRelatedItems,
            ctx
          );
        console.log(
          "createTelementaryCollection ==== Telementry RelatedItems response.",
          telementryRelatedItems
        );

        let relationShipsSensor1 = [
          {
            _relatedFromId: telemElems[0]._id, // parent id
            _relatedToIds: telementryRelatedItems._list.map((item) => item._id), // children from tip version
            _relatedUserItemDbId: telemColl._list[0]._id,
          },
        ];

        console.log(
          "relationShipsSensor1",
          relationShipsSensor1
        );

        let relationsSensor1 = await IafItemSvc.addRelations(
          elemColl._itemId,
          relationShipsSensor1,
          ctx
        );
        console.log(
          `Completed createTelementaryCollection`,
          "createTelementaryCollection ==== Telementry add relations response.",
          relationsSensor1
        );
        let relationShipsSensor2 = [
          {
            _relatedFromId: telemElems[1]._id, // parent id
            _relatedToIds: telementryRelatedItems._list.map((item) => item._id), // children from tip version
            _relatedUserItemDbId: telemColl._list[0]._id,
          },
        ];
        console.log(
          "relationShipsSensor2",
          relationShipsSensor2
        );
        // To create relation between pump element id,sensor data and collection
        let relationsSensor2 = await IafItemSvc.addRelations(
          elemColl._itemId,
          relationShipsSensor2,
          ctx
        );
        console.log(
          `Completed createTelementaryCollection`,
          "createTelementaryCollection ==== Telementry add relations response.",
          relationsSensor2
        );
        return true
      }
    };

    const createIotColl = async (elemColl, telemElems) => {
      let modelName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '')
      let IotCollection = await IafItemSvc.createNamedUserItems(
        [
          {
            _name: `${modelName} Telemetry Collection`,
            _shortName: "telementary_coll",
            _description:
              "Named Telemetry Collection to store sensor and points data",
            _namespaces: this.props.selectedItems.selectedProject._namespaces,
            _userType: "ref_app_iot_collection",
            _tsProperties: {
              _granularity: "minutes",
              _expiry: 1440,
            },
          },
        ],
        "NamedTelemetryCollection",
        ctx
      );
      console.log(
        `Started createIotCollection`,
        "createIotCollection ==== Created Iot collection response.",
        IotCollection
      );
      IotCollection = IotCollection._list[0];
      
      if (telemElems.length > 0) {
        //* Iot Collection Relations
        let relatedItemsIot = [
          {
            floorname: "2nd Floor",
            roomname: "Lab",
            _sourceId: "e3e052f9-0156-11d5-9301-0000863f27ad-00000131",
          },
        ];

        let IotRelatedItems = await IafItemSvc.createRelatedItems(
          IotCollection._id,
          relatedItemsIot,
          ctx
        );
        console.log(
          "createIotCollection ==== Iot RelatedItems response.",
          IotRelatedItems
        );

        let relationShipsSensorIot = [
          {
            _relatedFromId: telemElems[0]._id, // parent id
            _relatedToIds: IotRelatedItems._list.map((item) => item._id), // children from tip version
            _relatedUserItemDbId: IotCollection._id,
          },
        ];

        let relationsSensorIot = await IafItemSvc.addRelations(
          elemColl._itemId,
          relationShipsSensorIot,
          ctx
        );
        console.log(
          `Completed createIotCollection`,
          "createIotCollection ==== Iot add relations response.",
          relationsSensorIot
        );
        let relationShipsSensorIot2 = [
          {
            _relatedFromId: telemElems[1]._id, // parent id
            _relatedToIds: IotRelatedItems._list.map((item) => item._id), // children from tip version
            _relatedUserItemDbId: IotCollection._id,
          },
        ];
        // To create relation between pump element id,sensor data and collection
        let relationsSensorIot2 = await IafItemSvc.addRelations(
          elemColl._itemId,
          relationShipsSensorIot2,
          ctx
        );
        console.log(
          `Completed createIotCollection`,
          "createIotCollection ==== Iot add relations response.",
          relationsSensorIot2
        );
        return true
      }
      
    };

    const createTelemAndIotColls = async (model, elemColl) => { 
      //fetching TelemetryElement 
      let telemElemBimQuery = {
        parent: {
          collectionDesc: {
            _userType: "rvt_elements",
            _userItemId: elemColl._userItemId,
          },
          options: {
            page: {
              getAllItems: true,
            },
          },
          sort: {
            _id: 1,
          },
          query: {
            ElementCategory: { $in: ["Sensor"] },
          },
        },
      };
      let telemElems = await IafScriptEngine.findWithRelated(telemElemBimQuery, ctx);
      console.log("telemElements", telemElems);
      telemElems = telemElems._list
      try {
        await createTelemColl(elemColl, telemElems);
      } catch (e) {
        console.log('createTelemColl error', e)
      }
      try {
        await createIotColl(elemColl, telemElems);
      } catch (e) {
        console.log('createIotColl error', e)
      }
      
      return true
    }

    const addWarranties = async (model, elemColl) => {
      //creating warranty collection and relating warranty data
      let modelName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '')
      let Coll_info = {
        Name: `${modelName} Element Warranty Data`,
        ShortName: "war_data",
        Description: "Element Warranty Data",
        userType: "iaf_dt_warranty_coll",
      };

      let data_obj_coll = await IafScriptEngine.createOrRecreateCollection(
        {
          _name: Coll_info.Name,
          _shortName: Coll_info.ShortName,
          _namespaces: ctx._namespaces,
          _description: Coll_info.Description,
          _userType: Coll_info.userType,
        },
        ctx
      );
      console.log(
        "createWarrantyAndElementRelation ==== data_obj_coll",
        data_obj_coll
      );
      // //fetching door elements
      let bimQuery = {
        parent: {
          collectionDesc: {
            _userType: "rvt_elements",
            _userItemId: elemColl._userItemId,
          },
          options: { page: { getAllItems: true } },
          sort: { _id: 1 },
          query: { ElementCategory: { $in: ["Door - External"] } },
        },
      };
      const matchingElems = await IafScriptEngine.findWithRelated(bimQuery, ctx);
      console.log("fetchOSTDoors ==== elements", matchingElems);
        
      let dataObject = {
        properties: {
          "Warranty Description": {
            dName: "Warranty Description",
            val: "The manufacturer warrants this product to be free from defects in workmanship and materials, under normal residential use and conditions, for a period of one (1) year for the original invoice date",
            type: "text",
            epoch: null,
          },
          "Warranty Start Date": {
            dName: "Warranty Start Date",
            val: "09-11-2022",
            type: "date",
          },
          "Warranty Duration": {
            dName: "Warranty Duration",
            val: "1 year",
            type: "text",
          },
        },
      };

      let flatAllDataObjs;
      if (matchingElems._list.length > 0) {
        flatAllDataObjs = new Array(matchingElems._list.length).fill(
          dataObject
        );

        console.log('flatAllDataObjs', flatAllDataObjs)
  
        let data_obj_res = await IafScriptEngine.createItemsBulk(
          {
            _userItemId: data_obj_coll._userItemId,
            _namespaces: ctx._namespaces,
            items: flatAllDataObjs,
          },
          ctx
        );
        console.log(
          "createWarrantyAndElementRelation ==== data_obj_res",
          data_obj_res
        );
        warrantyColls.push(data_obj_res);
        //CREATE ITEMS BULK DOESNT RETURN THE CREATED OBJECTS IT RETURNS URIS FOR THE OBJECTS
        //SO GET ALL THOSE IN ONE LIST WHICH WE WILL USE TO GET THE NEW OBJECT IDS OFF THE END
  
        // Get all _uris from data_obj_res[0] and flatten them into a single array
        const allURIs = data_obj_res[0].flatMap((d) => d._uris);
        console.log("createWarrantyAndElementRelation ==== allURIs", allURIs);
  
        // Extract the last part of each URI to get dataObjIds
        const dataObjIds = allURIs.map((u) => u.split("/").pop());
        console.log(
          "createWarrantyAndElementRelation ==== dataObjIds",
          dataObjIds
        );
        // Combine matchingElems and dataObjIds into an array of tuples
        const assetsWithDataIds = matchingElems._list.map((e, i) => [
          e,
          dataObjIds[i],
        ]);
        console.log(
          "createWarrantyAndElementRelation ==== assetsWithDataIds",
          assetsWithDataIds
        );
  
        // Create an array of related items with parentItem and relatedItems properties
        const warrRelatedItems = assetsWithDataIds.map((d) => {
          return { parentItem: d[0], relatedItems: [{ _id: d[1] }] };
        });
        console.log(
          "createWarrantyAndElementRelation ==== warrRelatedItems",
          warrRelatedItems
        );
  
        const relations = await IafScriptEngine.createRelations(
          {
            parentUserItemId: elemColl._userItemId,
            _userItemId: data_obj_coll._userItemId,
            _namespaces: ctx._namespaces,
            relations: warrRelatedItems,
          },
          ctx
        );
        console.log("createWarrantyAndElementRelation ==== relations", relations);
  
        //GET AN ASSET WITH THE RELATED DATA AS A TEST
        const testAsset = await IafScriptEngine.findWithRelated(
          {
            parent: {
              query: { _id: matchingElems._list[0]._id },
              collectionDesc: { _userItemId: elemColl._userItemId },
              options: { page: { getAllItems: true } },
            },
            related: [
              {
                relatedDesc: { _relatedUserType: data_obj_coll._userType },
                as: "Related Data Object",
              },
            ],
          },
          ctx
        );
        console.log(
          "createWarrantyAndElementRelation ==== testAsset for Warranty Collection : ",
          testAsset._list[0]
        );
        console.log(
          "Completed createWarrantyAndElementRelation.",
          "createWarrantyAndElementRelation ==== testAsset for Warranty Collection : ",
          testAsset._list[0]
        );
      }
    }

    try {
      const elemColl =
        await IafScriptEngine.getCollectionInComposite(
          model._id,
          { _userType: "rvt_elements" },
          ctx
        );
      console.log(
        "createTelemAndIotColls === elemColl",
        elemColl
      );
      await createTelemAndIotColls(model, elemColl);
      await addWarranties(model, elemColl);

      //onBimpkAdd(uploadedBimpk)
    } catch (e) {
      console.log("Error creating other collections", e);
    }
  }

  async onRemap() {
    this.setState({
      isPageWorking: true,
      orchRunStatus: null,
      orchStepRunStatus: [],
      throbberMessage: "Remapping Model",
    });
    const selectedBimpkName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '');

    const models = await IafProj.getModels({
      _namespaces: this.props.selectedItems.selectedProject._namespaces
    });

    console.log(
      "models:", models
    );

    const modelQuery =  {
      query: {
        _userType: "bim_model_version",
        _name: selectedBimpkName,
        _namespaces: {
          $in: this.props.selectedItems.selectedProject._namespaces,
        },
        _itemClass: "NamedCompositeItem",
      },
    }
    console.log('model query: ', modelQuery)
    //Get bimpk's imported model
    const model = await IafScriptEngine.getCompositeCollection(
      modelQuery,
      { _namespaces: this.props.selectedItems.selectedProject._namespaces },
      { getLatestVersion: true }
    );

    console.log(
      "model:", model
    );

    if (model) {
      console.log('running type map orchestrator')
      let { mappingOrch } = this.state;
      //find the extractor task and get the seqtypeid (all tasks should be the same
      let task = _.find(mappingOrch.orchsteps, {
        _name: "Map type map to elements",
      });
      let seqTypeId = task._compid;

      let req = {
        orchestratorId: mappingOrch.id,
        _actualparams: [
          {
            sequence_type_id: seqTypeId,
            params: {
              bimModel: model
            }
          },
        ],
      };

      let ctx = { isFormData: false };

      const pollRes = await this.runPolledOrchestrator(mappingOrch, req, ctx);  

      return pollRes;
      
    } else {
      console.log('model not found: ', model)
    }
  }

  async uploadExcelAndRemap() {
    this.setState({
      isPageWorking: true,
      orchRunStatus: null,
      orchStepRunStatus: [],
      throbberMessage: "Remapping Model",
    });

    const createModelIndexes = async (modelCompositeUserItemId) => {
      let collectionInComposite = await IafScriptEngine.getCollectionInComposite(
        modelCompositeUserItemId,
        { _userType: "rvt_type_elements" },
        ctx
      );
      console.log(
        "Create index ==== getCollectionInComposite.",
        collectionInComposite
      );
  
      // Revit
      let indexRes = await IafScriptEngine.createOrRecreateIndex(
        {
          // model type elememt colletcion
          _id: collectionInComposite._userItemId,
          indexDefs: [
            {
              key: { "Element Category": 1 },
              options: {
                name: "model_els_coll_id",
                default_language: "english",
              },
            },
          ],
        },
        ctx
      );
      console.log(
        "Completed createIndex.",
        "Create index ==== Create Or Recreate Index Index response.",
        indexRes
      );

      return indexRes._list[0];
    };
    
    //Get type map file from user
    let ctx = { isFormData: false };
    const project = this.props.selectedItems.selectedProject;
    const xlsxFiles = await IafLocalFile.selectFiles({
      multiple: false,
      accept: ".xlsx",
    });
    const typeWorkbook = await IafDataPlugin.readXLSXFiles(xlsxFiles);
    const wbJSON = await IafDataPlugin.workbookToJSON(typeWorkbook[0]);
    const iaf_dt_grid_data = wbJSON.Sheet1;
    const iaf_dt_grid_as_objects = IafDataPlugin.parseGridData({
      gridData: iaf_dt_grid_data,
    });
    console.log('iaf_dt_grid_as_objects', iaf_dt_grid_as_objects)

    let typeMapName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '')

    // const models = await IafProj.getModels({
    //   _namespaces: this.props.selectedItems.selectedProject._namespaces
    // });
    // console.log(
    //   "models:", models
    // );

    ctx._namespaces = this.props.selectedItems.selectedProject._namespaces;

    const modelQuery = {
      query: {
        _userType: "bim_model_version",
        _name: typeMapName,
        _namespaces: {
          $in: project._namespaces,
        },
        _itemClass: "NamedCompositeItem",
      },
    };
    console.log(
      "modelQuery:", modelQuery
    );

    //Get bimpk's imported model
    let compositeCollection = await IafScriptEngine.getCompositeCollection(
      modelQuery,
      ctx,
      { getLatestVersion: true }
    );
    //if not found by name, get latest model
    if (!compositeCollection) {
      compositeCollection = await IafScriptEngine.getCompositeCollection(
        {
          query: {
              "_userType": "bim_model_version",
              "_namespaces": { "$in": project._namespaces },
              "_itemClass": "NamedCompositeItem",
          }
        }, 
        { _namespaces: project._namespaces }, 
        { getLatestVersion: true }
      );
    }

    console.log(
      "getCompositeCollection:", compositeCollection
    );

    //create indexes
    const indexRes = await createModelIndexes(compositeCollection._userItemId);
    console.log(
      "indexRes:", indexRes
    );
 
    //create type map collection
    const atm_defs_coll = await IafScriptEngine.createOrRecreateCollection(
      {
        _name: typeMapName,
        _shortName: 'typemap_defs',
        _namespaces: project._namespaces,
        _description: 'Revit Element Type Map Collection',
        _userType: 'iaf_ref_type_map_defs_coll'
      }, 
      ctx
    )
    console.log("Type Map Collection", atm_defs_coll)
    let atm_defs_items_res;

    async function createItems() {
      //create type map items
      const itemsReq = {
        _userItemId: atm_defs_coll._userItemId,
        items: iaf_dt_grid_as_objects,
      };
      console.log("itemsReq", itemsReq)
      console.log("ctx", ctx)
      
      try {
        const bulkItems = await IafScriptEngine.createItemsBulk(
          itemsReq,
          {_namespaces: project._namespaces}
        );
        console.log("bulkItems", bulkItems);
        atm_defs_items_res = bulkItems;
        return bulkItems
      } catch (e) {
        console.log("bulkItems error: ", e)
      }
      console.log("addTypeMap === atm_defs_items_res", atm_defs_items_res);
    }

    const typeItems = await createItems();
    console.log("typeItems: ", typeItems)
    const typeMapData = {
      typeMapCollection: atm_defs_coll,
      typeObjects: atm_defs_items_res
    };
    console.log('Type map data: ', typeMapData)
   
    await this.onRemap();
    this.setState({ newModel: compositeCollection })
    await this.addOtherColls(compositeCollection)
    const latestModels = await IafProj.getModels({ _namespaces: project._namespaces });
    await this.updateSessionProj(
      this.props.selectedItems.selectedProject, 
      latestModels
    )
    // if (updatedSessionProj) { this.setState({ loadNewModelModal: true }) }
    this.setState({ loadNewModelModal: true })
  }

  async deleteBimpk() {
    this.setState({ 
      isPageWorking: false, 
      deleteModal: false,
      deleteLastModal: false 
    });
    let ctx = { isFormData: false };
    const delFileRes = await IafFileSvc.deleteFile(
      this.state.selectedBimpk.value,
      ctx
    );
    if (delFileRes.includes('ok')) {
      const modelName = this.state.selectedBimpk.label.replace(/\.(bimpk|sgpk)$/, '');
      const models = await IafProj.getModels({
        _namespaces: this.props.selectedItems.selectedProject._namespaces,
      });
      console.log("models: ", models);
      const model = _.find(models, { _name: modelName })
      console.log("model to delete: ", model);
      if (model) {
        const delModelRes = await IafItemSvc.deleteNamedUserItem(
          model._id, ctx, undefined
        );
        console.log("delModelRes: ", delModelRes);
        if (
          delModelRes.includes('ok')
        ) {
          const proj = await IafProj.getCurrent();
          console.log('proj: ', proj)
           const currentModels = await IafProj.getModels({ 
            _namespaces: this.props.selectedItems.selectedProject._namespaces 
          })
          await this.updateSessionSelectedModel(currentModels?.[0] || {})
          await this.updateSessionProj(
            this.props.selectedItems.selectedProject, 
            currentModels
          )
          this.props.actions.restartApp()
        } 
      } else {
        console.log('no model, deleting bimpk file from state')
        this.removeModelFromState(this.state.selectedBimpk.label);
        this.componentDidMount();  
      }
    } else {
      console.log('failed to delete bimpk file')
    }
  }

  updateSessionSelectedModel(model) {
    try {
      IafSession.setSessionStorage('model', model);      
      return true
    } catch (e) {
      console.log('error updating selected model: ', e);
      return false
    }
  }

  async updateSessionProj(project, currentModels) {
    console.log('currentModels: ', currentModels)
    let modelData = {};
    if (currentModels) {
      const modelData = currentModels.map(m => ({
        model: {
          model: m._id,
          modelVersionId: m._versions[0]._id,
        },
        bimpk: {
          filename: m._name
        }
      }));      
    }

    const updatedProject = {
      ...project,
      _userAttributes: {
        ...project._userAttributes,
        currentModels: modelData
      }
    };
    try {
      console.log('updating proj & session proj: ', updatedProject)
      const updatedProj = await IafProj.update(
        updatedProject, 
        { _namespaces: updatedProject._namespaces}
      );
      IafSession.setSessionStorage('project', updatedProj);
      return true
    } catch (e) {
      console.log('error updating proj: ', e);
      return false
    }
  }

  async UploadBimpk(ctx) {
    const multiModel = this.props.selectedItems.selectedProject._userAttributes?.multiModel;
    if ( multiModel && this.state.bimpks.length >= 5) {
      this.setState({ numPermittedModelsModal: true });
      return;
    }
    this.setState({ isPageWorking: false, file: "" });
    let deleteFile;
    let selectFiles = await IafLocalFile.selectFiles({
      multiple: false,
      accept: ".bimpk, .sgpk",
    });
    console.log("selected files: ", selectFiles);
    this.setState({ selectedFiles: selectFiles });
    if (this.state.deleteLastModal) {
      this.deleteBimpk()
    }
    if (
      ( !multiModel )
        &&
      ( selectFiles[0].name !== this.state.bimpks[0]?._name &&
        this.state.bimpks[0] !== undefined 
      )
    ) {
      this.setState({ deletePreviousModal: true });
      return;
    }
    if ( selectFiles[0].name.length > 100 ) {
      this.setState({ longBimpkNameModal: true });
      return;
    }
    if (this.state.selectedBimpk && this.state.selectedBimpk.value !== "none" && !deleteFile) {
      let version = await IafFileSvc.getFileVersions(
        this.state.selectedBimpk.value
      );
      console.log("file versions: ", version)
      if (version?._list.length >= 2) {
        this.setState({ deleteVersionModal: true });
        return;
      }
    }

    const uploadedFile = await this.uploadFile(ctx);
    console.log("uploadedFile: ", uploadedFile);
    const newModel = {
      value: uploadedFile._id,
      label: uploadedFile._name
    };

    if (multiModel) {
      const bimpkNames = this.state.bimpks.map( b => b._name);
      if ( !bimpkNames.includes(selectFiles[0].name) ) {
        console.log("newModel: ", newModel)
        this.setState({
          bimpkOptions: [...this.state.bimpkOptions, newModel],
          selectedBimpk: newModel
        });
        console.log("bimpkOptions and newModel",
          newModel,
          this.state.bimpkOptions,
          this.state.selectedBimpk
        )
      } 
    } else {
      console.log("setting selected bimpk as newModel: ", newModel);
      this.setState({ selectedBimpk: newModel });
    }
  }

  async uploadFile(ctx) {
    console.log("running uploadFile");
    this.setState({ isPageWorking: false });
    let proj = this.props.selectedItems.selectedProject;
    const onProgress = async (bytesUploaded, bytesTotal) => {
      let percentage = ((bytesUploaded / bytesTotal) * 100).toFixed(2);
      this.setState({ uploadPercentage: percentage });
      console.log(
        "iaf_bimpk_name",
        bytesUploaded,
        bytesTotal,
        percentage + "%"
      );
      if (percentage == 100) {
        this.setState({ uploadPercentage: null });
      }
    };

    const onSuccess = async () => {
      console.log("Upload completed");
      this.componentDidMount();
    };

    if (!ctx._namespaces) {
      ctx._namespaces = proj._namespaces;
    }
    let uploadedFile = await IafScriptEngine.uploadFile(
      this.state.selectedFiles[0],
      ctx,
      onProgress,
      onSuccess
    );
    console.log("uploadedFile: ", uploadedFile);
    return uploadedFile;
  }

  async runOrchestrator(orchestrator, req, ctx) {
    const orchRunCtx = Object.fromEntries(
      Object.entries(ctx).filter(([key]) => key !== 'authToken')
    );
    try {
      let result = await IafDataSource.runOrchestrator(
        orchestrator.id,
        req,
        orchRunCtx
      );
      if (result) {
        if (result.hasOwnProperty("id")) {
          await this.getOrchStatus(result.id);

          //poll the orchestrator and the step statuses
          let interval = setInterval(async () => {
            let errStatus = _.filter(
              this.state.orchStepRunStatus,
              (run_status) => {
                return run_status._status === "ERROR";
              }
            );
            let queuedStatus = _.filter(
              this.state.orchStepRunStatus,
              (run_status) => {
                return run_status._status === "QUEUED";
              }
            );
            let runningStatus = _.filter(
              this.state.orchStepRunStatus,
              (run_status) => {
                return run_status._status === "RUNNING";
              }
            );
            if (
              !_.isEmpty(errStatus) ||
              (_.isEmpty(queuedStatus) && _.isEmpty(runningStatus))
            ) {
              if (_.isEmpty(errStatus)) {
                let { orchStepRunStatus } = this.state;
                orchStepRunStatus.forEach(
                  (step) => (step.status = "COMPLETED")
                );
                this.setState({ orchStepRunStatus });
              }

              //when import is complete kill the polling
              clearInterval(this.state.importIntervalId);

              //reset the currently selected model to the one we just imported
              //note: this is kept on the app itself - thus the setSelectedItems
              //not on the local state of the page
              //setSelectedItems will trigger the app to update the 3D view of the model
              let models = await IafProj.getModels(this.state.project);
              if (models) {
                let lastUploadedModel = _.sortBy(
                  models,
                  (m) => m._metadata._updatedAt
                );
                let selectedModel = _.last(lastUploadedModel);
                this.props.actions.setSelectedItems({
                  selectedModel: selectedModel,
                });
              }
              await this._loadAsyncData();
              this.setState({ isPageWorking: false });
            }
            await this.getOrchStatus(result.id);
          }, 10000);

          this.setState({ importIntervalId: interval });
        }
      }
    } catch (error) {
      this.handleError();
      return;
    }
  }

  async runPolledOrchestrator(orchestrator, req, ctx) {
    try {
      let result = await IafDataSource.runOrchestrator(
        orchestrator.id,
        req,
        ctx
      );
      return await this.pollOrchestrator(result)
    } catch (e) {
      console.log("orchestrator error: ", e);
      throw e;
    }
  }

  async pollOrchestrator(orchResult, index) {
    const MAX_ATTEMPTS = 680; 
    let attempts = 0;
    const ctx = { _namespaces: this.props.selectedItems.selectedProject._namespaces}

    while (attempts < 6000) {
      try {
        const orchRunResult = await IafDataSource.getOrchRunStatus(orchResult.id, ctx);
        console.log('mapping orchRunResult: ', orchRunResult)
       //const orchStepRunStatus = orchRunResult[0].orchrunsteps;

        let orchStepRunStatus = orchRunResult[0].orchrunsteps;
        orchStepRunStatus.forEach((step) => {
          step.id = step.id; //need an id for mobiScroll.listView
        });
        //orchStepRunStatus.reverse(); //show latest status at top
    
        this.setState({
          orchRunStatus: orchRunResult,
          orchStepRunStatus: orchStepRunStatus,
        });

        const errStatus = orchStepRunStatus.filter(run_status => run_status._status === "ERROR");
        const queuedStatus = orchStepRunStatus.filter(run_status => run_status._status === "QUEUED");
        const runningStatus = orchStepRunStatus.filter(run_status => run_status._status === "RUNNING");

        if (!_.isEmpty(errStatus)) {
          this.setState({ orchStepRunStatus: errStatus });
        }
        if (!_.isEmpty(queuedStatus)) {
          this.setState({ orchStepRunStatus: queuedStatus });
        }
        if (!_.isEmpty(runningStatus)) {
          this.setState({ orchStepRunStatus: runningStatus });
        }
        
        console.log(`Orchestrator status:`, {
          errors: errStatus.length,
          queued: queuedStatus.length,
          running: runningStatus.length,
          attempt: attempts
        });

        if (!_.isEmpty(errStatus)) {
          throw new Error(`Orchestrator encountered errors: ${JSON.stringify(errStatus)}`);
        }

        if (_.isEmpty(queuedStatus) && _.isEmpty(runningStatus)) {
          orchStepRunStatus.forEach((step) => step.status = 'COMPLETED');
          return {
            orchestratorId: orchResult.id,
            status: 'COMPLETED',
            steps: orchStepRunStatus
          };
        }

        const startWait = Date.now();
        while (Date.now() - startWait < 10000) {
          const x = Math.random();
        }

        attempts++;
      } catch (error) {
        console.error(`Error polling orchestrator:`, JSON.stringify(error));
        throw error;
      }
    }

    throw new Error(`Orchestrator timed out`);
  }

  async getOrchStatus(runid) {
    //get the stasus needed to update the UI for the import

    let orchRunStatus = await IafDataSource.getOrchRunStatus(runid);

    let orchStepRunStatus = orchRunStatus[0].orchrunsteps;
    orchStepRunStatus.forEach((step) => {
      step.id = step.id; //need an id for mobiScroll.listView
    });
    //orchStepRunStatus.reverse(); //show latest status at top

    await this.setState({
      orchRunStatus: orchRunStatus,
      orchStepRunStatus: orchStepRunStatus,
    });
  }

  handleClose() {
    this.setState({ deleteModal: false });
  }

  handleError() {
    let status = this.state.orchRunStatus;
    if (!status) status = true; //if there is not yet a status sset to true so status will display in UI

    let steps = [...this.state.orchStepRunStatus];
    steps.unshift({
      id: "error1000",
      step_run_message:
        "AN ERROR WAS ENCOUNTERED IMPORTING THE MODEL. IMPORT ABORTED.",
    });

    this.setState({
      isPageWorking: false,
      orchRunStatus: status,
      orchStepRunStatus: steps,
    });
  }

  async getMissingRelationsResponse(fileId, fileVersionId) {
    let missingElementsFile = await IafFileSvc.getFileUrl(
      fileId,
      fileVersionId
    );

    let resp = await fetch(missingElementsFile._url);

    return resp.json();
  }

  async mapMissingRelations(missingRelations) {
    return Promise.all(
      missingRelations.map((item) =>
        this.getMissingRelationsResponse(item.fileId, item.fileVersionId)
      )
    );
  }

  async onMissingEntitiesDownload() {
    this.setState({ isPageWorking: true });
    await ScriptHelper.executeScript(
      this.props.handler.config.scripts.download,
      { missingItems: this.state.entitiesMissingRelations }
    );
    this.setState({ isPageWorking: false });
  }

  async _getMissingRelations() {
    let query = { _userType: "rvt_elements" };

    let modelRels = await IafItemSvc.getRelatedInItem(
      this.props.selectedItems.selectedModel._id,
      { query }
    );

    let userItemVersion = await IafItemSvc.getNamedUserItemVersion(
      modelRels._list[0]?._userItemId,
      modelRels._list[0]?._userItemVersionId
    );

    if (
      !userItemVersion._userAttributes ||
      !userItemVersion._userAttributes.missingRelationsFromPrevVersion
    ) {
      return;
    }

    this.setState({
      missingRelations:
        userItemVersion._userAttributes.missingRelationsFromPrevVersion,
    });
  }

  async onMissingEntitiesRequest() {
    this.setState({ isPageWorking: true });

    let missingElementsJson = await this.mapMissingRelations(
      this.state.missingRelations
    );

    let missingElements = await ScriptHelper.executeScript(
      this.props.handler.config.scripts.findMissingItems,
      { missingItems: missingElementsJson.flat() }
    );

    this.setState({
      entitiesMissingRelations: missingElements,
      isPageWorking: false,
    });

    return;
  }

  cancelUpload() {
    this.setState({ deleteVersionModal: false });
    this.setState({ deletePreviousModal: false });
    this.setState({ deleteLastModal: false });
    this.setState({ numPermittedModelsModal: false });
    this.setState({ longBimpkNameModal: false });
  }

  async deleteFirstVersionAndUploadNewVersion(ctx) {
    this.setState({ deleteVersionModal: false, isPageWorking: false });
    let version = await IafFileSvc.getFileVersions(
      this.state.selectedBimpk.value
    );
    let deleteVersionModal = await IafFileSvc.deleteFileVersion(
      version._list[0]._fileId,
      version._list[0]._id
    );
    await this.uploadFile(ctx);
  }

  async deleteOldModelAndUploadNewModel(ctx) {
    this.setState({ 
      deletePreviousModal: false, 
      deleteLastModal: false,
      isPageWorking: false,
      numPermittedModelsModal: false 
    });
    let models = await IafProj.getModels(
      this.state.project._namespaces[0],
      {},
      ctx,
      undefined
    );
    let namedUserItem = await IafItemSvc.getAllNamedUserItems(
      undefined,
      ctx,
      undefined
    );
    if (models) {
      let deleteModel = await IafItemSvc.deleteNamedUserItem(
        models[0]._id,
        ctx,
        undefined
      );
    }
    if (this.state.selectedBimpk.value !== "none") {
      let deleteFile = await IafFileSvc.deleteFile(
        this.state.selectedBimpk.value,
        ctx
      );
    }
    await this.uploadFile(ctx);
  }

  render() {
    const style = {
      backgroundColor: "white",
      borderRadius: "24px",
      padding: "30px",
      border: "1.5px solid lightgray",
      marginTop: '9px'
    };

    const { refAppQA } = this.state;
    return (
      <div style={style}>
        <DeleteConfirmationDialog
          state={this.state.deleteVersionModal}
          handleClose={this.cancelUpload}
          handleDelete={this.deleteFirstVersionAndUploadNewVersion}
          message="Only two versions are permitted, Clicking on Delete will erase the first version automatically"
        ></DeleteConfirmationDialog>
        <DeleteConfirmationDialog
          state={this.state.deletePreviousModal}
          handleClose={this.cancelUpload}
          handleDelete={this.deleteOldModelAndUploadNewModel}
          message="Only one model is permitted, Clicking on Delete will erase the first model automatically"
        ></DeleteConfirmationDialog>
        <DeleteConfirmationDialog
          state={this.state.deleteModal}
          handleClose={this.handleClose}
          handleDelete={this.deleteBimpk}
          message="Deleting this file will result in permanently losing the model and
          attributes of the file"
        ></DeleteConfirmationDialog>
        <DeleteConfirmationDialog
          state={this.state.deleteLastModal}
          handleClose={this.handleClose}
          handleDelete={this.deleteBimpk}
          message="If you delete this model, there will be no model to view in the app or data to query until you upload, import, and remap another."
        ></DeleteConfirmationDialog>
        { this.state.longBimpkNameModal &&
          <LongBimpkNameModal
            name={this.state.selectedFiles[0].name}
            onCancel={this.cancelUpload}
          />        
        }
        { this.state.loadNewModelModal &&
          <LoadNewModelModal
            onSubmit={this.loadNewModel}
            onCancel={this.cancelNewModelLoad}
          />
        }  

        <h5>Model</h5>
        <Select
          name="modelSelect"
          options={this.state.bimpkOptions}
          value={this.state.selectedBimpk}
          className="custom-single"
          classNamePrefix="select"
          onChange={this.onModelChange}
          isDisabled={this.state.isPageLoading || this.state.isPageWorking}
        />
        <br></br>
        <div>
          <h5>Select a version</h5>

          <TableComponent
            columns={this.state.columns}
            data={this.state.selectedBimpkVersions}
          />

          <div
            style={{
              textAlign: "right",
              marginTop: "15px",
              display: "flex",
            }}
          >
            <GenericMatButton
              onClick={this.onImport}
              disabled={
                (!this.state.bimpkOrch && !this.state.sgpkOrch) ||
                this.state.isPageLoading ||
                this.state.isPageWorking ||
                !this.state.bimpks.length ||
                this.state.uploadPercentage
              }
              styles={{
                marginRight: "15px",
                ...(this.state.uploadPercentage ||
                !this.state.bimpks.length ||
                this.state.isPageWorking
                  ? {}
                  : {
                      color: "white",
                      backgroundColor: "var(--app-accent-color)",
                    }),
              }}
            >
              Import
            </GenericMatButton>
            <GenericMatButton
              onClick={() => {
                if (this.state.bimpks.length > 1) {
                  this.setState({ deleteModal: true });                  
                } else {
                  this.setState({ 
                    deleteLastModal: true
                  });
                }
              }}
              disabled={
                this.state.uploadPercentage ||
                !this.state.bimpks.length ||
                this.state.isPageWorking
              }
              styles={{
                marginRight: "15px",
                ...(this.state.uploadPercentage ||
                !this.state.bimpks.length ||
                this.state.isPageWorking
                  ? {}
                  : {
                      color: "white",
                      backgroundColor: "var(--app-accent-color)",
                    }),
              }}
            >
              Delete
            </GenericMatButton>
            <GenericMatButton
              disabled={
                this.state.uploadPercentage || this.state.isPageWorking
              }
              onClick={this.UploadBimpk}
              styles={{
                marginRight: "15px",
                ...(this.state.uploadPercentage || this.state.isPageWorking
                  ? {}
                  : {
                      color: "white",
                      backgroundColor: "var(--app-accent-color)",
                    }),
              }}
            >
              Upload
            </GenericMatButton>
            
              <GenericMatButton
                disabled={
                  (!this.state.bimpkOrch && !this.state.sgpkOrch) ||
                  this.state.isPageLoading ||
                  this.state.isPageWorking ||
                  !this.state.bimpks.length ||
                  this.state.uploadPercentage
                }
                onClick={this.uploadExcelAndRemap}
                styles={{
                  marginRight: "15px",
                  ...(this.state.uploadPercentage ||
                  !this.state.bimpks.length ||
                  this.state.isPageWorking
                    ? {}
                    : {
                        color: "white",
                        backgroundColor: "var(--app-accent-color)",
                      }),
                }}
              >
                Upload type map
              </GenericMatButton>
           
            <GenericMatButton
              onClick={this.onRemap}
              disabled={
                (!this.state.bimpkOrch && !this.state.sgpkOrch) ||
                this.state.isPageLoading ||
                this.state.isPageWorking ||
                !this.state.bimpks.length ||
                this.state.uploadPercentage
              }
              styles={{
                marginRight: "15px",
                ...(this.state.uploadPercentage ||
                !this.state.bimpks.length ||
                this.state.isPageWorking
                  ? {}
                  : {
                      color: "white",
                      backgroundColor: "var(--app-accent-color)",
                    }),
              }}
            >
              Remap
            </GenericMatButton>
            {this.state.missingRelations.length > 0 && (
              <GenericMatButton
                onClick={this.onMissingEntitiesRequest}
                disabled={
                  this.state.isPageLoading || this.state.isPageWorking
                }
                styles={{
                  marginRight: "15px",
                  color: "white",
                  backgroundColor: "var(--app-accent-color)",
                }}
              >
                Get Missing Entities
              </GenericMatButton>
            )}
          </div>

          {this.state.uploadPercentage && (
            <div
              id="upload-div"
              style={{
                textAlign: "center",
                marginTop: "80px",
                position: "relative",
              }}
            >
              
            <ProgressBar progress={this.state.uploadPercentage}/>
              <br></br>
              <h4>Uploading... {this.state.uploadPercentage}%</h4>
            </div>
          )}

          {!this.state.isPageLoading &&
            this.state.entitiesMissingRelations.length > 0 && (
              <div style={{ marginTop: "15px" }}>
                <h4>Entities Missing From The Model</h4>
                <TableComponent
                  columns={this.state.missingRelationsColumns}
                  data={this.state.entitiesMissingRelations}
                />
                <div
                  style={{
                    textAlign: "right",
                    marginTop: "15px",
                    display: "flex",
                    justifyContent: "flex-end",
                  }}
                >
                  <GenericMatButton
                    onClick={this.onMissingEntitiesDownload}
                    disabled={
                      this.state.isPageLoading || this.state.isPageWorking
                    }
                    styles={{ marginRight: "15px" }}
                  >
                    Download
                  </GenericMatButton>
                </div>
              </div>
            )}

          {!!this.state.orchRunStatus && (
            <div>
              <hr />
              <div>
                {this.state.orchRunStatus && this.state.isPageWorking && (
                  <div>
                    <MessageThrobber message={this.state.throbberMessage} />
                    <span style={{ color: "red" }}>
                      This is a long running operation. Please do not
                      refresh or leave the page.
                    </span>
                  </div>
                )}
                {!!this.state.orchRunStatus &&
                  !this.state.isPageWorking && <h3>Import Complete</h3>}

                <mobiscroll.Listview
                  theme="ios"
                  itemType={StatusListItem}
                  data={this.state.orchStepRunStatus}
                />
              </div>
            </div>
          )}
        </div>
      </div>
    );
  }
}

export default ModelManager;

class StatusListItem extends React.Component {
  render() {
    const item = this.props.item;
    return (
      <li key={item.id}>
        {item._name
          ? item._status + ": " + item._name
          : (item.step_run_message === "{}" ? item.step_run_status + " " : "") +
            (item.step_run_message !== "{}"
              ? item.step_run_message
              : item.step_run_name)}
      </li>
    );
  }
}

class MessageThrobber extends React.Component {
  constructor(props) {
    super(props);

    this.state = {
      dots: ".",
      interval: null,
    };
  }

  componentDidMount() {
    if (!this.state.interval) {
      let interval = setInterval(() => {
        let { dots } = this.state;

        if (dots.length === 8) dots = ".";
        else dots += " .";

        this.setState({ dots: dots });
      }, 700);
      this.setState({ interval: interval });
    }
  }

  componentDidUpdate() {
    if (this.state.dots.length > 16) this.setState({ dots: "." });
  }

  componentWillUnmount() {
    clearInterval(this.state.interval);
  }

  render() {
    return (
      <h3>
        {this.props.message} {this.state.dots}
      </h3>
    );
  }
}