/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, {
  useEffect,
  useState,
  useCallback,
  useMemo,
  useContext,
  useRef,
} from "react";
import interact from "interactjs";
import PropTypes from "prop-types";

import * as EntityDataContainer from "../entities/EntityDataContainer";
import EntityDataGroupContainer from "../entities/EntityDataGroupContainer";
import EntityActionsPanel from "../entities/EntityActionsPanel";
import { EntityListView } from "../entities/EntityListView";
import useSortEntities from "../entities/sortEntities";
import EntitySelectionPanel, {
  TreeSelectMode,
} from "../entities/EntitySelectionPanel";
import withEntitySearchNav from "./WithEntitySearchNav.jsx";
 
import {
  branchNodeRendererOld as branchNodeRenderer,
  leafNodeRendererOld as leafNodeRenderer,
} from "@dtplatform/platform-app-conflux/modules/IpaUtils";
import SearchModelessTab from "./SearchModelessTab";
import { compose } from "redux";
import { connect } from "react-redux";
import { Entities } from "@dtplatform/platform-app-conflux/modules/IpaRedux";
import _ from "lodash";
import { EnhancedIafViewer } from "./EnhancedIafViewer";
import { StackableDrawer } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import clsx from "clsx";
import { Button, Tooltip } from "@mui/material";
import { SimpleTextReducer } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import WorkflowSearch from "./workflows/WorkflowSearch.jsx";
import { sampleWorkflow, doesUrlContainPath, getSampleWorkflow } from "./workflows/SampleWorkflows.jsx";
import { IafProj, IafSession } from "@dtplatform/platform-api";
import ModelPanel from "../entities/ModelPanel.jsx";
import { onIafMapReady } from "./gis/onIafMapReady";
import { Switch, FormControlLabel } from '@mui/material';
import mapBox from "../../../../scripts/NextScriptEngine/scripts/js/iaf_map_box.js";
import * as PlatformApi from '@dtplatform/platform-api';
import { IafScriptEngine } from '@dtplatform/iaf-script-engine';

const EntityDetailBottomPanel = ({
  availableDataGroups,
  entityType,
  config,
  getData,
  loadingDataGroups,
  selectedEntities,
  entitySingular,
  handler,
  onEntityChange,
  onActionSuccess,
  doEntityAction,
  context,
  isWorkflowDrawerOpen,
  isModelDrawerOpen,
  isSearchDrawerOpen,
  isChatDrawerOpen,
  isFilterDrawerOpen,
  isDataDrawerOpen,
  isGisDrawerOpen,
  isGisMode,
  toggleGisDrawer,
  toggleModelDrawer,
  toggleSearchDrawer,
  toggleChatDrawer,
  toggleFilterDrawer,
  toggleDataDrawer,
  toggleWorkflowDrawer,
  clearSearchAndFilters,
  entity,
  entityListSort,
}) => {
  const panel = useRef();
  const isWorkflowRoute = doesUrlContainPath("workflow");
  const defaultSort = useSortEntities?.(entitySingular)?.currentSort;
  const [currentSort, setCurrentSort] = useState(defaultSort);
  const sortedEntities = useMemo(() => {
    return _.orderBy(
      selectedEntities,
      currentSort?.valueAccessor,
      currentSort?.order
    );
  }, [selectedEntities, currentSort]);

  const [detailedEntityIndex, setDetailedEntityIndex] = useState(0);
  const proj = IafProj.getCurrent();
  const detailedEntity = sortedEntities[detailedEntityIndex];
  const dataGroups = {
    "Element Properties": true,
    "Telemetry via REST API": true,
    "Warranty Data": true,
    "Telemetry via MQTT": true,
    "Files" : true
  };

  const filteredDataGroups = useMemo(
    () =>
      dataGroups
        ? Object.entries(dataGroups)
            .filter(([k, v]) => v === true)
            .map(([k, v]) => k)
        : [],
    [availableDataGroups, entityType]
  );
  const [groupToFocusOn, setSelectedDataGroup] = useState(
    filteredDataGroups[0]
  );
  const selectedDataGroup =
    filteredDataGroups.indexOf(groupToFocusOn) > -1
      ? groupToFocusOn
      : filteredDataGroups[0];
  const groupConfig = _.get(config, `data[${selectedDataGroup}]`);

  const entityData =
  EntityDataContainer.useEntityData(
      false,
      false,
      detailedEntity,
      groupConfig,
      getData,
      selectedDataGroup
    );

  const hasPreviousSelectedEntity = useCallback(
    () => detailedEntityIndex > 0,
    [detailedEntityIndex]
  );
  const hasNextSelectedEntity = useCallback(
    () =>
      detailedEntityIndex > -1 &&
      detailedEntityIndex < selectedEntities.length - 1,
    [detailedEntityIndex, selectedEntities.length]
  );

  const _handlePreviousEntity = (_detailedEntityIndex, _hasPreviousGuard) => {
    if (_hasPreviousGuard()) {
      setDetailedEntityIndex(_detailedEntityIndex - 1);
    }
  };

  const _handleNextEntity = (_detailedEntityIndex, _hasNextGuard) => {
    if (_hasNextGuard()) {
      setDetailedEntityIndex(_detailedEntityIndex + 1);
    }
  };

  const handlePreviousEntity = useCallback(
    () => _handlePreviousEntity(detailedEntityIndex, hasPreviousSelectedEntity),
    [detailedEntityIndex]
  );
  const handleNextEntity = useCallback(
    () => _handleNextEntity(detailedEntityIndex, hasNextSelectedEntity),
    [detailedEntityIndex, selectedEntities.length]
  );

  const actions = useMemo(() => {
    if (config.actions) {
      let actions = { ...config.actions };
      actions.onSuccess = onActionSuccess;
      actions.doEntityAction = doEntityAction;
      return actions;
    }
  }, [config, doEntityAction, onEntityChange]);

  const shouldDisplayEntityPager = useMemo(
    () =>
      detailedEntity !== undefined &&
      selectedEntities?.length > 1 &&
      detailedEntityIndex > -1,
    [detailedEntity, selectedEntities, detailedEntityIndex]
  );

  const allowedToBeOpened = useMemo(
    () => detailedEntity !== undefined,
    [detailedEntity]
  );

  const [bottomPanelState, setBottomPanelState] = useState("default"); //states: default, opened, closed

  useEffect(() => {
    if (bottomPanelState == "closed") {
      panel.current.style.height = null;
    }
  }, [bottomPanelState, panel]);

  useEffect(() => {
    setSelectedDataGroup(filteredDataGroups[0]);
  }, [filteredDataGroups]);

  useEffect(() => {
    setDetailedEntityIndex(0);
  }, [sortedEntities]);

  useEffect(() => {
    if (entityListSort && !_.isEqual(entityListSort, currentSort)) {
      setCurrentSort(entityListSort);
    }
  }, [entityListSort]);

  useEffect(() => {
    interact(panel.current).resizable({
      edges: { left: false, right: false, bottom: false, top: ".open" },
      listeners: {
        move(event) {
          let { rect } = event.rect; //The edges of the element that are being changed
          let { deltaRect } = event.deltaRect; //The change in dimensions since the previous event
          let { edges } = event.edges; //An object with the new dimensions of the target

          //show deltaReact in element for debugging purposes
          let { x, y } = event.target.dataset;
          x = parseFloat(x) || 0 /*+ event.deltaRect.left*/;
          y = (parseFloat(y) || 0) + event.deltaRect.top;
          Object.assign(event.target.dataset, { x, y });

          //update height as we move upwards only
          if (event.rect.height > 40 /*top panel size*/) {
            Object.assign(event.target.style, {
              height: `${event.rect.height}px`,
            });
          }
        },
        start(event) {},
        end(event) {},
      },
    });
  }, [panel.current]);

  return (
    <div
      ref={panel}
      className={clsx("bottom-panel", bottomPanelState != "closed" && "open")}
    >
      <div className="bottom-panel-title-bar">
        <div className={"navigator-bottom-icons"}>
          <div className={"navigator-bottom-left-icons"}>
            {isWorkflowRoute ? 
            <div
              className={`navigator-bottom-filter ${
                isWorkflowDrawerOpen ? "selected" : "unselected"
              }`}
            >
              <i onClick={toggleWorkflowDrawer} className="fas fa-filter" />
            </div> 
            : 
           <>
           { proj?._userAttributes?.currentModels &&
              <div
                className={`navigator-bottom-search ${
                  isModelDrawerOpen ? "selected" : "unselected"
                }`}
              >
                <i onClick={toggleModelDrawer} className="fas fa-table" />
              </div>
            }
           <div
              className={`navigator-bottom-search ${
                isSearchDrawerOpen ? "selected" : "unselected"
              }`}
            >
              <i onClick={toggleSearchDrawer} className="fas fa-search" />
            </div>
            <div
              className={`navigator-bottom-filter ${
                isFilterDrawerOpen ? "selected" : "unselected"
              }`}
            >
              <i onClick={toggleFilterDrawer} className="fas fa-filter" />
            </div>
            <div
              className={`navigator-bottom-data ${
                isDataDrawerOpen ? "selected" : "unselected"
              }`}
            >
              <i onClick={toggleDataDrawer} className="fas fa-list" />
            </div>
            {isGisMode && <div
                className={`navigator-bottom-search ${
                  isGisDrawerOpen ? "selected" : "unselected"
                }`}
              >
                <i onClick={toggleGisDrawer} className="fas fa-map" />
              </div>}
            </>}
          </div>
          <div className={"navigator-bottom-right-icons"}>
            {!isWorkflowRoute && <div className={`navigator-bottom-reset unselected`}>
              <Tooltip key={"icon-clear-filters"} title="Clear filters">
                <i className="fas fa-undo" onClick={clearSearchAndFilters} />
              </Tooltip>
            </div>}
          </div>
        </div>
        {detailedEntity && (
          <div className="bottom-panel-title">
            {shouldDisplayEntityPager && (
              <div className="bottom-panel__entity-controls">
                <i
                  onClick={handlePreviousEntity}
                  className={`fas fa-angle-left arrow arrow-left ${
                    hasPreviousSelectedEntity ? "" : "arrow-disabled"
                  }`}
                />
                <p className="text">
                  {detailedEntityIndex + 1} of {selectedEntities.length}
                </p>
                <i
                  onClick={handleNextEntity}
                  className={`fas fa-angle-right arrow arrow-right ${
                    hasNextSelectedEntity ? "" : "arrow-disabled"
                  }`}
                />
              </div>
            )}
            <SimpleTextReducer
              text={detailedEntity["Entity Name"]}
              limit={50}
            />
            <EntityActionsPanel
              context={context}
              actions={actions}
              entity={detailedEntity}
              type={handler.config.type.find(
                (type) => type.singular === entitySingular
              )}
              iconRenderer={(icons) => (
                <div className="bottom-panel-actions">{icons}</div>
              )}
            />
            <div className={"bottom-panel__icons"}>
              <div className={"bottom-panel__icons--right-icons"}>
                <div>
                  {allowedToBeOpened && bottomPanelState == "closed" && (
                    <Tooltip key={"icon-expand-panel"} title="Expand panel">
                      <i
                        className={"bottom-panel__icon fas fa-arrow-up"}
                        onClick={() => setBottomPanelState("opened")}
                      />
                    </Tooltip>
                  )}
                  {bottomPanelState != "closed" && (
                    <Tooltip key={"icon-collapse-panel"} title="Collapse panel">
                      <i
                        className={"bottom-panel__icon fas fa-window-minimize"}
                        onClick={() => setBottomPanelState("closed")}
                      />
                    </Tooltip>
                  )}
                </div>
              </div>
            </div>
          </div>
        )}
      </div>
      {detailedEntity && (
        <div
          className={clsx(
            "bottom-panel-content",
            bottomPanelState != "closed" && "open"
          )}
        >
          <div className="bottom-panel-content-left">
            {!loadingDataGroups &&
              filteredDataGroups.map((dg) => (
                <div
                  className={`bottom-panel__data-group-tab ${
                    dg === selectedDataGroup && "selected"
                  }`}
                  onClick={() => {
                    entityData.reload();
                    setSelectedDataGroup(dg);
                  }}
                  key={dg}
                >
                  {dg}
                </div>
              ))}
          </div>
          <div className="bottom-panel-content-right">
            <div className="bottom-panel-data-group-title">
              {selectedDataGroup}
            </div>

            {!loadingDataGroups && config && entityData.error && (
              <div>
                <p>An unexpected error happened, please try again later.</p>
              </div>
            )}
            {!loadingDataGroups && config && !entityData.error && (
              <EntityDataGroupContainer
                config={groupConfig}
                collapsable={false}
                data={entityData.data}
                fetching={entityData.fetching}
              />
            )}
          </div>
        </div>
      )}
    </div>
  );
};

class NavigatorView extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      workflow: getSampleWorkflow(this.props.selectedItems.selectedProject),
      isModelDrawerOpen: false,
      isSearchDrawerOpen: false,
      isChatDrawerOpen: false,
      isFilterDrawerOpen: false,
      isWorkflowDrawerOpen: false,
      isDataDrawerOpen: false,
      displayedEntityIndex: undefined,
      reloadSearchToken: Math.floor(Math.random() * 100 + 1),
      shouldClearToken: Math.floor(Math.random() * 100 + 1),
      detailEntity: undefined,
      entityListSort: {},
      isPageLoading: true,
      isModelPresent: null,
      isFetching: true,
      allEntities: [],
      colorGroupChanged: Math.floor(Math.random() * 100 + 1),
      isGisMode: false,
      iafmap: null,
      isGisDrawerOpen: false,
      isGisDirectionEnabled: false,
      mapboxToken: null,
      modelsData: null
    };
    this.colorGroupChanged = this.colorGroupChanged.bind(this);
    this.handleMapboxToken = this.handleMapboxToken.bind(this);
    this.checkMapboxToken = this.checkMapboxToken.bind(this);
  }

  async componentDidMount() {
    //When the page mounts load the async data (script and other)
    //and then create the column info for the upload table
    this.props.setViewerSyncOn();
    let project = this.props.selectedItems.selectedProject;
    const is2dOnly = project._name.toLowerCase().includes("autocad");
    if(is2dOnly){
      this.props.getAllEntities().then((entities)=>{
        this.setState({ allEntities: entities });
      });
    }
    this.setState({ isPageLoading: false });
    await this.checkModel();
    await this.loadModelsData();
    await this.checkMapboxToken();
  }

  async loadModelsData() {
    const proj = this.props.selectedItems?.selectedProject;
    if (
      ! proj?._userAttributes?.currentModels ||
      Object.keys(proj._userAttributes.currentModels).length === 0
    ) {
      const models = Array.isArray(await IafProj.getModels(proj)) 
        ? [...(await IafProj.getModels(proj))].reverse()
        : [];
      const modelsData = models?.map(m => ({
        model: {
          model: m._id,
          modelVersionId: m._versions[0]._id,
        },
        bimpk: {
          filename: m._name + '.bimpk'
        }
      }));
      this.setState({ modelsData: modelsData });
    } else {
      this.setState({ 
        modelsData: this.props.selectedItems?.selectedProject?._userAttributes?.currentModels 
      })
    }
  }

  async checkMapboxToken() {
    const sessionToken = IafSession.getSessionStorage('mapboxToken');
    const proj = this.props.selectedItems.selectedProject;
    const ctx = { _namespaces: proj._namespaces }
    try {
      const token = sessionToken && mapBox.checkTokenFreshness(sessionToken)
        ? sessionToken
        : await mapBox.getMapboxToken(
          proj,
          PlatformApi, 
          IafScriptEngine, 
          ctx
        );
      this.setState({ mapboxToken: token });
    } catch (e) {
      console.log('e checkMapboxToken', e)
    }
  }

  async checkModel() {
    let project = IafProj.getCurrent();
    //let project = this.props.selectedItems.selectedProject;
    console.log("checkModel project", project);
    let ctx = { isFormData: false };
    let models = await IafProj.getModels(
      { _namespaces: project._namespaces}
    );
    console.log("checkModel models", models);
    this.setState({ isModelPresent: models, isFetching: false  });
  }
  
  enableGisDrawer = (iafmap) => {
    const isGisMode = !!iafmap;
    this.setState({ isGisMode, iafmap });
    if(!isGisMode){
      this.setState({ isGisDirectionEnabled: isGisMode });
    }
  }
  
  handleEnableDirectionChange = (event) => {
    const enabled = event.target.checked;
    this.setState({ isGisDirectionEnabled: enabled });
    onIafMapReady(this.state.iafmap, enabled);
  };

  handleEntityIndexChange = (event, newIndex) => {
    this.props.updateEntityType(
      _.values(this.props.getPerEntityConfig())[newIndex]
    );
  };
  colorGroupChanged() {
    this.setState({ colorGroupChanged: Math.floor(Math.random() * 100 + 1) });
  }
  handleEntityChange = (event, newEntityType) => {
    this.props.updateEntityType(this.props.getPerEntityConfig()[newEntityType]);
  };

  componentDidUpdate(prevProps, prevState, snapshot) {
    if (this.props.allEntities !== prevProps.allEntities) {
      if (
        _.isEmpty(this.props.allEntities) &&
        _.isEmpty(prevProps.allEntities)
      ) {
        this.openSearchDrawer();
        this.openChatDrawer();
      } else {
        this.openFilterDrawer();
      }
      //reset detail entity
      if (this.state.detailEntity) {
        this.setState({ detailEntity: undefined });
      }
    }
  }

  getCurrentEntity = () => this.props.entitySingular;

  getCurrentEntityConfig = () => {
    return this.props.getPerEntityConfig()[this.getCurrentEntity()];
  };

  getCurrentEntityExtendedDataConfig = () => {
    if (!this.getCurrentEntity()) return;

    let newCurrentConfig = { ...this.getCurrentEntityConfig() };

    const defaultExtendedDataConfig =
      this.props.userConfig.entityDataConfig?.[this.getCurrentEntity()];
    if (defaultExtendedDataConfig) {
      const newCurrentConfigDataAsEntries = Object.entries(
        defaultExtendedDataConfig
      ).map((defaultDataConfig, key) => {
        if (newCurrentConfig.data) {
          return { ...defaultDataConfig, ...newCurrentConfig.data?.[key] };
        } else {
          return { ...defaultDataConfig };
        }
      });

      newCurrentConfig.data = Object.fromEntries(newCurrentConfigDataAsEntries);
    }

    return newCurrentConfig;
  };

  //this assumes `this.props.getPerEntityConfig()` never changes, so it's a long shot
  getCurrentEntityConfigMemo = _.memoize(
    (_currentEntity) => this.props.getPerEntityConfig()[_currentEntity]
  );

  getDetailEntityInstance = () =>
    this.props.selectedEntities && this.props.selectedEntities[0];

  getQueryParams = () =>
    this.props.queryParams.entityType === this.getCurrentEntity()
      ? this.props.queryParams
      : null;

  openModelDrawer = () =>
    this.setState({
      isModelDrawerOpen: this.state.isModelDrawerOpen
        ? this.state.isModelDrawerOpen
        : !this.state.isModelDrawerOpen,
    });
  toggleModelDrawer = () =>
    this.setState({ isModelDrawerOpen: !this.state.isModelDrawerOpen });

  openGisDrawer = () =>
    this.setState({
      isGisDrawerOpen: this.state.isGisDrawerOpen
        ? this.state.isGisDrawerOpen
        : !this.state.isGisDrawerOpen,
    });
  toggleGisDrawer = () =>
    this.setState({ isGisDrawerOpen: !this.state.isGisDrawerOpen });
  
  openSearchDrawer = () =>
    this.setState({
      isSearchDrawerOpen: this.state.isSearchDrawerOpen
        ? this.state.isSearchDrawerOpen
        : !this.state.isSearchDrawerOpen,
    });
  toggleSearchDrawer = () =>
    this.setState({ isSearchDrawerOpen: !this.state.isSearchDrawerOpen });

  openChatDrawer = () =>
    this.setState({
      isChatDrawerOpen: this.state.isChatDrawerOpen
        ? this.state.isChatDrawerOpen
        : !this.state.isChatDrawerOpen,
    });
  toggleChatDrawer = () =>
    this.setState({ isChatDrawerOpen: !this.state.isChatDrawerOpen });

  openFilterDrawer = () =>
    this.setState({
      isFilterDrawerOpen: this.state.isFilterDrawerOpen
        ? this.state.isFilterDrawerOpen
        : !this.state.isFilterDrawerOpen,
    });
  openWorkflowDrawer = () =>
    this.setState({
      isWorkflowDrawerOpen: this.state.isWorkflowDrawerOpen
        ? this.state.isWorkflowDrawerOpen
        : !this.state.isWorkflowDrawerOpen,
    });  
    
  toggleFilterDrawer = () =>
    this.setState({ isFilterDrawerOpen: !this.state.isFilterDrawerOpen });
  
  toggleWorkflowDrawer = () =>
    this.setState({ isWorkflowDrawerOpen: !this.state.isWorkflowDrawerOpen });
  
  openDataDrawer = () =>
    this.setState({
      isDataDrawerOpen: this.state.isDataDrawerOpen
        ? this.state.isDataDrawerOpen
        : !this.state.isDataDrawerOpen,
    });
  toggleDataDrawer = () =>
    this.setState({ isDataDrawerOpen: !this.state.isDataDrawerOpen });
  isGlassMode = () => this.props.isolatedEntities.length > 0;
  /* To address issues with selectEntitiesFromModels failing to set the element for certain graphics elements, 
      store the graphically selected element ID in temporary state ('this') during the callback from the iaf-viewer component. 
      This is crucial to prevent the application from unintentionally unselecting the element when receiving the graphically selected element ID. 
  */
  setGraphicSelectedElementId = (selectedElementIds) =>{
    if(this.props.enableOptimizedSelection){
      this.props.setSelectedElementIds(selectedElementIds);
    }
  }
  tableEntities = () =>
    _.isEmpty(this.props.isolatedEntities)
      ? this.props.allEntities
      : this.props.isolatedEntities;

  actionSuccess = (actionType, newEntity, result) => {
    this.setState({ reloadSearchToken: Math.floor(Math.random() * 100 + 1) });
    this.props.onEntityChange(actionType, newEntity, result);
  };
  generateToken = () => Math.floor(Math.random() * 100 + 1);
  refreshShouldClearToken = () => {
    this.setState({shouldClearToken: Math.floor(Math.random() * 100 + 1)})
    console.log("token",this.state.shouldClearToken )
  }
  getTableActions = () => {
    let actions = this.getCurrentEntityConfig().actions;
    if (!_.isObject(actions)) {
      return undefined;
    }
    return {
      ...actions,
      onSuccess: this.actionSuccess,
      doEntityAction: this.props.doEntityAction,
    };
  };

  handleEntityFilterSelection = (entities) => {
    let intersectionOfSelectedandIsolatedEntities =
      this.props.selectedEntities.filter((entity) => entities.includes(entity));
    intersectionOfSelectedandIsolatedEntities =
      intersectionOfSelectedandIsolatedEntities.map((e) => ({
        ...e,
        checked: true,
      }));
    this.handleEntitySelection(intersectionOfSelectedandIsolatedEntities);
    this.props.setIsolatedEntities(entities);
  };

  chooseDetailEntity = (checked, unchecked) => {
    if (unchecked.length > 0 || checked.length > 0) {
      //select or deselect
      this.setState({
        detailEntity:
          checked.length > 1 ? checked[checked.length - 1] : checked[0],
      });
    }
  };

  handleEntitySelection = (entities) => {
    const previouslySelected = this.props.selectedEntities;
    const checkedEntities = entities.filter((e) => e.checked);
    let unchecked = previouslySelected.filter(
      (e) => !checkedEntities.includes(e)
    );
    let checked = checkedEntities.filter(
      (e) => !previouslySelected.includes(e)
    );
    if (unchecked.length > 0 || checked.length > 0) {
      //select or deselect
      this.setState({
        detailEntity:
          checked.length > 1 ? checked[checked.length - 1] : checked[0],
      });
    }
    this.props.setSelectedEntities(checkedEntities);
    this.setGraphicSelectedElementId(checkedEntities.map(x=> x.modelViewerIds[0]))
  };

  handleEntitySelectionOnDetail = (entity) => {
    const clickedEntity = { ...entity, checked: !entity.checked };
    let unchecked = !clickedEntity.checked ? [clickedEntity] : [];
    let checked = unchecked.length > 0 ? [] : [clickedEntity];
    if (clickedEntity.checked) {
      //select
      this.setState({ detailEntity: clickedEntity });
      this.props.setSelectedEntities(
        this.props.selectedEntities.concat([clickedEntity])
      );
      this.setGraphicSelectedElementId([...this.props.selectedEntities.map(x=>x.modelViewerIds[0]), clickedEntity.modelViewerIds[0]]);
    } else {
      //deselect
      const checkedEntities = this.props.selectedEntities.filter(
        (e) => e._id !== clickedEntity._id
      );
      this.setState({
        detailEntity:
          checkedEntities.length > 0
            ? checkedEntities[checkedEntities.length - 1]
            : undefined,
      });
      this.props.setSelectedEntities(checkedEntities);
      this.setGraphicSelectedElementId(checkedEntities.map(x=> x.modelViewerIds[0]))
    }
  };

  handleEntitySelectionFromModel = (modelEntities) => {
    /* To address issues with selectEntitiesFromModels failing to set the element for certain graphics elements, 
       store the graphically selected element ID in temporary state ('this') during the callback from the iaf-viewer component. 
       This is crucial to prevent the application from unintentionally unselecting the element when receiving the graphically selected element ID. 
    */
    if(this.props.enableOptimizedSelection){
      const selectedIds = modelEntities.map(x => x.id);
      // If glass mode is enabled and no elements are graphically selected, do not update/clear the existing selection.
      if(this.props.isolatedEntities > 0 && modelSelectedEntities.length <= 0) return;
      // If glass mode is enabled, append the graphically selected with the existing selection (multiselect),
      // else just override the graphic selection.
      
      //Local state
      const hasDeletedElements = this.props.selectedElementIds.some(x=> selectedIds.some(y=>y == x))
      const selectedElements = this.isGlassMode() ? hasDeletedElements
          ? this.props.selectedElementIds.filter(x => !selectedIds.includes(x))
          : [...this.props.selectedElementIds, ...selectedIds]
        : [...selectedIds];
      this.setGraphicSelectedElementId(selectedElements)
      
      //Global state
      let entities = (this.props.selectedEntities || []).map((e) => { return { id : e.modelViewerIds[0]} });
      const hasDeletedEntities = entities.some(x => selectedIds.some(y => y === x.id))
      const selectedEntities = this.isGlassMode() ? hasDeletedEntities
            ? entities.filter(x => !selectedIds.some(y => y === x.id))
            : [...entities, ...modelEntities]
          : [...modelEntities];
      this.props.selectEntitiesFromModels(selectedEntities);
    }else{
      this.props.selectEntitiesFromModels(modelEntities);
    }
    this.setState({
      detailEntity:
        modelEntities.length > 0
          ? modelEntities[modelEntities.length - 1]
          : undefined,
    });
  };

  clearSearchAndFilters = () => {
    this.props.onGroupOrFilterChange({
      entityType: this.getCurrentEntity(),
      query: null,
      groups: null,
      filters: null,
    });
    this.props.clearEntities([]);
    //Clear the local state on clear filter.
    if(this.props.enableOptimizedSelection){
      this.setGraphicSelectedElementId([])
    }
    this.refreshShouldClearToken();
  };

  onEntityListSortChange = (currentSort) => {
    this.setState({ entityListSort: currentSort });
  };

  handleMapboxToken(token) {
    IafSession.setSessionStorage('mapboxToken', token);
    this.setState({ mapboxToken: token });  
  }

  render() {
    const config = this.getCurrentEntityConfig();

    const nonGroupableProps =
      config?.entitySelectionPanel?.nonGroupableProperties || [];
    const nonFilterableProps =
      config?.entitySelectionPanel?.nonFilterableProperties || [];
    const defaultGroups = config?.entitySelectionPanel?.defaultGroups || [];
    
    return (
      <div className="navigator-view">
        {this.state.isModelPresent  && !this.state.isFetching ? (
          <>
            <div className="navigator-viewer">
              <EnhancedIafViewer
                name={"NavigatorViewer"}
                model={this.props.selectedItems.selectedModel}
                compareModel={this.state.modelsData ? this.state.modelsData[0] : null}
                viewerResizeCanvas={true}
                isolatedEntities={this.props.isolatedEntities}
                selectedEntities={this.props.selectedEntities}
                onSelect={this.handleEntitySelectionFromModel}
                selectedElementIds={this.props.selectedElementIds}
                enableOptimizedSelection={this.props.enableOptimizedSelection}
                allEntities={this.state.allEntities}
                workflow={this.state.workflow}
                enableGisDrawer={this.enableGisDrawer}
                mapboxToken={this.state.mapboxToken}
              />
            </div>
            <div className="navigator-view__panels">
              <div className="navigator-view__drawers">
              <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={1}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isWorkflowDrawerOpen}
                  >
                    <div className="navigator-drawer-content">
                      <WorkflowSearch 
                        project={this.props?.selectedItems?.selectedProject}
                        onWorkflowUpdate={(workflow) => {
                            this.setState({workflow});
                        }}
                      />
                    </div>
                  </StackableDrawer>
                </div>
                <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={1}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isModelDrawerOpen}
                  >
                    <div className="navigator-drawer-content">
                      <h4>Models</h4>
                      <ModelPanel props={this.props}/>                     
                    </div>
                  </StackableDrawer>
                </div>
                <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={2}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isSearchDrawerOpen}
                  >
                    <div className="navigator-drawer-content">
                      <SearchModelessTab
                        config={this.props.getPerEntityConfig()}
                        fetch={this.props.getFetcher}
                        /*queryParams={this.getQueryParams()}*/
                        queryParamsPerEntityType={
                          this.props.queryParamsPerEntityType
                        }
                        currentTab={this.props.entitySingular}
                        handleTabChange={this.handleEntityChange}
                        reloadToken={this.state.reloadSearchToken}
                        shouldClearToken={this.state.shouldClearToken}
                      />
                    </div>
                  </StackableDrawer>
                </div>
                <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={3}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isFilterDrawerOpen}
                  >
                    <div className="navigator-drawer-content">
                      <EntitySelectionPanel
                        selectedGroups={this.props.groups}
                        selectedFilters={this.props.appliedFilters}
                        selectedEntities={this.props.isolatedEntities}
                        fetching={this.props.fetching}
                        entities={this.props.allEntities}
                        onGroupOrFilterChange={this.props.onGroupOrFilterChange}
                        leafNodeRenderer={leafNodeRenderer}
                        branchNodeRenderer={branchNodeRenderer}
                        name={this.props.entitySingular + "_selection_panel"}
                        onSelect={this.handleEntityFilterSelection}
                        treeSelectMode={TreeSelectMode.NONE_MEANS_NONE}
                        entitySingular={this.props.entitySingular}
                        entityPlural={this.props.entityPlural}
                        nonFilterableProperties={nonFilterableProps}
                        nonGroupableProperties={nonGroupableProps}
                        defaultGroups={defaultGroups}
                        colorGroupChanged={this.colorGroupChanged}
                      />
                    </div>
                  </StackableDrawer>
                </div>
                <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={4}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isDataDrawerOpen}
                    fixedWidth={500}
                  >
                    <div className="navigator-drawer-content">
                      <EntityListView
                        config={
                          this.getCurrentEntityConfig().tableView.component
                        }
                        entities={this.tableEntities()}
                        actions={this.getTableActions()}
                        context={this.context}
                        selectedEntities={this.props.selectedEntities}
                        onChange={this.handleEntitySelection}
                        onDetail={this.handleEntitySelectionOnDetail}
                        entitySingular={this.props.entitySingular}
                        onSortChange={this.onEntityListSortChange}
                      />
                    </div>
                  </StackableDrawer>
                </div>
                <div className="navigator-drawer-container">
                  <StackableDrawer
                    level={1}
                    defaultOpen={false}
                    isDrawerOpen={this.state.isGisDrawerOpen}
                  >
                    <div className="navigator-drawer-content">
                      <FormControlLabel
                        control={
                          <Switch
                            checked={this.state.isGisDirectionEnabled}
                            onChange={this.handleEnableDirectionChange}
                            color="primary"
                          />
                        }
                        label="Enable Directions"
                      />
                    </div>
                  </StackableDrawer>
                </div>
              </div>
              <EntityDetailBottomPanel
                loadingDataGroups={this.props.loadingAvailableDataGroups}
                availableDataGroups={this.props.availableDataGroups}
                entityType={this.getCurrentEntity()}
                config={this.getCurrentEntityConfig()}
                getData={this.props.getEntityExtendedData(
                  this.getCurrentEntityExtendedDataConfig()?.data
                )}
                selectedEntities={this.props.selectedEntities}
                handler={this.props.handler}
                clearSearchAndFilters={this.clearSearchAndFilters}
                doEntityAction={this.props.doEntityAction}
                onEntityChange={this.props.onEntityChange}
                entitySingular={this.props.entitySingular}
                isDataDrawerOpen={this.state.isDataDrawerOpen}
                isWorkflowDrawerOpen={this.state.isWorkflowDrawerOpen}
                isFilterDrawerOpen={this.state.isFilterDrawerOpen}
                isSearchDrawerOpen={this.state.isSearchDrawerOpen}
                isChatDrawerOpen={this.state.isChatDrawerOpen}
                isModelDrawerOpen={this.state.isModelDrawerOpen}
                toggleDataDrawer={this.toggleDataDrawer}
                toggleFilterDrawer={this.toggleFilterDrawer}
                toggleWorkflowDrawer={this.toggleWorkflowDrawer}
                toggleSearchDrawer={this.toggleSearchDrawer}
                toggleChatDrawer={this.toggleChatDrawer}
                toggleModelDrawer={this.toggleModelDrawer}
                toggleGisDrawer={this.toggleGisDrawer}
                isGisMode={this.state.isGisMode}
                isGisDrawerOpen={this.state.isGisDrawerOpen}
                entity={this.state.detailEntity}
                context={this.context}
                entityListSort={this.state.entityListSort}
                onActionSuccess={this.actionSuccess}
              />
            </div>
          </>
        ) : (
          <div style={{ textAlign: "center", margin: "auto", width: "50%" }}>
            {!this.state.isFetching && !this.state.isModelPresent ? (
              <h3>No Model Present</h3>
            ) : (
              <h3>Fetching Model...</h3>
            )}
          </div>
        )}
      </div>
    );
  }
}

NavigatorView.contextTypes = {
  ifefPlatform: PropTypes.object,
  ifefSnapper: PropTypes.object,
  ifefNavDirection: PropTypes.string,
  ifefShowPopover: PropTypes.func,
  ifefUpdatePopover: PropTypes.func,
  ifefUpdatePopup: PropTypes.func,
  ifefShowModal: PropTypes.func,
};

const {
  clearEntities,
  getAllCurrentEntities,
  getAppliedFilters,
  getFetchingCurrent,
  isSelectingEntities,
  setIsolatedEntities,
  setEntities,
  setViewerSyncOn,
  getIsolatedEntities,
  getSelectedEntities,
  getCurrentEntityType,
  selectEntitiesFromModels,
} = Entities;

const mapStateToProps = (state) => ({
  allEntities: getAllCurrentEntities(state),
  fetching: getFetchingCurrent(state),
  isSelectingEntity: isSelectingEntities(state),
  appliedFilters: getAppliedFilters(state),
  isolatedEntities: getIsolatedEntities(state),
  selectedEntities: getSelectedEntities(state),
  currentEntityType: getCurrentEntityType(state),
});

const mapDispatchToProps = {
  setViewerSyncOn,
  setEntities,
  setIsolatedEntities,
  clearEntities,
  selectEntitiesFromModels,
};

export default compose(
  withEntitySearchNav,
  connect(mapStateToProps, mapDispatchToProps)
)(NavigatorView);
