/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, {useMemo,useCallback} from "react";
import {Tab, Tabs} from "@mui/material";
import {EnhancedFetchControl} from "@dtplatform/platform-app-conflux/modules/IpaControls";
import _ from 'lodash'

const SearchModelessTab = ({config, fetch, currentTab, handleTabChange, queryParamsPerEntityType, reloadToken, shouldClearToken}) => {
    const fetchingFunctionsMap = useMemo(()=>{
        const functions = new Map();
        _.values(config).forEach(cfg => {
            functions.set(cfg.singular,fetch(cfg.script, undefined, {ignoreCachedScriptResult: true}));
        })
        return functions;
    },[fetch,config]);

    const selectorsMap = useMemo(()=>{
        const _selectorsMap = new Map();
        _.values(config).forEach(cfg => {
            const queryParams = queryParamsPerEntityType[cfg.singular];
            let selectors = cfg.selectors.map((selector, index) => {
                if(queryParams && queryParams.entityType === cfg.singular && index === queryParams?.query?.id) {
                    return {...selector, currentValue: queryParams?.query?.value, currentState : queryParams?.selector?.currentState}
                } else return selector
            })
            _selectorsMap.set(cfg.singular,selectors);
        })
        return _selectorsMap;
    },[config,queryParamsPerEntityType]);

    const tabContents = useMemo(()=>{
        const contents = new Map();
        _.values(config).forEach(cfg => {
            const queryParams = queryParamsPerEntityType[cfg.singular];
            contents.set(cfg.singular, <EnhancedFetchControl initialValue={queryParams && queryParams.entityType === cfg.singular ? queryParams.query : null}
                                                             selectors={selectorsMap.get(cfg.singular)}
                                                             doFetch={fetchingFunctionsMap.get(cfg.singular)}
                                                             reloadToken={reloadToken}
                                                             shouldClearToken={shouldClearToken}
            />);
        });
        return contents;
    },[config, queryParamsPerEntityType, fetch, reloadToken, shouldClearToken]);

    const onClickTab = useCallback((e)=>{
        return handleTabChange(e,e.target.textContent)
    },[]);

    return <div className='modless-search-tab'>
        <div className={'general-title'}>Search For</div>
        <Tabs
            value={currentTab}
            onChange={handleTabChange}
        >
            {_.values(config).map(c => <Tab key={c.singular} label={c.plural} value={c.singular}/>)}
        </Tabs>
        <div className='fetch-container'>
            {tabContents.get(currentTab)}
        </div>
    </div>
};

export default SearchModelessTab;
