// -------------------------------------------------------------------------------------
// Date        Author     Referene    Comments
// 30-03-25    ATK        PLG-1137    Created
//                        PLG-1137    GIS 1.0 - Design an interface for mapbox to be accessed from Application
// -------------------------------------------------------------------------------------

export class IafResourceUtils {

    static mapboxResourcesLoaded = false;
    static mapboxGeocoderLoaded = false;

    static getUrlExtension(url) {
        const match = url.match(/\.([0-9a-z]+)(?:[\?#]|$)/i);
        return match ? match[1] : null;
    }
    // Function to load a JS or CSS file
    static loadJsDeprecated(url) {
        return new Promise((resolve, reject) => {
            let element;

            if (IafResourceUtils.getUrlExtension(url) === 'js') {
                // Load JavaScript file
                element = document.createElement('script');
                element.src = url;
                element.async = true;
                element.onload = () => resolve(`Script loaded: ${url}`);
                element.onerror = () => reject(`Failed to load script: ${url}`);
            } else {
                return reject('Failed to load script', 'invalid format', type);
            }
            
            // Append the element to the document head
            document.head.appendChild(element);
        });
    }

    static removeJs(url) {
        return new Promise((resolve, reject) => {
            // Check if the URL has a .js extension
            if (IafResourceUtils.getUrlExtension(url) !== 'js') {
                return reject(new Error('Failed to remove script: invalid format'));
            }
    
            // Find the existing script element by its src attribute
            const existingScript = document.querySelector(`script[src="${url}"]`);
            if (existingScript) {
                // Remove the existing script from the document
                existingScript.parentNode.removeChild(existingScript);
                console.log ('IafResourceUtils.removeJs', url, 'removed');
                resolve(); // Resolve the promise when the script is successfully removed
            } else {
                // If the script was not found, resolve the promise with a message
                resolve(new Error(`Script not found: ${url}`));
            }
        });
    }
    
    static reloadJs(url) {
        return new Promise((resolve, reject) => {
            // First, remove the existing script if it exists
            this.removeJs(url)
                .then(() => {
                    // After removal, load the new script
                    return this.loadJs(url);
                })
                .then(() => {
                    resolve(); // Resolve when the new script is successfully loaded
                })
                .catch((error) => {
                    reject(new Error(`Failed to reload script: ${error.message}`));
                });
        });
    }    
    
    static isJsLoaded(url) {
        const script = document.querySelector(`script[src="${url}"]`);
        if (script) {
          if (script.readyState === 'loading' || script.getAttribute('data-loading') === 'true') {
            return 'loading'; // The script is in the process of being loaded
          }
          return 'loaded'; // The script has been loaded
        }
        return 'not loaded'; // The script is not present in the document
    }

    static loadJs(url) {
        return new Promise((resolve, reject) => {
            let element;

            if (IafResourceUtils.getUrlExtension(url) === 'js') {
                if (!document.querySelector(`script[src="${url}"]`)) {
                    const script = document.createElement('script');
                    script.src = url;
                    script.onload = () => {
                        console.log ('IafResourceUtils.loadJs', url, 'loaded');
                        resolve(`JS loaded: ${url}`);
                    };
                    script.onerror = () => {
                        console.log ('IafResourceUtils.loadJs', url, 'not loaded');
                        // reject(new Error(`Failed to load script: ${url}`));
                        reject(`Failed to load CSS: ${url}`);
                    };
                    script.async = true; // Optional: loads the script asynchronously
                    document.body.appendChild(script);
                  } else {
                    resolve(); // Resolve immediately if script is already present
                  }                

            } else {
                return reject('Failed to load script', 'invalid format', type);
            }
        });
    }    

    static loadCss(url) {
        return new Promise((resolve, reject) => {
            let element;

            if (IafResourceUtils.getUrlExtension(url) === 'css') {
                // Load CSS file
                element = document.createElement('link');
                element.href = url;
                element.rel = 'stylesheet';
                element.onload = () => resolve(`CSS loaded: ${url}`);
                element.onerror = () => reject(`Failed to load CSS: ${url}`);
            } else {
                return reject('Failed to load style', 'invalid format', type);
            }

            // Append the element to the document head
            document.head.appendChild(element);
        });
    }    

    static async loadMapboxDirections() {
        if (IafResourceUtils.mapboxDirectionsLoaded) {
            console.log ('PlatformReferenceApp.IafResourceUtils.loadMapboxDirections', 'Mapbox Directions Dependencies have been already loaded');
            return;
        }

        try {
            const jsFile = IafResourceUtils.loadJs('https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-directions/v4.3.1/mapbox-gl-directions.js');
            const cssFile = IafResourceUtils.loadCss('https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-directions/v4.3.1/mapbox-gl-directions.css');

            // Wait for both to load
            const [jsResult, cssResult] = await Promise.all([jsFile, cssFile]);

            console.log('PlatformReferenceApp.IafResourceUtils.loadMapboxDirections', jsResult); 
            console.log('PlatformReferenceApp.IafResourceUtils.loadMapboxDirections', cssResult);

            IafResourceUtils.mapboxDirectionsLoaded = true;
        } catch (error) {
            console.error('PlatformReferenceApp.IafResourceUtils.loadMapboxDirections', error); // Logs any errors if files fail to load
        }
    }    
}