// -------------------------------------------------------------------------------------
// Date        Author     Referene    Comments
// 30-03-25    ATK        PLG-1137    Created
//                        PLG-1137    GIS 1.0 - Design an interface for mapbox to be accessed from Application
// -------------------------------------------------------------------------------------

export const addPointToCenter = (iafmap) => {
    // 🌍 Add a GeoJSON layer using the map's center
    const center = iafmap.getCenter(); // Get the current map center

    iafmap.addSource("demo-points", {
        type: "geojson",
        data: {
            type: "FeatureCollection",
            features: [
                {
                    type: "Feature",
                    geometry: {
                        type: "Point",
                        coordinates: [center.lng, center.lat] // 🌍 Use dynamic center
                    },
                    properties: {
                        title: "Center Point"
                    }
                }
            ]
        }
    });

    iafmap.addLayer({
        id: "demo-layer",
        type: "circle",
        source: "demo-points",
        paint: {
            "circle-radius": 8,
            "circle-color": "#f00"
        }
    });

    console.log("✅ Custom Layer Added at Center:", center);    
}

export const addColoredRegionToCenter = (iafmap) => {
    const center = iafmap.getCenter(); // Get the current map center

    iafmap.addSource("center-region", {
        type: "geojson",
        data: {
            type: "FeatureCollection",
            features: [
                {
                    type: "Feature",
                    geometry: {
                        type: "Point",
                        coordinates: [center.lng, center.lat] // 🌍 Dynamic center
                    }
                }
            ]
        }
    });    

    iafmap.addLayer({
        id: "center-circle",
        type: "circle",
        source: "center-region",
        paint: {
            "circle-radius": {
                stops: [[0, 0], [10, 50000]] // Scale radius with zoom
            },
            "circle-color": "rgba(255, 0, 0, 0.3)", // 🔥 Red transparent fill
            "circle-opacity": 0.5
        }
    });

    console.log("✅ Region Colored Around Center:", center);    
}

export const createPolygonAroundCenter = (iafmap) => {
    const center = iafmap.getCenter();

    const _createPolygonAroundCenter = (radiusKm = 10, sides = 64) => {
        const coords = [];
        const earthRadiusKm = 6371; // Earth's radius
    
        for (let i = 0; i < sides; i++) {
            const angle = (i / sides) * Math.PI * 2;
            const dx = (radiusKm / earthRadiusKm) * (180 / Math.PI) * Math.cos(angle);
            const dy = (radiusKm / earthRadiusKm) * (180 / Math.PI) * Math.sin(angle) / Math.cos(center.lat * Math.PI / 180);
            coords.push([center.lng + dx, center.lat + dy]);
        }
        coords.push(coords[0]); // Close the polygon
    
        return {
            type: "Feature",
            geometry: {
                type: "Polygon",
                coordinates: [coords]
            }
        };
    };

    const polygonFeature = _createPolygonAroundCenter(2); // 🟢 Fixed 10 km radius

    iafmap.addSource("polygon-region", {
        type: "geojson",
        data: {
            type: "FeatureCollection",
            features: [polygonFeature]
        }
    });

    iafmap.addLayer({
        id: "polygon-layer",
        type: "fill",
        source: "polygon-region",
        paint: {
            "fill-color": "rgba(255, 255, 0, 0.5)", // 🟢 Green transparent fill
            "fill-opacity": 0.5,
            "fill-outline-color": "#008000" // Darker green outline
        }
    });    
}