// -------------------------------------------------------------------------------------
// Date        Author     Referene    Comments
// 30-03-25    ATK        PLG-1137    Created
//                        PLG-1137    GIS 1.0 - Design an interface for mapbox to be accessed from Application
// -------------------------------------------------------------------------------------

import { IafResourceUtils } from "./IafResourceUtils";

let direction = null;

export const toggleDirections = (iafmap, enable) => {
    IafResourceUtils.loadMapboxDirections().then(() => {
        if (enable) {
            direction = new MapboxDirections({
                accessToken: mapboxgl.accessToken,
                interactive: false, // Prevents user interaction modifying zoom/center
                flyTo: false // Disable automatic camera movements                
            });
            iafmap.addControl(direction, 'bottom-left');    
        } else {
            direction && iafmap.removeControl(direction);
            direction = null;
        }
    })
}