// -------------------------------------------------------------------------------------
// Date        Author     Referene    Comments
// 30-03-25    ATK        PLG-1137    Created
//                        PLG-1137    GIS 1.0 - Design an interface for mapbox to be accessed from Application
// -------------------------------------------------------------------------------------

import { addColoredRegionToCenter, addPointToCenter, createPolygonAroundCenter } from "./customgeometry";
import { toggleDirections } from "./directions";

export const onIafMapReady = (iafmap, enable) => {
    console.log("IafMap is ready!", iafmap);

    const getRandomNumber = (min, max) => {
        return Math.floor(Math.random() * (max - min + 1)) + 14;
    }

    // Directions examples
    if (1)
    {
        toggleDirections(iafmap, enable);
    }

    // Custom Geometry
    if (0) {
        setTimeout(() => {
            addPointToCenter(iafmap);
            createPolygonAroundCenter(iafmap);
            addColoredRegionToCenter(iafmap);    
        }, 5_000);
    }

    // Zoom, Bearing, Pitch examples
    if (1)
    {
        setTimeout(()=>iafmap.setZoom(getRandomNumber(14, 16)), 3_000);
        setTimeout(()=>iafmap.setBearing(getRandomNumber(0, 85)), 2_000);
        setTimeout(()=>iafmap.setPitch(getRandomNumber(0, 175)), 1_000);
    }    
};
