// import {
//   // useSearchParams,
//   useLocation,
//   // useMatch,
// } from 'react-router-dom';
import { getConfig } from "./config";
// import { getDistrictGraphics } from './commands';
import { APPLICATION_ID } from '../states';

export const DEFAULT_PAGE_NAME = [
  'Chicago',
  'District View',
  'Street View',
  'Inside View',
];

export const BASIC_GIS_CONTROL = [
  "+",
  "-",
  "Shift",
  "_",
  "=",
  "ArrowUp",
  "ArrowDown",
  "ArrowRight",
  "ArrowLeft",
  "W",
  "S",
  "A",
  "D",
  "w",
  "s",
  "a",
  "d",
  "drag",
  "mouse-wheel"
];

export function getGisProperties(searchParamName = null, searchParamDistrict=null, blockedInputEvents=null) {
  return {
    mode: "arcgis",
    // command={command}
    appId: {APPLICATION_ID},
    config:
      getConfig({
        configName: "citydistrict",
        searchParamName, // searchParams.get("p"),
        searchParamDistrict, // searchParams.get("d"),
        blockedInputEvents
      }),
    // graphics: getDistrictGraphics()
  }
} 

export function getGisOverviewPropertiesForDisctrict(searchParamName = null, searchParamDistrict=null, blockedInputEvents=null) {
  return {
    mode: "arcgis",
    // command={command}
    appId: {APPLICATION_ID},
    config:
      getConfig({
        configName: "insetmapcitydistrict",
        searchParamName, // searchParams.get("p"),
        searchParamDistrict, // searchParams.get("d"),
        blockedInputEvents
      }),
    // graphics: getDistrictGraphics()
  }
} 

export function getGisOverviewPropertiesForStreetOrInside(searchParamName = null, searchParamDistrict=null, blockedInputEvents=null) {
  return {
    mode: "arcgis",
    // command={command}
    appId: {APPLICATION_ID},
    config:
      getConfig({
        configName: "insetMapCityDistrict",
        searchParamName, // searchParams.get("p"),
        searchParamDistrict, // searchParams.get("d"),
        blockedInputEvents
      }),
    // graphics: getDistrictGraphics()
  }
} 
