export const PHOTO_CONFIG = {
  modelUriBase: `/reference/invicara/models/360Tour/` // http://localhost:3000/guestexptwin/models/360Tour/`
}
export const publicPath = "/reference/invicara";

const RANDOLPH = {
  id: "Randolph",
  defaultImage: "188 Randolph - Lobby 1.jpg",
  defaultScene:   {
    "id": "Randolph",
    "autoLoad": true,            
    "title": "188 Randolph - Lobby",
    "hfov": 110,
    "pitch": -6.983,
    "yaw": -181.662,
    "type": "equirectangular",
    "panorama": `188 Randolph - Lobby 1.jpg`,    
    "hotSpots": [
        {
            "pitch": 1.317,
            "yaw": -94.635,
            "type": "scene",
            "text": "Lobby",
            "sceneId": "188RandolphLobby",
            "targetYaw": -57.655,
            "targetPitch": 0.772,
        }
    ]
  },
  scenes: [
    {
      "id": "188RandolphLobby",
      "title": "188 Randolph - Lobby",
      "hfov": 110,
      "pitch": -5.528,
      "yaw": 302.965,
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/188 Randolph - Lobby 3.jpg`,
      "hotSpots": [{
          "pitch": 3.309,
          "yaw": -70.289,
          "type": "scene",
          "text": "Elevators to Gym and more",
          "sceneId": "pool",
          "targetYaw": 101.206,
          "targetPitch": -4.525
      }]
    },
    {
      "id": "pool",
      "title": "188 Randolph - Pool",
      "hfov": 110,
      "pitch": 2.466,
      "yaw": 176.333,
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/188 Randolph - Swimming Pool 1.jpg`,
      "hotSpots": [{
          "pitch": 0.649,
          "yaw": -123.934,
          "type": "scene",
          "text": "Return to lobby",
          "sceneId": "188RandolphLobby",
          "targetYaw": 2.990,
          "targetPitch": -5.188
      }, {
          "pitch": 0.177,
          "yaw": -102.103,
          "type": "scene",
          "text": "Lounge",
          "sceneId": "Lounge",
          "targetYaw": 262.185,
          "targetPitch": 0.36
      }]                
    },
    {
      "id": "Lounge",
      "title": "188 Randolph - Lounge",
      "hfov": 110,
      "pitch": 0.36,
      "yaw": 262.185,
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/188 Randolph - Lounge 1.jpg`,
      "hotSpots": [{
          "pitch": 0.167,
          "yaw": 104.805,
          "type": "scene",
          "text": "Pool Table",
          "sceneId": "PoolTable",
          "targetYaw": 290.612,
          "targetPitch": -12.852
      }, {
          "pitch": 0.81,
          "yaw": -71.255,
          "type": "scene",
          "text": "Pool, Elevators, Gym, and Lobby",
          "sceneId": "pool",
          "targetYaw": 236.129,
          "targetPitch": -8.120
      }]                
    },
    {
      "id": "PoolTable",
      "title": "188 Randolph - Lounge",
      "hfov": 110,
      "pitch": -12.852,
      "yaw": 290.612,
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/188 Randolph - Lounge 2.jpg`,
      "hotSpots": [{
          "pitch": 1.053,
          "yaw": -87.691,
          "type": "scene",
          "text": "Lounge",
          "sceneId": "Lounge",
          "targetYaw": 262.185,
          "targetPitch": 0.36
      }]
    }
  ]
}
  
const CADILLAC = {
  id: "Cadillac",
  defaultImage: `Cadillac Theatre - Lobby 1.jpg`,
  defaultScene: {
    "id": "Cadillac",
    "autoLoad": true,
    "title": "Cadillac Theatre - Lobby 1",
    "type": "equirectangular",
    "panorama": `Cadillac Theatre - Lobby 1.jpg`,    
    "hotSpots": [
      {
        "pitch": 2.246,
        "yaw": -171.327,
        "type": "scene",
        "text": "Theatre",
        "sceneId": "cadillac_scene_02",
        "targetYaw": 135.614,
        "targetPitch": 3.914,
      }
    ]
  },
  scenes: [
    {
      "id": "cadillac_hotspot_01",
      "title": "Cadillac Theater",
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/Cadillac Theatre - Lobby 1.jpg`,
      "hotSpots": [
        {
          "pitch": 2.246,
          "yaw": -171.327,
          "type": "scene",
          "text": "Theatre",
          "sceneId": "cadillac_scene_02",
          "targetYaw": 135.614,
          "targetPitch": 3.914,
        }]
    },
    {
      "id": "cadillac_scene_02",
      "title": "Cadillac Theater",
      "hfov": 110,
      "pitch": 1.408,
      "yaw": 182.498,
      "type": "equirectangular",
      "imageSource": `${publicPath}/models/360Tour/Cadillac Theatre - Lobby 2.jpg`,
      "hotSpots": [{
          "pitch": 1.026,
          "yaw": -23.893,
          "type": "scene",
          "text": "Entrance",
          "sceneId": "cadillac_hotspot_01",
          "targetYaw": 356.716,
          "targetPitch": -2.385
      }]
    }
  ]
}
  
export const AVAILABLE_MODELS = {
  "Randolph_Tower": RANDOLPH,
  "Cadillac_Palace_Theatre": CADILLAC
}



// http://localhost:3000/tourism/inside?p=undefined&d=Theatre+District&b=Randolph_Tower