// insetMapStates.js
import { applyBuildingSymbologyAction, applyDistrictsSymbologyAction, clearSymbologyAction, filterDistrictAction, setCameraAction, sketchBuildingsAction, zoomToDistrictAction, zoomToInitAction, zoomToOnly } from "./gis/commands";
import { DISTRICT_OVERHEAD_CAMERAS, getConfig } from "./gis/config";
import { BASIC_GIS_CONTROL, getGisOverviewPropertiesForStreetOrInside } from "./gis/properties";
import { zoomToBuildingAction } from "./ue/commands";
import { KNOWN_BUILDINGS } from "./ue/config";
import { AVAILABLE_MODELS } from "./photo/config";
import { IafEvmUtils } from "@dtplatform/iaf-viewer";
import IafUtils from "../../utils/IafUtils";

export const DISTRICT = 'district';
export const INSET_MAP_ALTITUDE = 2000;
export const APPLICATION_ID = "bf74acef-4905-47c7-a552-75eeb2565208"
export const CONTEXT_ROOT = "guestexptwin"

export const machines = {
  MAIN_MMV: 'main-mmv',
  INSET_MMV: 'inset-mmv'
}

export const states = {
  HOME: 'home',
  CITY_VIEW: 'city_view',
  DISTRICT_VIEW: 'district_view',
  STREET_VIEW: 'street_view',
  INSIDE_VIEW: 'inside_view'
}


export const events = {
  COMMANDS_BATCH_PROCESSED: 'commands_batch_processed',
  CITY_SELECTED: 'city_selected',
  UPDATE_CAMERA: 'update_camera',
  DISTRICT_SELECTED: 'district_selected',
  BUILDING_SELECTED: 'building_selected',
  INSIDE_BUILDING_SELECTED: 'inside_building_selected',
}

const initialContext = {
  districtName: undefined,
  buildingName: undefined,
  commandsBatch: [],
  sketchMode: false,
  districtSymbologyApplied: false
};

export const getInitialContext = () => initialContext;

export const getCityViewEntryCommands = (context) => [
  {
    type: 'ZOOM_TO_INIT',
    coords: { x: 0, y: 0 }
  },
  {
    type: 'APPLY_DISTRICT_SYMBOLOGY'
  },
];

export const getCityViewExitCommands = (context) => {
  return context.districtSymbologyApplied ? [
    {
      type: 'CLEAR_SYMBOLOGY'
    }
  ] : [];
};

export const enterHome = (app) => {
  console.log ('PlatformReferenceApp.enterHome');

  let newgis = {
    ...app.state.arcgis,

    eventHandler: (ev) => {
      let newgis = {...app.state.arcgis};
      let newgisOverview = {...app.state.arcgisOverview};
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.VIEWER_READY:
          newgis.graphics = applyDistrictsSymbologyAction();
          newgisOverview.graphics = structuredClone(newgis.graphics);
          app.setState({arcgis: newgis, arcgisOverview: newgisOverview});
          enterCity(app, ev);
          break;
        
        default:
          break;
      }
    }
  };

  let newgisOverview = {
    ...app.state.arcgisOverview,

    eventHandler: (ev) => {
      switch (ev.eventName?.toLowerCase()) {
        default:
          console.log ('ReferenceApp.eventHandler.Home.arcgisOverview', ev);
          break;
      }
    }      
  };

  let newue = {
    ...app.state.ue,

    eventHandler: (ev) => {
      let newue = {...app.state.ue};
      switch (ev.eventName?.toLowerCase()) {
        default:
          console.log ('ReferenceApp.eventHandler.Home.UE', ev);
          break;
      }
    }      
  }

  app.setState({arcgis: newgis, arcgisOverview: newgisOverview, ue: newue});
}

export const enterCity = (app, ev) => {
  let newgis = {
    ...app.state.arcgis,

    eventHandler: (ev) => {
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.SELECTION_UPDATE:
          console.log ('ReferenceApp.eventHandler.City SELECTION_UPDATE', ev);
          exitCity(app, ev);
          enterDistrict(app, ev);
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_MOVE:
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_ENTER:
          console.log ('ReferenceApp.eventHandler.City POINTER_ENTER', ev);
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_EXIT:
          console.log ('ReferenceApp.eventHandler.City POINTER_EXIT', ev);
          break;
            
        default:
          break;
      }  
    }
  };

  let newue = {...app.state.ue}

  app.setState({arcgis: newgis, ue: newue});
}

export const exitCity = (app, ev) => {

  console.log ('PlatformReferenceApp.exitCity');

  let newgis = {
    ...app.state.arcgis,
    graphics: clearSymbologyAction()
  };

  app.setState({arcgis: newgis});
}

export const exitDistrict = (app, ev) => {
  console.log ('PlatformReferenceApp.exitDistrict');

  let newgis = {
    ...app.state.arcgis,
    graphics: clearSymbologyAction(),
    slicedElements: [],
    zoomElements: [],
    themeElements: []
  };

  app.setState({arcgis: newgis});
}

export const enterDistrict = (app, ev) => {
  const districtName = ev?.payload?.elements?.find(el=>el.elementType==DISTRICT)?.id;
  console.log ('PlatformReferenceApp.enterDistrict'
    , '/districtName', districtName
  )

  let newgis = {
    ...app.state.arcgis,

    slicedElements: filterDistrictAction(districtName),

    zoomElements: zoomToOnly(districtName),

    themeElements: sketchBuildingsAction(districtName),

    graphics: applyBuildingSymbologyAction(districtName),

    config: getConfig({
      configName: "citydistrict",
      searchParamPage: "district",
      searchParamDistrict: districtName,
    }),

    eventHandler: (ev) => {
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.SELECTION_UPDATE:
          console.log ('ReferenceApp.eventHandler.District SELECTION_UPDATE', ev);
          enterStreet(app, ev, districtName)
          enterModel(app, ev, districtName);
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_MOVE:
          console.log ('ReferenceApp.eventHandler.District POINTER_MOVE', ev);
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_ENTER:
          console.log ('ReferenceApp.eventHandler.District POINTER_ENTER', ev);
          break;
    
        case IafEvmUtils.EVM_EVENTS.POINTER_EXIT:
          console.log ('ReferenceApp.eventHandler.District POINTER_EXIT', ev);
          break;
            
        default:
          break;
      }  
    }
  };

  let newgisOverview = {
    ...app.state.arcgisOverview,
    enable: true,

    config: getConfig({
      configName: "insetmapcitydistrict",
      searchParamPage: "district",
      searchParamDistrict: districtName,
    }),

    camera: zoomToInitAction()[0],

    eventHandler: (ev) => {
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.SELECTION_UPDATE:
          console.log ('ReferenceApp.eventHandler.District SELECTION_UPDATE From Overview', ev);
          exitDistrict(app, ev);
          enterDistrict(app, ev);
          break;
  
          default:
            // console.log ('ReferenceApp.eventHandler.District default From Overview', ev);
            break;
      }
    }  
  };

  // let newue = {
  //   ...app.state.ue
  // }

  console.log ('PlatformReferenceApp.enterDistrict', districtName
    , '/newgis', newgis
    // , '/newue', newue
  )

  app.setState({
    arcgis: newgis,
    arcgisOverview: newgisOverview,
    // ue: newue,
    // enableGisOverview: true
  });
}

export const enterStreet = (app, ev, districtName) => {
  console.log ('PlatformReferenceApp.enterStreet', ev);

  const buildingIds = ev?.payload?.elements?.filter(el=>el.elementType=='building')?.map(el=>el.id);
  console.log ('PlatformReferenceApp.enterStreet'
    , '/buildingIds', buildingIds
    , '/districtName', districtName
  )

  let newue = {
    ...app.state.ue,
    enable: true,

    zoomElements: IafUtils.platformEvmPropMode ? zoomToBuildingAction(buildingIds[0]) : [],
    command: IafUtils.platformEvmCommandMode ? zoomToBuildingAction(buildingIds[0]) : [],

    eventHandler: (ev) => {
      let newue = {...app.state.ue};
      let newgisOverview = {...app.state.arcgisOverview};
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.CAMERA_UPDATE:
          const camera = { 
            rotation: { pitch: 0, yaw: 0 },
            position: {...ev?.payload?.position, altitude: INSET_MAP_ALTITUDE}
          };
          newgisOverview.camera = setCameraAction(camera)[0];
          app.setState({arcgisOverview: newgisOverview});
          console.log ('ReferenceApp.eventHandler.Street CAMERA_UPDATE from Unreal Engine', ev);
          break;

        case IafEvmUtils.EVM_EVENTS.SELECTION_UPDATE:
          console.log ('ReferenceApp.eventHandler.Street SELECTION_UPDATE From Unreal Engine', ev);
          enterInsideBuilding(app, ev, districtName);
          break;

        case IafEvmUtils.EVM_EVENTS.COMMAND_RECEIVED:
          console.log ('ReferenceApp.eventHandler.Street COMMAND_RECEIVED From Unreal Engine', ev);
          break;

        default:
          // console.log ('ReferenceApp.eventHandler.Street', ev);
          break;
      }
    }
  };

  let newgisOverview = {
    ...app.state.arcgisOverview,

    config: getConfig({
      configName: "insetmapstreetinside",
      searchParamPage: "street",
      searchParamDistrict: districtName,
    }),

    slicedElements: filterDistrictAction(districtName),

    themeElements: sketchBuildingsAction(districtName, true),

    camera: setCameraAction(DISTRICT_OVERHEAD_CAMERAS[districtName])[0],

    eventHandler: (ev) => {
      switch (ev.eventName?.toLowerCase()) {
        case IafEvmUtils.EVM_EVENTS.SELECTION_UPDATE:
          console.log ('ReferenceApp.eventHandler.Street SELECTION_UPDATE From Overview', ev);
          enterStreet(app, ev, districtName);
          break;

        case IafEvmUtils.EVM_EVENTS.COMMAND_RECEIVED:
          console.log ('ReferenceApp.eventHandler.Street COMMAND_RECEIVED From Overview', ev);
          break;
  
        default:
          // console.log ('ReferenceApp.eventHandler.Street default From Overview', ev);
          break;
      }
    }  
  };
  
  app.setState({arcgisOverview: newgisOverview, ue: newue});
}

export const enterInsideBuilding = (app, ev, districtName) => {
  const buildingIds = ev?.payload?.elements?.filter(el=>el.elementType=='gis_building')?.map(el=>el.id);
  console.log ('PlatformReferenceApp.enterInsideBuilding'
    , '/buildingIds', buildingIds
    , '/districtName', districtName
  )

  let id = buildingIds[0]
  let buildingName = KNOWN_BUILDINGS[id]
  if (buildingName) {
      // console.log("We have a winner:", buildingName)
      // _selectInsideBuilding(buildingName);

      console.log ('PlatformReferenceApp.enterInsideBuilding'
        , '/buildingIds', buildingIds
        , '/districtName', districtName
        , '/buildingName', buildingName
      )

      let newphotosphere = {
        ...app.state.photosphere,
        enable: true,
        config: {
          ...app.state.photosphere.config,
          model: AVAILABLE_MODELS[buildingName] 
        }
      }

      app.setState({
        photosphere: newphotosphere
      });
  }
}

export const enterModel = (app, ev, districtName) => {
  // const buildingIds = ev?.payload?.elements?.filter(el=>el.elementType=='gis_building')?.map(el=>el.id);
  // console.log ('PlatformReferenceApp.enterModel'
  //   , '/buildingIds', buildingIds
  //   , '/districtName', districtName
  // )

  // let id = buildingIds[0]
  // let buildingName = KNOWN_BUILDINGS[id]
  // if (buildingName) 
  {
  //     // console.log("We have a winner:", buildingName)
  //     // _selectInsideBuilding(buildingName);

  //     console.log ('PlatformReferenceApp.enterInsideBuilding'
  //       , '/buildingIds', buildingIds
  //       , '/districtName', districtName
  //       , '/buildingName', buildingName
  //     )

  //     let newphotosphere = {
  //       ...app.state.photosphere,
  //       enable: true,
  //       config: {
  //         ...app.state.photosphere.config,
  //         model: AVAILABLE_MODELS[buildingName] 
  //       }
  //     }

      app.setState({
        view3d: {
          enable: true,
          showToolbar: true,
          displayMode: IafEvmUtils.EVMDisplayMode.DEFAULT,
          alignment: IafEvmUtils.EVMWidgetAlignment.RIGHT_TOP
        },
        view2d: {
          enable: true,
          showToolbar: true,
          displayMode: IafEvmUtils.EVMDisplayMode.DEFAULT,
          alignment: IafEvmUtils.EVMWidgetAlignment.RIGHT_LEFT
        },
        [IafEvmUtils.EVMMode.Mapbox]: {
          enable: true,
          showToolbar: true,
          displayMode: IafEvmUtils.EVMDisplayMode.DEFAULT,
          alignment: IafEvmUtils.EVMWidgetAlignment.RIGHT_TOP
        }
      });
  }
}