// -------------------------------------------------------------------------------------
// Date        Author     Referene    Comments
// 02-08-24    ATK                    Created. P&ID Workflow Demonstration
// -------------------------------------------------------------------------------------

import React from "react";
// import { w_9d675926_c139_4d1d_9f00_f17633116b65 } from "./jsons/w_9d675926_c139_4d1d_9f00_f17633116b65";
import { w_54caf6e0_92ce_47cd_95cc_10cef9fa8015 } from "./jsons/w_54caf6e0_92ce_47cd_95cc_10cef9fa8015";

export const getUrlSearchParams = () => {
    let urlParams = new URLSearchParams(window.location.hash);
    urlParams = new URLSearchParams(
        Array.from(urlParams, ([key, value]) => [key.toLowerCase(), value])
    );
    return urlParams;
}

export const  doesUrlContainPath = (substring) => {
    const url = window.location.href;
    const urlObj = new URL(url);
    const lowerCaseSubstring = substring.toLowerCase();
    
    // Check if the string is present in either pathname or hash.
    // const isInPathname = urlObj.pathname.toLowerCase().includes(lowerCaseSubstring);
    const isInHash = urlObj.hash.toLowerCase().includes(lowerCaseSubstring);
    
    return isInHash;
}

export const handleWorkflowUpdates = (event, enhancedIafViewer) => {
    let action = event.target.value; if (!action) return;
    let uuid = action.split("/")[0];
    let updatedWorkflows = JSON.parse(JSON.stringify(enhancedIafViewer.state.workflow));

    const findItemByProperty = (items, propName, propValue) => {
        return items.find(item => String(item[propName]) === String(propValue));
    }

    let workflow = findItemByProperty(updatedWorkflows.list, 'uuid', updatedWorkflows.active);
    if (!workflow) return;;
    let script = findItemByProperty(workflow.script, 'uuid', uuid);
    if (!script) return;

    const updateStateWorkflows = (updatedWorkflows) => {
        if (JSON.stringify(enhancedIafViewer.state.workflow) === JSON.stringify(updatedWorkflows)) return;
        enhancedIafViewer.setState({workflow: updatedWorkflows});
    }

    const updateSpritePath = (uuid, path) => {
        if (!uuid) return;
        const script = findItemByProperty(workflow.script, 'uuid', uuid);
        if (!script || script.type !== "Sprite") return
        let lastFrame = script.frames[script.frames.length-1];
        lastFrame.image = path;
    }

    console.log ('PlatformReferenceApp.handleWorkflowUpdates', uuid);
    switch (action) {
        // -------------------------- WF4 actions ---------------------------------
        case 'wf-4.out-of-spec-tank-300.1/backLive':
            updateSpritePath('wf-4.reservior-return-tank-299.1', "/reference/invicara/sprites/p-n-id/Air_cooled_exchanger/Air_cooled_exchanger_On.gif");
            updateSpritePath('wf-4.out-of-spec-tank-300.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_on.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-297.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-257.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif");
            updateStateWorkflows(updatedWorkflows);
            break;

        case 'wf-4.reservior-return-tank-299.1/overflow':
            updateSpritePath('wf-4.reservior-return-tank-299.1', "/reference/invicara/sprites/p-n-id/Air_cooled_exchanger/Air_cooled_exchanger_Warning.gif");
            updateSpritePath('wf-4.out-of-spec-tank-300.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_off.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-297.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_warning.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-257.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_warning.gif");
            updateStateWorkflows(updatedWorkflows);
            break;

        case 'wf-4.translate.sludge.truck/delayed':
            if (script.type === "Translation") {
                let lastFrame = script.frames[script.frames.length-1];
                script.frames.push({x: lastFrame.x+200, y: 0, z: 0});  
                updateSpritePath('wf-4-sluge-holding-tanks-301.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_Warning.gif");
                updateStateWorkflows(updatedWorkflows);
            }          
            break;          

        case 'wf-4.translate.sludge.truck/onTime':
            if (script.type === "Translation") {
                script.frames.pop();  
                updateSpritePath('wf-4-sluge-holding-tanks-301.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_on.gif");
                updateStateWorkflows(updatedWorkflows);
            }          
            break;

        // -------------------------- WF3 actions ---------------------------------
        case 'wf-3.translate.sludge.truck.add.frame.302':
            if (script.type === "Translation") {
                let lastFrame = script.frames[script.frames.length-1];
                script.frames.push({x: lastFrame.x+200, y: 0, z: 0});  
                updateStateWorkflows(updatedWorkflows);
            }          
            break;
    }
}

export const handleWorkflowChange = (event, enhancedIafViewer) => {
    document.getElementById('dropdown-workflow-updates').selectedIndex = 0;

    let workflow = JSON.parse(JSON.stringify(enhancedIafViewer.state.workflow));
    let oldValue = enhancedIafViewer.state.workflow.active;
    workflow.active = event.target.value;
    enhancedIafViewer.setState({workflow}, () => {
        console.log ("PlatformReferenceApp.handleWorkflowChange", 'from', oldValue, 'to', enhancedIafViewer.state.workflow.active);
        enhancedIafViewer.setState({isDisabledDropdownWorkflowUpdates: false});    
    });
};

export const getSampleWorkflow = (project) => {

    let sampleWorkflow;

    switch(project._id) {

        case "9d675926-c139-4d1d-9f00-f17633116b65":
            // sampleWorkflow = w_9d675926_c139_4d1d_9f00_f17633116b65;
            break;

        case "54caf6e0-92ce-47cd-95cc-10cef9fa8015":
            sampleWorkflow = w_54caf6e0_92ce_47cd_95cc_10cef9fa8015;
            break;

        default:
            break;
    }

    console.log ('SampleWorkflows.getSampleWorkflow'
        , '/project', project
        , '/sampleWorkflow', sampleWorkflow
    );

    return sampleWorkflow;
}

export const workflowLayout = (pIdDemoEnabled, enhancedIafViewer) => {
    return pIdDemoEnabled &&
    (
      <div>
        <select
          id="dropdown-workflow"
          value={enhancedIafViewer.state.selectedOption}
          onChange={(event) => handleWorkflowChange(event, enhancedIafViewer)}
          style={{ position: 'absolute', 
                    top: '0px', 
                    left: '340px', 
                    zIndex: 20, 
                    width: '20%',
                    background: 'orange',
                    fontSize: '16px'
                  }}
        >
          <option value="">Select Workflow...</option>
          <option value="1">WF1</option>
          <option value="2">WF2</option>
          <option value="3">WF3</option>
          <option value="4">WF4</option>
          <option value="5">WF5</option>
        </select>
        <select
          id="dropdown-workflow-updates"
          disabled={enhancedIafViewer.state.isDisabledDropdownWorkflowUpdates}
          value={enhancedIafViewer.state.selectedOption}
          onChange={(event) => handleWorkflowUpdates(event, enhancedIafViewer)}
          style={{ position: 'absolute', 
                    top: '30px', 
                    left: '340px', 
                    zIndex: 20, 
                    width: '20%',
                    background: 'gray',
                    fontSize: '16px'
                  }}
        >
          <option value="">Select Workflow Updates...</option>
          <option value="wf-4.translate.sludge.truck/delayed">WF4 - Sludge Truck Delayed</option>
          <option value="wf-4.reservior-return-tank-299.1/overflow">WF4 - Reservoir Return Tank Overflow</option>
          <option value="wf-4.out-of-spec-tank-300.1/backLive">WF4 - Out of Spec Tank Back Live</option>
          <option value="wf-4.translate.sludge.truck/onTime">WF4 - Sludge Truck On Time</option>
          <option value="separator">--------------------------------</option>
          <option value="wf-3.translate.sludge.truck.add.frame.302">WF3 - Sludge Truck Taking More Time</option>
          <option value="None">None</option>
        </select>          
      </div>            
    )
  }