// LogDisplay.js
import React from 'react';

const LogDisplay = ({ logs, maxLogs = 1000, reverse = false }) => {
  // Reverse the logs if the reverse prop is true
  const displayLogs = reverse ? [...logs].reverse() : logs;

  // Limit the logs to the specified number of entries after reversing
  const limitedLogs = displayLogs.slice(0, maxLogs);

  return (
    <div className="log-container">
      <h3>Action Logs:</h3>
      <ul>
        {limitedLogs.map((log, index) => (
          <li key={index}>{log}</li>
        ))}
      </ul>
    </div>
  );
};

export default LogDisplay;
