// TimeComponent.js
import React, { useState, useEffect } from 'react';
import TimeDisplay from './timeDisplay';
import LogDisplay from './logDisplay';
import './timeComponent.css';

const TimeComponent = ({ timeMultiplier = 1, maxLogs = 1000, reverseLogs = true, event = "", onTimeUpdate=undefined }) => {
  const [logs, setLogs] = useState([]); // To store the logs
  const [formattedTime, setFormattedTime] = useState("8:00:00 AM");

  // Add log message to the array
  const addLog = (message) => {
    const formattedMessage = message + ", " + formattedTime;
    setLogs((prevLogs) => [...prevLogs, formattedMessage]); // Just append new logs
  };

  useEffect(() => {
    // addLog('TimeComponent initialized');

    return () => {
      addLog('Exiting logs');
    };
  }, []);

  useEffect(() => {
    addLog(event);
  }, [event]);

  return (
    <div className="time-container">
      <TimeDisplay timeMultiplier={timeMultiplier} onTimeUpdate={(newTime) => {
        const newFormattedTime = newTime.toLocaleTimeString('en-US', { hour: '2-digit', minute: '2-digit', second: '2-digit' });
        setFormattedTime(newFormattedTime)
        onTimeUpdate && onTimeUpdate(newTime);
        // addLog(`Time updated to: ${formattedTime}`);
      }} />
      <LogDisplay logs={logs} maxLogs={maxLogs} reverse={reverseLogs} /> {/* Pass reverse to LogDisplay */}
    </div>
  );
};

export default TimeComponent;
