// TimeDisplay.js
import React, { useState, useEffect, useRef } from 'react';

const TimeDisplay = ({ timeMultiplier = 1, onTimeUpdate }) => {
  // Initialize with today's date at 8:00 AM
  const initializeTime = () => {
    const now = new Date(); // Get today's date
    return new Date(now.getFullYear(), now.getMonth(), now.getDate(), 8, 0, 0); // Set time to 8:00 AM
  };

  const [currentTime, setCurrentTime] = useState(initializeTime()); // Start at today's 8:00 AM
  const currentTimeRef = useRef(currentTime); // Ref to hold the current time

  // Format the date and time together
  const formatDateTime = (time) => {
    const options = {
      weekday: 'short',
      year: 'numeric',
      month: 'short',
      day: 'numeric',
      hour: '2-digit',
      minute: '2-digit',
      second: '2-digit',
    };
    return time.toLocaleString('en-US', options); // Display both date and time
  };

  useEffect(() => {
    const updateTimeIntervalId = setInterval(() => {
      setCurrentTime((prevTime) => {
        const newTime = new Date(prevTime.getTime() + 1000 * timeMultiplier); // Increment time by multiplier
        currentTimeRef.current = newTime; // Update the ref to hold the latest time
        onTimeUpdate(newTime); // Notify parent component of time update
        return newTime;
      });
    }, 1000); // Update every second

    return () => {
      clearInterval(updateTimeIntervalId);
    };
  }, [timeMultiplier, onTimeUpdate]);

  return (
    <div className="time-display">
      <h2>{formatDateTime(currentTime)}</h2>
    </div>
  );
};

export default TimeDisplay;
