import React, { useCallback, useEffect, useState } from 'react';
import Select from 'react-select';
import Button from '@mui/material/Button';
import { getSampleWorkflow, sampleWorkflow } from './SampleWorkflows';
import "./WorkflowSearch.scss";
import TimeComponentStyledWithLogs from './TimeComponent/timeComponent.jsx';
import { handleWorkflowChange_54caf6e0_92ce_47cd_95cc_10cef9fa8015, handleWorkflowUpdates_54caf6e0_92ce_47cd_95cc_10cef9fa8015, updateOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015, workflowOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015 } from './jsons/w_54caf6e0_92ce_47cd_95cc_10cef9fa8015.js';
import { buildWorkflows_9d675926_c139_4d1d_9f00_f17633116b65, fetchWorfklowUpdates, getEvents_9d675926_c139_4d1d_9f00_f17633116b65, handleWorkflowChange_9d675926_c139_4d1d_9f00_f17633116b65, updateOptions_9d675926_c139_4d1d_9f00_f17633116b65, workflowOptions_9d675926_c139_4d1d_9f00_f17633116b65 } from './jsons/w_9d675926_c139_4d1d_9f00_f17633116b65.js';
import RandomReminder from './TimeComponent/randomReninder.js';
import { isEqual } from 'lodash';
import { logActiveWorkflow } from './jsons/utils.js';

const WorkflowComponent = (props) => {
    // const { workflow: initialWorkflow, onFetch: setWorkflow } = props;
    const [workflow, setWorkflow] = useState({...getSampleWorkflow(props.project)});
    const [selectedWorkflow, setSelectedWorkflow] = useState(null);
    const [selectedUpdate, setSelectedUpdate] = useState(null);
    const [event, setEvent] = useState("Initializing");

    const [workflowOptions, setWorkflowOptions] = useState([]);
    const [updateOptions, setUpdateOptions] = useState([]);
    const [workflowEvents, setWorkflowEvents] = useState([]);

    useEffect(() => {
        console.log ('WorkflowComponent.workflow update', workflow);
        props.onWorkflowUpdate && props.onWorkflowUpdate(workflow);
        logActiveWorkflow(workflow);
    }, [workflow])

    useEffect(() => {
        setEvent("Activating workflow, " +  workflow.active);
    }, [workflow.active])

    const handleReminder = useCallback((event) => {
        setWorkflow(prevWorkflow => {
            console.log('WorkflowComponent.handleReminder begin /workflow', prevWorkflow);
            if (!prevWorkflow.active) return prevWorkflow;
    
            setEvent("Event triggered: " + event.title);
            let newWorkflow = JSON.parse(JSON.stringify(prevWorkflow));
            event && event.action && event.action(newWorkflow);
    
            if (!isEqual(prevWorkflow, newWorkflow)) {
                return newWorkflow;
            }
            return prevWorkflow;
        });
    }, [event]);
    

    const handleWorkflowChange = (event) => {
        switch (props.project._id) {
            case "9d675926-c139-4d1d-9f00-f17633116b65":
                setWorkflowEvents([]);
                handleWorkflowChange_9d675926_c139_4d1d_9f00_f17633116b65(event, workflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent);
                setWorkflowEvents(getEvents_9d675926_c139_4d1d_9f00_f17633116b65(event.value));
                break;
    
            case "54caf6e0-92ce-47cd-95cc-10cef9fa8015":
                handleWorkflowChange_54caf6e0_92ce_47cd_95cc_10cef9fa8015(event, workflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent);
                break; 
                
            default:
                break;
        }        
    };
    const handleWorkflowUpdates = (event) => {
        switch (props.project._id) {
            case "9d675926-c139-4d1d-9f00-f17633116b65":
                break;
    
            case "54caf6e0-92ce-47cd-95cc-10cef9fa8015":
                handleWorkflowUpdates_54caf6e0_92ce_47cd_95cc_10cef9fa8015(event, workflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent);
                break; 
                
            default:
                break;
        }        
    };    

    useEffect(() => {
        switch (props.project._id) {
            case "9d675926-c139-4d1d-9f00-f17633116b65":
                setWorkflowOptions(workflowOptions_9d675926_c139_4d1d_9f00_f17633116b65);
                setWorkflow(buildWorkflows_9d675926_c139_4d1d_9f00_f17633116b65());
                // setUpdateOptions(updateOptions_9d675926_c139_4d1d_9f00_f17633116b65);
                // setWorkflowEvents(events_9d675926_c139_4d1d_9f00_f17633116b65);
                break;
    
            case "54caf6e0-92ce-47cd-95cc-10cef9fa8015":
                setWorkflowOptions(workflowOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015);
                setUpdateOptions(updateOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015);
                break; 
                
            default:
                break;
        }
    }, []);

    return (
        <div className="search-container">
            <h2 className="heading-primary">Search For</h2>
            <h3 className="heading-secondary">Workflows</h3>
            <label className="label" htmlFor="workflow-select">Select Workflow</label>
            <Select
                id="workflow-select"
                className="select"
                value={selectedWorkflow}
                onChange={handleWorkflowChange}
                options={workflowOptions}
                placeholder="Select a workflow..."
                isClearable
            />

            <label className="label" htmlFor="update-select">Select Workflow Updates</label>
            <Select
                id="update-select"
                className="select"
                value={selectedUpdate}
                onChange={handleWorkflowUpdates}
                options={updateOptions}
                placeholder="Select an update..."
                isDisabled={!selectedWorkflow}
                isClearable
            />

            <TimeComponentStyledWithLogs 
                timeMultiplier={390}
                event={event}
                // onTimeUpdate={(newTime)=> {
                //     fetchWorfklowUpdates(newTime, (update) => {
                //         // setEvent(update);
                //     })
                // }}
            >
            </TimeComponentStyledWithLogs>

            {workflowEvents.length > 0 && workflow.active && (
                <RandomReminder events={workflowEvents} onRemind={handleReminder} />
            )}
        </div>
    );
};

export default WorkflowComponent;
