
export const _rgbRandom = () => {
    var r = Math.floor(Math.random() * 256); // Random value between 0 and 255 for red
    var g = Math.floor(Math.random() * 256); // Random value between 0 and 255 for green
    var b = Math.floor(Math.random() * 256); // Random value between 0 and 255 for blue
    return {r, g, b};
}

const findItemByProperty = (items, propName, propValue) => {
    return items.find(item => String(item[propName]) === String(propValue));
}

export const findWorkflow = (workflows, uuid) => {
    return findItemByProperty(workflows.list, 'uuid', workflows.active);
}

export const findSciript = (workflow, uuid) => {
    return findItemByProperty(workflow.script, 'uuid', uuid);
}

export const removeScript = (workflow, uuid) => {
    workflow.script = workflow.script.filter(script => script.uuid !== uuid);
    return workflow;
}

export const removeScripts = (workflow, uuids) => {
    workflow.script = workflow.script.filter(script => !uuids.includes(script.uuid));
    return workflow;
}

export const updateStateWorkflows = (updatedWorkflows) => {
    if (JSON.stringify(workflow) === JSON.stringify(updatedWorkflows)) return;
    setWorkflow({...updatedWorkflows})
}

export const updateSpritePath = (workflow, uuid, path) => {
    if (!uuid) return;
    const script = findItemByProperty(workflow.script, 'uuid', uuid);
    if (!script || script.type !== "Sprite") return
    let lastFrame = script.frames[script.frames.length-1];
    lastFrame.image = path;
}

export const generateUniqueId = () => '_' + Math.random().toString(36).substr(2, 9);

export const logActiveWorkflow = (workflows) => {
    if (!workflows.active) return;
    const workflow = findWorkflow(workflows, workflows.active);
    console.log ('logActiveWorkflow', JSON.parse(JSON.stringify(workflow)));
  }
  
  