import { _rgbRandom } from "./utils";

export const workflowOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015 = [
    { label: 'WF1', value: '1' },
    { label: 'WF2', value: '2' },
    { label: 'WF3', value: '3' },
    { label: 'WF4', value: '4' },
    { label: 'WF5', value: '5' },
];

export const updateOptions_54caf6e0_92ce_47cd_95cc_10cef9fa8015 = [
    { label: 'WF4 - Sludge Truck Delayed', value: 'wf-4.translate.sludge.truck/delayed' },
    { label: 'WF4 - Reservoir Return Tank Overflow', value: 'wf-4.reservior-return-tank-299.1/overflow' },
    { label: 'WF4 - Out of Spec Tank Back Live', value: 'wf-4.out-of-spec-tank-300.1/backLive' },
    { label: 'WF4 - Sludge Truck On Time', value: 'wf-4.translate.sludge.truck/onTime' },
    { label: 'WF3 - Sludge Truck Taking More Time', value: 'wf-3.translate.sludge.truck.add.frame.302' },
    { label: 'None', value: null },
];

export const handleWorkflowUpdates_54caf6e0_92ce_47cd_95cc_10cef9fa8015 = (event, initialWorkflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent) => {
    // Handle null option to clear selected update
    if (!event) {
        setSelectedUpdate(null);
        return;
    }
    setSelectedUpdate(event);
    if (!event || !event.value) return;
    let action = event.value;
    let uuid = action.split("/")[0];
    let updatedWorkflows = JSON.parse(JSON.stringify(initialWorkflow));

    const findItemByProperty = (items, propName, propValue) => {
        return items.find(item => String(item[propName]) === String(propValue));
    }

    let workflow = findItemByProperty(updatedWorkflows.list, 'uuid', updatedWorkflows.active);
    if (!workflow) return;
    let script = findItemByProperty(workflow.script, 'uuid', uuid);
    if (!script) return;

    const updateStateWorkflows = (updatedWorkflows) => {
        if (JSON.stringify(workflow) === JSON.stringify(updatedWorkflows)) return;
        setWorkflow({...updatedWorkflows})
    }

    const updateSpritePath = (uuid, path) => {
        if (!uuid) return;
        const script = findItemByProperty(workflow.script, 'uuid', uuid);
        if (!script || script.type !== "Sprite") return
        let lastFrame = script.frames[script.frames.length-1];
        lastFrame.image = path;
    }

    console.log ('PlatformReferenceApp.handleWorkflowUpdates', uuid);
    switch (action) {
        // -------------------------- WF4 actions ---------------------------------
        case 'wf-4.out-of-spec-tank-300.1/backLive':
            setEvent("Out of Spect Tank is Back Live");
            updateSpritePath('wf-4.reservior-return-tank-299.1', "/reference/invicara/sprites/p-n-id/Air_cooled_exchanger/Air_cooled_exchanger_On.gif");
            updateSpritePath('wf-4.out-of-spec-tank-300.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_on.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-297.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-257.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif");
            updateStateWorkflows(updatedWorkflows);
            break;

        case 'wf-4.reservior-return-tank-299.1/overflow':
            setEvent("Reservoir Return Tank has overflown");
            updateSpritePath('wf-4.reservior-return-tank-299.1', "/reference/invicara/sprites/p-n-id/Air_cooled_exchanger/Air_cooled_exchanger_Warning.gif");
            updateSpritePath('wf-4.out-of-spec-tank-300.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_off.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-297.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_warning.gif");
            updateSpritePath('wf-4.durleigh-impounding-reservoir-257.1', "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_warning.gif");
            updateStateWorkflows(updatedWorkflows);
            break;

        case 'wf-4.translate.sludge.truck/delayed':
            setEvent("Sludge Truck has delayed due to diversion");
            if (script.type === "Translation") {
                let lastFrame = script.frames[script.frames.length-1];
                script.frames.push({x: lastFrame.x+200, y: 0, z: 0});  
                updateSpritePath('wf-4-sluge-holding-tanks-301.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_Warning.gif");
                updateStateWorkflows(updatedWorkflows);
            }          
            break;          

        case 'wf-4.translate.sludge.truck/onTime':
            setEvent("Sludge Truck is back in action");
            if (script.type === "Translation") {
                script.frames.pop();  
                updateSpritePath('wf-4-sluge-holding-tanks-301.1', "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_on.gif");
                updateStateWorkflows(updatedWorkflows);
            }          
            break;

        // -------------------------- WF3 actions ---------------------------------
        case 'wf-3.translate.sludge.truck.add.frame.302':
            setEvent("Sludge Truck has delayed due to diversion");
            if (script.type === "Translation") {
                let lastFrame = script.frames[script.frames.length-1];
                script.frames.push({x: lastFrame.x+200, y: 0, z: 0});  
                updateStateWorkflows(updatedWorkflows);
            }          
            break;
    }
}

export const handleWorkflowChange_54caf6e0_92ce_47cd_95cc_10cef9fa8015 = (event, initialWorkflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent) => {
    // Clear the selected update whenever the workflow changes
    setSelectedUpdate(null); // Clear second dropdown
    if (!event) {
        setSelectedWorkflow(null);
        return;
    }
    setSelectedWorkflow(event);
    if (!event || !event.value) return;
    document.getElementById('update-select').selectedIndex = 0;
    let workflow = JSON.parse(JSON.stringify(initialWorkflow));
    let oldValue = workflow.active;
    workflow.active = event.value;
    setWorkflow({...workflow}, ()=>{
        console.log ("PlatformReferenceApp.handleWorkflowChange", 'from', oldValue, 'to', workflow.active);
        setEvent("Activating workflow, " +  workflow.active);
    })
};

export const w_54caf6e0_92ce_47cd_95cc_10cef9fa8015 = {
    active: undefined
    , list: [
        {
            uuid: 5, 
            timeInSeconds: 4.5,
            loop: true,
            script: [                           
                {
                    uuid: "wf5._blockReferences.1",
                    elementIds: [ // _blockReferences
                        1, 4, 8, 13, 14, 19, 21, 25, 65, 66, 67, 68, 69, 70, 71, 72, 128, 131, 155, 156, 157, 158, 159, 160, 162, 163, 164, 165, 166, 173, 176, 213, 215, 223, 233
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2, interpolationType: "Constant"},
                        {opacity: 0.4, interpolationType: "Constant"}
                    ]
                },                               
                {
                    uuid: "wf5.leaderLines.1",
                    elementIds: [ // leaderLines
                        11, 17, 24, 27, 28, 31, 32, 34, 37, 38, 39, 40, 45, 47, 48, 53, 55, 56, 59, 61, 63, 74, 76, 78, 79, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 130, 134, 135, 136, 147, 151, 154, 177, 178, 179, 181, 185, 192, 196, 200, 203, 204, 205, 206, 207, 208, 212, 217, 218, 220, 224, 225
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.4}
                    ]
                },
                {
                    uuid: "wf5.mTexts.1",
                    elementIds: [ // mTexts
                        5, 7, 9, 10, 15, 16, 18, 20, 22, 23, 26, 36, 41, 42, 43, 44, 46, 50, 51, 52, 54, 57, 58, 60, 62, 64, 75, 77, 80, 81, 95, 97, 99, 122, 126, 127, 129, 132, 133, 195, 201, 219, 230, 231, 232, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2, interpolationType: "Linear"},
                        {opacity: 0.8, interpolationType: "Linear"}
                    ]
                },                
                {
                    uuid: "wf-5.translate.sludge.truck",
                    elementIds: [302],
                    type: "Translation",
                    frames: [
                        {x: 0, y: 0, z: 0, interpolationType: "CubicSpline"},
                        {x: 200, y: 0, z: 0, interpolationType: "CubicSpline"},
                        {x: 400, y: 0, z: 0, interpolationType: "CubicSpline"},
                        {x: 600, y: 0, z: 0, interpolationType: "CubicSpline"},
                        {x: 800, y: 0, z: 0, interpolationType: "ConCubicSplinestant"}
                    ],
                },
                {
                    uuid: "wf-5.markup.line.300",
                    elementIds: [300],
                    type: "Markup",
                    frames: [
                        {
                            type: "Line",
                            alignment: "Top",
                            status: "Error", 
                            blink: true    
                        }
                    ]
                },
                {
                    uuid: "wf-5.markup.line.300",
                    elementIds: [300],
                    type: "Markup",
                    frames: [
                        {
                            type: "Line",
                            alignment: "Bottom",
                            status: "Error", 
                            blink: true    
                        }
                    ]
                },
            ]              
        }, 
        {
        uuid: 4, 
        timeInSeconds: 4.5,
        loop: true,
        script: [
            // {
            //     uuid: "Mixer.298",
            //     elementIds: [298],
            //     type: "Rotation",
            //     frames: Array.from({length: 6}, (_, i) => ({x: 0, y: 0, z: (i + 1) * 60}))
            // },
            {
                uuid: 'WaterSoftnerTank.293.1.Sprite',
                elementIds: [293],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Water_Softener_Tank/Water_Softener_Tank.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },
            {
                uuid: 'WaterSoftnerTank.293.1.Sprite',
                elementIds: [293],
                type: "Opacity",
                frames: [
                    {opacity: 0.5}
                ]
            },                
            {
                uuid: 'WaterSoftnerTank.293.1.Text',
                elementIds: [293],
                type: "Markup",
                frames: [
                {
                    type: "Text",
                    status: "Success", 
                    text: "Ions of calcium,magnesium and iron\nare removed and is available", 
                    blink: true,
                    alignment: "LowerCenter",
                    strokeColor: {r: 104, g: 188, b: 0},
                    fillColor: {r: 115, g: 216, b: 255},
                    fillOpacity: 0.01,
                    shiftPercent: {x: -5, y: -15, z: 0}
                },
                ]
            }, 
            {
                uuid: 'ServiceWaterTank.288.1.Sprite',
                elementIds: [288],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },       
            {
                uuid: 'UvPlant.292.1.Sprite',
                elementIds: [292],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },     
            {
                uuid: 'DafsRecycleTank.267.1.Sprite',
                elementIds: [267],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                            
            {
                uuid: 'PrimaryRgfs.269.1.Sprite',
                elementIds: [269],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },   
            {
                uuid: 'PressureContactors.282.1.Status',
                elementIds: [282],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                                                
            {
                uuid: 'GacAbsorbers.283.1.Status',
                elementIds: [283],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                                                                
            {
                uuid: 'CleanBackwashTank.284.1.Sprite',
                elementIds: [284],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Warning_Triangle.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },   
            {
                uuid: 'CleanBackwashTank.286.1.Sprite',
                elementIds: [286],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Error_Cross.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                                                                                
            {
                uuid: 'ServiceWaterTank.295.1.Sprite',
                elementIds: [295],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1.2,
                        image: "/reference/invicara/sprites/p-n-id/Service_Water_Tank/Service_Water_Tank.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },
            {
                uuid: 'ServiceWaterTank.295.1.Sprite',
                elementIds: [295],
                type: "Opacity",
                frames: [
                    {opacity: 0.5}
                ]
            },                
            {
                uuid: 'ServiceWaterTank.295.1.Sprite',
                elementIds: [295],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "LowerCenter",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },         
            {
                uuid: 'WaterReservoir.296.1.Sprite',
                elementIds: [296],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Water_Reservoir/Water_Reservoir.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                  
            {
                uuid: 'WaterReservoir.296.1.Status',
                elementIds: [296],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1,
                        image: "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif",
                        alignment: "LowerCenter",
                        autoScale: true,
                        blend: 0.8
                    }
                ]
            },                                                
            {
                uuid: "Mixer.298.Color",
                elementIds: [298],
                type: "Color",
                frames: [
                {r: 0, g: 10, b: 0},
                {r: 0, g: 50, b: 0},
                {r: 0, g: 100, b: 0},
                {r: 0, g: 150, b: 0},
                {r: 0, g: 200, b: 0},
                {r: 0, g: 255, b: 0},
                ],
            },                
            {
                uuid: "Mixer.298.Translation",
                elementIds: [298],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                    {x: -5, y: 0, z: 0, interpolationType: "Constant"}
                ],
            },
            {
                uuid: "Mixer.262",
                elementIds: [262],
                type: "Rotation",
                frames: Array.from({length: 6}, (_, i) => ({x: 0, y: 0, z: (i + 1) * 60}))
            },
            {
                uuid: "Mixer.263",
                elementIds: [263],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                    {x: -5, y: 0, z: 0, interpolationType: "Constant"}
                ],                                
            },
            {
                uuid: "Mixer.268",
                elementIds: [268],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                    {x: -5, y: 0, z: 0, interpolationType: "Constant"}
                ],
            },
            {
                uuid: "Mixer.270.Rotation",
                elementIds: [270],
                type: "Rotation",
                frames: Array.from({length: 6}, (_, i) => ({x: 0, y: 0, z: (i + 1) * 60}))
            },
            {
                uuid: "Mixer.271.Translation",
                elementIds: [271],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                    {x: -5, y: 0, z: 0, interpolationType: "Constant"}
                ],                
            },
            {
                uuid: "Mixer.287.Scale",
                elementIds: [287],
                type: "Scale",
                frames: [
                    {x: 1, y: 1, z: 1},
                    {x: 1.5, y: 1.5, z: 1.5}
                ],
            },
            {
                uuid: "Mixer.289.Rotation",
                elementIds: [289],
                type: "Rotation",
                frames: Array.from({length: 6}, (_, i) => ({x: 0, y: 0, z: (i + 1) * 60}))
            },
            {
                uuid: "Mixer.290.Translation",
                elementIds: [290],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                    {x: -5, y: 0, z: 0, interpolationType: "Constant"}
                ],                
            },                
            {
                uuid: 272.1,
                elementIds: [272],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },
            {
                uuid: 273.1,
                elementIds: [273],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },
            {
                uuid: 274.1,
                elementIds: [274],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },
            {
                uuid: 275.1,
                elementIds: [275],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },         
            {
                uuid: 276.1,
                elementIds: [276],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },                                                       
            {
                uuid: 278.1,
                elementIds: [278],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },                         
            {
                uuid: 279.1,
                elementIds: [279],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },              
            {
                uuid: 280.1,
                elementIds: [280],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },  
            {
                uuid: 277.1,
                elementIds: [277],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.7,
                        image: "/reference/invicara/sprites/p-n-id/Pump/Flexible_impeller_pump.gif",
                        alignment: "Center",
                        autoScale: true,
                        blend: 0.1
                    }
                ]
            },                                    
            {
                uuid: "leaderLines.11",
                elementIds: [ // leaderLines
                    11, 17, 24, 27, 28, 31, 32, 34, 37, 38, 39, 40, 45, 47, 48, 53, 55, 56, 59, 61, 63, 74, 76, 78, 79, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 130, 134, 135, 136, 147, 151, 154, 177, 178, 179, 181, 185, 192, 196, 200, 203, 204, 205, 206, 207, 208, 212, 217, 218, 220, 224, 225
                ],
                type: "Opacity",
                frames: [
                    {opacity: 0.5}
                ]
            },
            {
                uuid: 28,
                elementIds: [ // mTexts
                    5, 7, 9, 10, 15, 16, 18, 20, 22, 23, 26, 36, 41, 42, 43, 44, 46, 50, 51, 52, 54, 57, 58, 60, 62, 64, 75, 77, 80, 81, 95, 97, 99, 122, 126, 127, 129, 132, 133, 195, 201, 219, 230, 231, 232, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256
                ],
                type: "Opacity",
                frames: [
                    {opacity: 0.4}
                ]
            },
            {
                uuid: "lines.29",
                elementIds: [ // lines
                    29, 33, 35, 49, 73, 113, 114, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 148, 149, 150, 152, 153, 161, 167, 168, 169, 170, 171, 172, 174, 175, 180, 182, 183, 184, 186, 187, 188, 189, 190, 191, 193, 194, 197, 198, 199, 202, 209, 210, 211, 214, 216, 221, 222, 226, 264, 265, 266, 281, 285, 291, 294
                ],
                type: "Opacity",
                frames: [
                    {opacity: 0.4}
                ]
            },
            {
                uuid: "polylines.91",
                elementIds: [ // polylines
                    91, 93, 94, 96, 98, 100, 101, 102, 105, 106, 107, 109, 110, 112, 116, 117, 119, 120, 121, 228, 229, 234
                ],
                type: "Opacity",
                frames: [
                    {opacity: 0.4}
                ]
            },
            {
                uuid: "_blockReferences.1",
                elementIds: [ // _blockReferences
                    1, 4, 8, 13, 14, 19, 21, 25, 65, 66, 67, 68, 69, 70, 71, 72, 128, 131, 155, 156, 157, 158, 159, 160, 162, 163, 164, 165, 166, 173, 176, 213, 215, 223, 233
                ],
                type: "Opacity",
                frames: [
                    {opacity: 0.2},
                    {opacity: 0.4}
                ]
            },
            {
            uuid: "wf-4.translate.sludge.truck",
            elementIds: [302],
            type: "Translation",
            frames: [
                {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                {x: 200, y: 0, z: 0, interpolationType: "Constant"}
            ],
            },              
            // {
            //     uuid: 286.1,
            //     elementIds: [286],
            //     type: "Sprite",
            //     frames: [
            //         {
            //             type: "Gif",
            //             size: 0.7,
            //             image: "/reference/invicara/sprites/p-n-id/Boiler/Boiler_on.gif",
            //             alignment: "Center",
            //             autoScale: true,
            //             blend: 0.1
            //         }
            //     ]
            //   },
            // {
            //   uuid: 286.2,
            //   elementIds: [286],
            //   type: "Visibility",
            //   frames: [
            //       false
            //   ]
            // },
            // {
            //   uuid: 286.3,
            //   elementIds: [286],
            //   type: "Markup",
            //   frames: [
            //     {
            //       type: "LeaderNote",
            //       status: "Success", 
            //       text: "Clean Backwash Tank\n for GAC Absorbers", 
            //       blink: true,
            //       alignment: "Center",
            //       shiftPercent: 15
            //     },
            //   ]
            // }, 
            {
                uuid: 'wf-4.reservior-return-tank-299.1',
                elementIds: [299],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Air_cooled_exchanger/Air_cooled_exchanger_On.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },       
            // {
            //   uuid: 299.2,
            //   elementIds: [299],
            //   type: "Markup",
            //   frames: [
            //     {
            //       type: "LeaderNote",
            //       status: "Warning", 
            //       text: "Reservior Return Tank is overflowing", 
            //       blink: true,
            //       alignment: "Center",
            //       shiftPercent: 15
            //     },
            //   ]
            // },                               
            {
                uuid: 'wf-4.out-of-spec-tank-300.1',
                elementIds: [300],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_Warning.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },        
            {
                uuid: 300.2,
                elementIds: [300],
                type: "Markup",
                frames: [
                {
                    type: "LeaderNote",
                    status: "Warning", 
                    text: "Out of Specification Tank is turned Off", 
                    blink: true,
                    alignment: "Center",
                    shiftPercent: {x: 15, y: 0, z: 0}
                },
                ]
            },         
            {
                uuid: 305.1,
                elementIds: [305],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Condenser/Condenser_On.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },        
            // {
            //   uuid: 305.2,
            //   elementIds: [305],
            //   type: "Markup",
            //   frames: [
            //     {
            //       type: "LeaderNote",
            //       status: "Success", 
            //       text: "Waste Tank", 
            //       blink: true,
            //       alignment: "Center",
            //     },
            //   ]
            // },         
            {
                uuid: 'wf-4-sluge-holding-tanks-301.1',
                elementIds: [301],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/U_tube_Heat_Exchanger/U_tube_Heat_Exchanger_on.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            }, 
            {
                uuid: 304.1,
                elementIds: [304],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Evaporative_condenser/Evaporative_condenser_On.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },                                                                                                       
            {
                uuid: 303.1,
                elementIds: [303],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Heater/Heater_On.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },   
            {
                uuid: 'wf-4.durleigh-impounding-reservoir-297.1',
                elementIds: [297],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },      
            {
                uuid: 'wf-4.durleigh-impounding-reservoir-257.1',
                elementIds: [257],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Reboiler/Reboiler_on.gif",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },                         
            // {
            //   uuid: 306.1,
            //   elementIds: [306],
            //   type: "Sprite",
            //   frames: [
            //       {
            //           type: "Gif",
            //           size: 0.8,
            //           image: "/reference/invicara/sprites/p-n-id/Hairpin_exchanger/Hairpin_exchanger_On.gif",
            //           alignment: "Center",
            //           blend: 0.1,
            //           autoScale: true    
            //       }
            //   ]
            // },            
            {
                uuid: 306.1,
                elementIds: [306],
                type: "Sprite",
                frames: [
                    {
                        type: "Static",
                        size: 0.8,
                        image: "/reference/invicara/sprites/p-n-id/Dirty_Water/Dirty_Water_Industry.png",
                        alignment: "Center",
                        blend: 0.1,
                        autoScale: true    
                    }
                ]
            },                                                                                                                                                   
            ]
        },          
        {
            uuid: 3, 
            timeInSeconds: 4.5,
            loop: true,
            script: [
            {
                uuid: 'wf-3.markup.circle.305',
                elementIds: [305],
                type: "Markup",
                frames: [
                    {
                        type: "Circle",
                        status: "Error", 
                        blink: true,
                        scale: 1.2    
                    }
                ]
            },
            {
                uuid: 'wf-3.translate.sludge.truck.add.frame.302',
                elementIds: [302],
                type: "Translation",
                frames: [
                    {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    {x: 200, y: 0, z: 0, interpolationType: "Constant"}
                ],
            },
            {
                uuid: '65',
                elementIds: [302],
                type: "Sprite",
                frames: [
                    {
                        type: "Static",
                        size: 1, 
                        // image: "./digitaltwin/invicara/sprites/location.png",
                        image: "/reference/invicara/sprites/location.png",
                        blink: true,
                        alignment: "Center",
                        autoScale: true
                    }
                ]
            }, 
            {
                uuid: 66,
                elementIds: [288],
                type: "Sprite",
                frames: [
                    {
                        type: "Gif",
                        size: 1, 
                        // image: "./digitaltwin/invicara/sprites/main_comp_boiler.gif",
                        image: "/reference/invicara/sprites/main_comp_boiler.gif",
                        alignment: "Center",
                        autoScale: true
                    }
                ]
            }, 
            ],
        },        
        {
            uuid: 2, 
            timeInSeconds: 4.5,
            loop: true,
            script: [
            {
                uuid: 21,
                elementIds: [303],
                type: "Markup",
                frames: [
                    {
                        type: "LeaderNote",
                        status: "Warning", 
                        text: "Unexpected rise in temperature", 
                        blink: true    
                    }
                ]
            },                              
            ]
        },
        {
            uuid: 1, 
            timeInSeconds: 4.5,
            loop: true,
            script: [
                {
                    uuid: 11,
                    elementIds: [286],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 1,
                            // image: "/digitaltwin/invicara/sprites/re-fan.gif",
                            image: "/reference/invicara/sprites/re-fan.gif",
                            alignment: "Center",
                            autoScale: true    
                        }
                    ]
                },
                {
                    uuid: 12,
                    elementIds: [272],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 0.3,
                            // image: "./digitaltwin/invicara/sprites/re-pumping-station.gif",
                            image: "/reference/invicara/sprites/re-pumping-station.gif",
                            alignment: "Center",
                            autoScale: true
                        }
                    ]                        
                },
                {
                    uuid: 13,
                    elementIds: [282],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 1.3,
                            // image: "./digitaltwin/invicara/sprites/re-pumping-station.gif",
                            image: "/reference/invicara/sprites/re-pressure-contactor.gif",
                            alignment: "Center",
                            autoScale: true,
                            blend: 0.3
                        }
                    ]                        
                },                    
                {
                    uuid: 14,
                    elementIds: [299],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 0.6,
                            // image: "./digitaltwin/invicara/sprites/re-pumping-station.gif",
                            image: "/reference/invicara/sprites/re-reservoir-tank.gif",
                            alignment: "Center",
                            blend: .5,
                            autoScale: true
                        }
                    ]                        
                },                    
                {
                    uuid: 15,
                    elementIds: [271],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 0.4,
                            // image: "./digitaltwin/invicara/sprites/re-pumping-station.gif",
                            image: "/reference/invicara/sprites/static-mixer.gif",
                            alignment: "Center",
                            autoScale: true
                        }
                    ]                        
                },                    
                {
                    uuid: 65,
                    elementIds: [293],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Static",
                            size: 1, 
                            // image: "./digitaltwin/invicara/sprites/location.png",
                            image: "/reference/invicara/sprites/location.png",
                            blink: true,
                            alignment: "Center",
                            autoScale: false
                        }
                    ]
                },   
                {
                    uuid: 16,
                    elementIds: [295],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Static",
                            size: 1, 
                            // image: "./digitaltwin/invicara/sprites/location.png",
                            image: "/reference/invicara/sprites/location.png",
                            blink: true,
                            alignment: "Center",
                            autoScale: true
                        }
                    ]
                },                                         
                {
                    uuid: 17,
                    elementIds: [293],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.5}
                    ]
                },
                {
                    uuid: 18,
                    elementIds: [284],
                    type: "Sprite",
                    frames: [
                        {
                            type: "Gif",
                            size: 0.6,
                            // image: "./digitaltwin/invicara/sprites/re-exclaimation.gif",
                            image: "/reference/invicara/sprites/re-exclaimation.gif",
                            alignment: "Center",
                            autoScale: true
                        }
                    ]                        
                },
                {
                    uuid: 19,
                    elementIds: [286],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.5}
                    ]
                },
                {
                    uuid: 20,
                    elementIds: [299],
                    type: "Color",
                    frames: [
                        _rgbRandom(),
                        _rgbRandom(),
                        _rgbRandom(),
                        _rgbRandom(),
                        _rgbRandom()
                    ],
                },
                {
                    uuid: 21,
                    elementIds: [298],
                    type: "Rotation",
                    frames: Array.from({length: 36}, (_, i) => ({x: 0, y: 0, z: (i + 1) * 60}))
                },
                {
                    uuid: 22,
                    elementIds: [302],
                    type: "Translation",
                    frames: [
                        {x: 0, y: 0, z: 0},
                        {x: 300, y: 0, z: 0}
                    ],
                },
                {
                    uuid: 23,
                    elementIds: [304],
                    type: "Translation",
                    frames: [
                        {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                        {x: 5, y: 0, z: 0, interpolationType: "Constant"},
                        {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                        {x: -5, y: 0, z: 0, interpolationType: "Constant"},
                        {x: 0, y: 0, z: 0, interpolationType: "Constant"},
                    ],
                },
                // {
                //     elementIds: [303],
                //     type: "Markup",
                //     frames: [
                //         {
                //             type: "LeaderNote",
                //             status: "Warning", 
                //             text: "Unexpected rise in temperature", 
                //             blink: true    
                //         }
                //     ]
                // },
                {
                    uuid: 24,
                    elementIds: [303],
                    type: "Scale",
                    frames: [
                        {x: 1, y: 1, z: 1},
                        {x: 1.5, y: 1.5, z: 1.5}
                    ],
                },
                {
                    uuid: 25,
                    elementIds: [300],
                    type: "Markup",
                    frames: [
                        {
                            type: "Cross",
                            status: "Error", 
                            blink: true    
                        }
                    ]
                },
                {
                    uuid: 26,
                    elementIds: [305],
                    type: "Markup",
                    frames: [
                        {
                            type: "Rectangle",
                            status: "Error", 
                            blink: true    
                        }
                    ]
                },
                {
                    uuid: 27,
                    elementIds: [ // leaderLines
                        11, 17, 24, 27, 28, 31, 32, 34, 37, 38, 39, 40, 45, 47, 48, 53, 55, 56, 59, 61, 63, 74, 76, 78, 79, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 124, 125, 130, 134, 135, 136, 147, 151, 154, 177, 178, 179, 181, 185, 192, 196, 200, 203, 204, 205, 206, 207, 208, 212, 217, 218, 220, 224, 225
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.4}
                    ]
                },
                {
                    uuid: 28,
                    elementIds: [ // mTexts
                        5, 7, 9, 10, 15, 16, 18, 20, 22, 23, 26, 36, 41, 42, 43, 44, 46, 50, 51, 52, 54, 57, 58, 60, 62, 64, 75, 77, 80, 81, 95, 97, 99, 122, 126, 127, 129, 132, 133, 195, 201, 219, 230, 231, 232, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2},
                        {opacity: 0.4}
                    ]
                },
                {
                    uuid: 29,
                    elementIds: [ // lines
                        29, 33, 35, 49, 73, 113, 114, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 148, 149, 150, 152, 153, 161, 167, 168, 169, 170, 171, 172, 174, 175, 180, 182, 183, 184, 186, 187, 188, 189, 190, 191, 193, 194, 197, 198, 199, 202, 209, 210, 211, 214, 216, 221, 222, 226, 264, 265, 266, 281, 285, 291, 294
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2},
                        {opacity: 0.4}
                    ]
                },
                {
                    uuid: 30,
                    elementIds: [ // polylines
                        91, 93, 94, 96, 98, 100, 101, 102, 105, 106, 107, 109, 110, 112, 116, 117, 119, 120, 121, 228, 229, 234
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2},
                        {opacity: 0.4}
                    ]
                },
                {
                    uuid: 31,
                    elementIds: [ // _blockReferences
                        1, 4, 8, 13, 14, 19, 21, 25, 65, 66, 67, 68, 69, 70, 71, 72, 128, 131, 155, 156, 157, 158, 159, 160, 162, 163, 164, 165, 166, 173, 176, 213, 215, 223, 233
                    ],
                    type: "Opacity",
                    frames: [
                        {opacity: 0.2},
                        {opacity: 0.4}
                    ]
                }
            ]
        }
    ]
}
