import { frequencyMap } from "../TimeComponent/randomReninder";
import { findWorkflow, generateUniqueId, removeScript, removeScripts } from "./utils";

// Step 1: Define the enumeration
export const WorkflowOptions = {
  EQUIPMENT_STATUS: 'Equipment Status',
  EQUIPMENT_ACTIONS: 'Equipment Actions',
  PRE_TREATMENT: 'Pre-Treatment',
  FILTRATION: 'Filtration',
  REVERSE_OSMOSIS: 'Reverse Osmosis (RO)',
  STORAGE_DISTRIBUTION: 'Storage and Distribution Block',
  SLUDGE_MANAGEMENT: 'Sludge Management',
};

// Step 2: Update the array to use the enumeration
export const workflowOptions_9d675926_c139_4d1d_9f00_f17633116b65 = [
  { label: 'Equipment Status', value: WorkflowOptions.EQUIPMENT_STATUS },
  { label: 'Equipment Actions', value: WorkflowOptions.EQUIPMENT_ACTIONS },
  // { label: 'Pre-Treatment', value: WorkflowOptions.PRE_TREATMENT },
  // { label: 'Filtration', value: WorkflowOptions.FILTRATION },
  // { label: 'Reverse Osmosis (RO)', value: WorkflowOptions.REVERSE_OSMOSIS },
  // { label: 'Storage and Distribution Block', value: WorkflowOptions.STORAGE_DISTRIBUTION },
  // { label: 'Sludge Management', value: WorkflowOptions.SLUDGE_MANAGEMENT },
];

export const updateOptions_9d675926_c139_4d1d_9f00_f17633116b65 = [
  { label: 'None', value: null },
];

const STATUS_SUCCESS = "/reference/invicara/sprites/p-n-id/Status/Success_Tick.gif";
const STATUS_WARNING = "/reference/invicara/sprites/p-n-id/Alert_energy/Alert_energy_Warnings.gif";
const STATUS_ERROR = "/reference/invicara/sprites/p-n-id/Alert_energy/Alert_energy_Off.gif";

const ALERT_WATER_ON = "/reference/invicara/sprites/p-n-id/Alert_water/Alert_water_On.gif";
const ALERT_WATER_OFF = "/reference/invicara/sprites/p-n-id/Alert_water/Alert_water_Off.gif";

const MEMBRANE_RO_UNITS_WHITE = "/reference/invicara/sprites/p-n-id/Membranes_RO Units/Membranes_RO Units_white_on.gif"
const MEMBRANE_RO_UNITS_BLACK = "/reference/invicara/sprites/p-n-id/Membranes_RO Units/Membranes_RO Units_black_On.gif"

const ACTIONS_PUMP = "/reference/invicara/sprites/p-n-id/Pump/Pump_black_On.gif";
const ACTIONS_PUMP_ERROR = "/reference/invicara/sprites/p-n-id/Pump/Pump_black_Off.gif";
const ACTIONS_FILTER = "/reference/invicara/sprites/p-n-id/Membranes_RO Units/Membranes_RO Units_black_On.gif";
const ACTIONS_FILLING_TANK = "/reference/invicara/sprites/p-n-id/Tank/Tank_black_warning.gif";
const ACTIONS_STORAGE_TANK = "/reference/invicara/sprites/p-n-id/Water_Reservoir/Water_Reservoir.gif";
const ACTIONS_ARROW_RIGHT_SUCCESS = "/reference/invicara/sprites/p-n-id/Flow_Arrow-pointing-right/Flow_Arrow-pointing-right_black_On.gif";
const ACTIONS_ARROW_LEFT_SUCCESS = "/reference/invicara/sprites/p-n-id/Flow_Arrow-pointing-left/Flow_Arrow-pointing-left_black_On.gif";
const ACTIONS_ARROW_RIGHT_ERROR = "/reference/invicara/sprites/p-n-id/Flow_Arrow-pointing-right/Flow_Arrow-pointing-right_black_Off.gif";
const ACTIONS_ARROW_LEFT_ERROR = "/reference/invicara/sprites/p-n-id/Flow_Arrow-pointing-left/Flow_Arrow-pointing-left_black_Off.gif";

const statuses = {
  tanks: [
    324, // Flash Mixer Tank and Flocculator Tank
    330, // Settling Tank
    337, // Filter Feed Tank
    338, // Inlet from Rinse Effluent Tank
    355, // Chemical Cleaning Tank
    419, // To Common RO Feed Tank
    420, // From Common RO Feed Tank
    421, // RO Stage 2 Reject Tank
    422, // High Concentrated Effluent Collection Tank
    423, // Deionized Water (DM Water) Storage Tank
    424, // Deionized Water (DM Water) Storage Tank
    435, // EDI Feed Tank
    437, // Acid Dosing Tank
    438, // Alkali Dosing Tank
  ],
  filters: [
    350, // PSF: Pressure Sand Filter
    352, // ACF: Activated Carbon Filter
  ],
  pumps: [
    347, 348, // Filtrate Feed Tank Pump
    370, 371, // ROFP (Reverse Osmosis Feed Pump) Stage 1 Feed
    417, 418, // ROFP (Reverse Osmosis Feed Pump) Stage 1 Permeate
    426, 434, // Electrodeionization Feed Pump
    454, 455. //
  ],
  others: [
    294,
    332, 333,
    339, 345, 346,
    356, //
    357, // RO Stage 2
    364, 366, 367, 368, 369, 381,
    411, 413, 414, 415, 416,
    425,
    436, // Mixed Bed Deionisers
    456, 457,
    458 // Degaser, Airblower
  ]
}

const actions = {
  feedTanks: [
    337, // Filter Feed Tank
    435, // EDI Feed Tank
  ],
  
  directionToRight: [
    423, // Deionized Water (DM Water) Storage Tank
    420, // From Common RO Feed Tank
    338, // Inlet from Rinse Effluent Tank
    436, // Mixed Bed Deionisers
    451, // Mixed Bed Deioniser
    458, // Degaser, Airblower
    456, // RO Permeate Tank
    350, // PSF: Pressure Sand Filter
    352, // ACF: Activated Carbon Filter
  ],

  directionToLeft: [
    424, // Deionized Water (DM Water) Storage Tank
    419, // To Common RO Feed Tank
    421, // RO Stage 2 Reject Tank
    422, // High Concentrated Effluent Collection Tank
  ],

  fillingTanks: [
    330, // Settling Tank
  ],
  
  tanks: [
    324, // Flash Mixer Tank and Flocculator Tank
    355, // Chemical Cleaning Tank
    437, // Acid Dosing Tank
    438, // Alkali Dosing Tank
  ],

  pumps: [
    347, 348, // Filtrate Feed Tank Pump
    370, 371, // ROFP (Reverse Osmosis Feed Pump) Stage 1 Feed
    417, 418, // ROFP (Reverse Osmosis Feed Pump) Stage 1 Permeate
    426, 434, // Electrodeionization Feed Pump
    454, 455. //
  ],

  others: [
    294,
    332, 333,
    339, 345, 346,
    356, //
    357, // RO Stage 2
    364, 366, 367, 368, 369, 381,
    411, 413, 414, 415, 416,
    425,
    457,
  ],

}

export const buildWorkflows_9d675926_c139_4d1d_9f00_f17633116b65 = () => {
  let workflows = {
    active: undefined,
    list: [

    ]
  };  
  workflowOptions_9d675926_c139_4d1d_9f00_f17633116b65.forEach((workflowOption) => {
    workflows.list.push(
      {
        uuid: workflowOption.value,
        timeInSeconds: 4.5,
        loop: true,
        script: [
          ...generateScriptsVisibility()
          // ...generateScriptsStatus() // Spread the dynamically generated scripts
        ]
      }
    )
  })

  return workflows;
}

export const getEvents_9d675926_c139_4d1d_9f00_f17633116b65 = (workflowId) => {
  let events = [];
  switch (workflowId) {
    case WorkflowOptions.EQUIPMENT_STATUS:
      events = [..._EQUIPMENT_STATUS];
      break;

    case WorkflowOptions.EQUIPMENT_ACTIONS:
      events = [..._EQUIPMENT_ACTIONS];
      break;

    default:
      break;
  }

  return events;
}

export const _EQUIPMENT_STATUS =  [
  {
    id: generateUniqueId(),
    title: "A global restart of all equipments in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all equipments in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS
      && generateScriptsStatus(workflows, [
        ...statuses.tanks,
        ...statuses.pumps,
        ...statuses.filters,
        ...statuses.others
      ], {image: STATUS_SUCCESS});
    },
    frequency: "single"
  },
  {
    id: generateUniqueId(),
    title: "Sludge build up has been accumulated at the bottom of the Settling Tank, reducing the tank's effective volum - 330",
    action: (workflows) => {
      console.log("Sludge build up has been accumulated at the bottom of the Settling Tank, reducing the tank's effective volume")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS
      && generateScriptsStatus(workflows, [330], {
        image: STATUS_WARNING,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },
  {
    id: generateUniqueId(),
    title: "Settling Tank is overloaded with either water or solids, its capacity to settle particles is diminished - 330",
    action: (workflows) => {
      console.log("Settling Tank is overloaded with either water or solids, its capacity to settle particles is diminished")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [330], {
        image: STATUS_ERROR,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },
  {
    id: generateUniqueId(),
    title: "Inconsistent Water Supply to EDI - fluctuations due to inconsistent feed rates from the upstream processes - 435",
    action: (workflows) => {
      console.log("Inconsistent Water Supply to EDI - fluctuations due to inconsistent feed rates from the upstream processes - 435")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [435], {
        image: STATUS_ERROR,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },  
  {
    id: generateUniqueId(),
    title: "Contamination in the Tank EDI - Accumulation of biofilm, scaling, or particulate matter - 435",
    action: (workflows) => {
      console.log("Inconsistent Water Supply to EDI - fluctuations due to inconsistent feed rates from the upstream processes - 435")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [435], {
        image: STATUS_ERROR,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },
  {
    id: generateUniqueId(),
    title: "Desgaser - Inefficient Gas Removal (CO₂ or Other Gases) - 458",
    action: (workflows) => {
      console.log("Desgaser - Inefficient Gas Removal (CO₂ or Other Gases) - 458")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [458], {
        image: STATUS_WARNING,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },  
  {
    id: generateUniqueId(),
    title: "Desgaser - Corrositon of Degasser Components - 458",
    action: (workflows) => {
      console.log("Desgaser - Corrositon of Degasser Components - 458")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [458], {
        image: STATUS_WARNING,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },    
  {
    id: generateUniqueId(),
    title: "Air Blower or Fan Failure - 458",
    action: (workflows) => {
      console.log("Air Blower or Fan Failure - 458")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [458], {
        image: STATUS_ERROR,
        alignment: "Center",
        size: 1
      });
    },
    frequency: "medium"
  },      
  {
    id: generateUniqueId(),
    title: "Air Blower or Fan Failure is up and running - 458",
    action: (workflows) => {
      console.log("Air Blower or Fan Failure is up and running - 458")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [458], {image: STATUS_SUCCESS});
    },
    frequency: "low"
  },  
  {
    id: generateUniqueId(),
    title: "resolved through a combination of regular maintenance, cleaning protocols, and operational adjustments - 435",
    action: (workflows) => {
      console.log("resolved through a combination of regular maintenance, cleaning protocols, and operational adjustments - 435")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_STATUS && generateScriptsStatus(workflows, [435], {image: STATUS_SUCCESS});
    },
    frequency: "low"
  },  
];

export const _EQUIPMENT_ACTIONS =  [
  {
    // Power Status Single
    id: generateUniqueId(),
    title: "A global restart of all equipments in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all equipments in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsStatus(workflows, [
        ...actions.tanks,
        // ...pumps,
        // ...filters,
        ...actions.others
      ], {image: STATUS_SUCCESS});
    },
    frequency: "single"
  },

  // Running Pumps Single
  {
    id: generateUniqueId(),
    title: "A global restart of all pumps in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all pumps in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        ...actions.pumps,
      ], {
        image: ACTIONS_PUMP,
        alignment: "Center",
        size: 0.5
      });
    },
    frequency: "medium"
  },

  // Failing Single Pump Medium
  {
    id: generateUniqueId(),
    title: "A pump failure has occured",
    action: (workflows) => {
      console.log("A pump failure has occured")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        actions.pumps[Math.floor(Math.random() * actions.pumps.length)]
      ], {
        image: ACTIONS_PUMP_ERROR,
        alignment: "Center",
        size: 0.5
      });
    },
    frequency: "medium"
  },  

  // Running Right Equipments Single
  {
    id: generateUniqueId(),
    title: "A global restart of all right equipments in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all filters in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        ...actions.directionToRight,
      ], {
        image: ACTIONS_ARROW_RIGHT_SUCCESS,
        alignment: "Center",
        size: 1.0
      });
    },
    frequency: "medium"
  },  

  // Failing Single Right Equipment Medium
  {
    id: generateUniqueId(),
    title: "A equipment failure has occured",
    action: (workflows) => {
      console.log("A pump failure has occured")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        actions.directionToRight[Math.floor(Math.random() * actions.directionToRight.length)]
      ], {
        image: ACTIONS_ARROW_RIGHT_ERROR,
        alignment: "Center",
        size: 0.5
      });
    },
    frequency: "medium"
  },  

  // Running Left Equipments Single
  {
    id: generateUniqueId(),
    title: "A global restart of all storage tanks in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all storage tanks in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        ...actions.directionToLeft,
      ], {
        image: ACTIONS_ARROW_LEFT_SUCCESS,
        alignment: "Center",
        size: 1.0
      });
    },
    frequency: "medium"
  },  

  // Failing Single Left Equipment Medium
  {
    id: generateUniqueId(),
    title: "An equipment failure has occured",
    action: (workflows) => {
      console.log("A pump failure has occured")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        actions.directionToLeft[Math.floor(Math.random() * actions.directionToLeft.length)]
      ], {
        image: ACTIONS_ARROW_LEFT_ERROR,
        alignment: "Center",
        size: 0.5
      });
    },
    frequency: "medium"
  },  


  // Feed Tanks Single
  {
    id: generateUniqueId(),
    title: "A global restart of all feed tanks in the plant has been successfully completed.",
    action: (workflows) => {
      console.log("A global restart of all feed tanks in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        ...actions.feedTanks,
      ], {
        image: ACTIONS_ARROW_RIGHT_SUCCESS,
        alignment: "Center",
        size: 1.0
      });
    },
    frequency: "single"
  },  

  // Settling Tank Medium
  {
    id: generateUniqueId(),
    title: "Settling Tank is overflowing with suspended solids",
    action: (workflows) => {
      console.log("A global restart of all feed tanks in the plant has been successfully completed.")
      workflows 
      && workflows.active === WorkflowOptions.EQUIPMENT_ACTIONS
      && generateScriptsAction(workflows, [
        ...actions.fillingTanks,
      ], {
        image: ACTIONS_FILLING_TANK,
        alignment: "Center",
        size: 1.15
      });
    },
    frequency: "medium"
  },  
];

export const handleWorkflowChange_9d675926_c139_4d1d_9f00_f17633116b65 = (event, initialWorkflow, setSelectedUpdate, setWorkflow, setSelectedWorkflow, setEvent) => {
  // Clear the selected update whenever the workflow changes
  setSelectedUpdate(null); // Clear second dropdown
  if (!event) {
      setSelectedWorkflow(null);
      return;
  }
  setSelectedWorkflow(event);
  if (!event || !event.value) return;
  document.getElementById('update-select').selectedIndex = 0;
  let workflow = JSON.parse(JSON.stringify(initialWorkflow));
  let oldValue = workflow.active;
  workflow.active = event.value;
  setWorkflow({...workflow});  
};

// --------------------------------------------------------------------------------------------
// Sprite Helpers
// --------------------------------------------------------------------------------------------

const createSpriteFrame = ({image,
                              size = 1, 
                              alignment = "LowerCenter", 
                              autoScale = true, 
                              blend = 0.8
                            }
) => {
    return {
      type: "Gif",
      size,
      image,
      alignment,
      autoScale,
      blend
    };
};

// --------------------------------------------------------------------------------------------
// Status Helpers
// --------------------------------------------------------------------------------------------

const buildScriptAsSprite = (id, elementIds, props, uuidPrefix) => {
    return {
      uuid: `${uuidPrefix}.${id}`,
      elementIds,
      type: "Sprite",
      frames: [createSpriteFrame(props)]
    };
};

const generateScripts = (workflows, elementIds, props, uuidPrefix) => {
  if (!elementIds || !elementIds.length) return;

  degenerateScripts(workflows, elementIds, uuidPrefix);

  const workflow = findWorkflow(workflows, workflows.active);

  workflow.script = [
    ...workflow.script,
    ...elementIds.map((id, index) => buildScriptAsSprite(id, [id], props, uuidPrefix))
  ];
}

const generateScriptsAction = (workflows, elementIds, props) => {
  generateScripts(workflows, elementIds, props, 'Action');
};

const generateScriptsStatus = (workflows, elementIds, props) => {
  generateScripts(workflows, elementIds, props, 'Status');
};

const degenerateScripts = (workflows, elementIds, uuidPrefix) => {
    if (!elementIds || !elementIds.length) return;

    const workflow = findWorkflow(workflows, workflows.active);

    const uuids = elementIds.map(id => `${uuidPrefix}.${id}`);

    removeScripts(workflow, uuids);
}

// --------------------------------------------------------------------------------------------
// Visibility Helpers
// --------------------------------------------------------------------------------------------
const createScriptVisibility = (uuid, elementIds) => {
  return {
    uuid,
    elementIds,
    type: "Visibility",
    frames: [false]
  };
};

const generateScriptsVisibility = () => {
  const elementIds = [150, 261, 262];
  const uuids = elementIds.map(id => `Visibility.${id}`);

  return uuids.map((uuid, index) => createScriptVisibility(uuid, [elementIds[index]]));
};
  
// --------------------------------------------------------------------------------------------
// Workflow Object
// --------------------------------------------------------------------------------------------

export const fetchWorfklowUpdates = (time, onUpdate) => {
  // console.log ('fetchWorfklowUpdates', time)
  // onUpdate("No Updates"); 
}
  
  