import React, { useEffect, useState, useMemo, useContext } from 'react';
import { ArrowDownIcon, ArrowUpIcon } from '../../../components/icons/ArrowIcon/ArrowIcon';
import { FileFolderIcon } from '../../../components/icons/FileServiceIcon';
import { ServerIcon } from '../../../components/icons/FileServiceIcon';
import filesPage from '../../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import './FolderNavTree.css';
import { LinearProgress } from '@mui/material';
import { AppContext } from '../../../../client/AppContext';

export const FolderNavTree = React.memo(({ onSetCurrentFolder }) => {
console.log("rendering FolderNavTree");
const { rootFolder, ctx } = useContext(AppContext); 
const [loading, setLoading] = useState(false);

const handleFolderOpen = (folder) => {
  onSetCurrentFolder(folder)
}

const FolderName = ({
  name,
  onClick
}) => {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => setIsHovered(true);
  const handleMouseLeave = () => setIsHovered(false);
  return (
    <div
      style={{ cursor: isHovered ? 'pointer' : 'default' }}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={onClick}
    >
      <p className='folderName' style={{ color: isHovered ? 'var(--app-accent-color)' : '#707070' }}>
        {name}
      </p>
    </div>
  )
}

const FolderItem = ({
  folderName,
  icon,
  onTwistieClick,
  onFolderNameClick,
  margin,
  open
}) => {
  const marginLeft = margin + "px";

  return (
    <div className='inline listItem' style={{ marginLeft: marginLeft }}>
      <div onClick={() => onTwistieClick()}>
        { open ? <ArrowUpIcon width={25} height={25}/> : <ArrowDownIcon width={25} height={25}/> }
      </div>
      {icon}
      {<FolderName name={folderName} onClick={() => onFolderNameClick()}/>}
    </div>
  )
};

const FolderLoading = ({ loading, margin }) => {
  return (
    <>
      { loading ?
        <div className='linearProg' style={{ marginLeft: margin }}>
          <LinearProgress size={20}/>
        </div> 
        : <p className='noFolders' style={{ marginLeft: margin }}>No subfolders</p>
      }
    </>

  )
}

const ExpandableFolder = ({folder, margin, onOpenFolder}) => {
  const [open, setOpen] = useState(false);
  const [subfolders, setSubfolders] = useState([]);
  const [loading, setLoading] = useState(true)
  const handleTwistieClick = async () => {
    setOpen(!open)
    
      await filesPage.loadFolderSubfolders(folder, ctx, undefined, PlatformApi)
        .then( response => {
          setSubfolders(response)
          setLoading(false)  
        }
      ) 
    
  }
  const handleFolderNameClick = () => {
    onOpenFolder(folder)
  }

  const icon = ((Object.keys(folder).length > 0) && (folder._versions[0]._userAttributes.path === '/')) ? <ServerIcon/> : <FileFolderIcon/>;

  return (
    <>
      {Object.keys(folder).length > 0 && 
        <>
          <FolderItem 
            folderName={folder._name} 
            icon={icon} 
            onTwistieClick={() => handleTwistieClick()}
            onFolderNameClick={() => handleFolderNameClick()}
            margin={margin}
            open={open}
          />
          { open && 
            (( subfolders?.length > 0 ) ? 
              subfolders.map(subfolder => 
                <ExpandableFolder folder={subfolder} margin={ margin + 20 } onOpenFolder={(folder) => onOpenFolder(folder)}/>
              )
            : <FolderLoading loading={loading} margin={`${margin + 30 + 'px'}`}/>)
          }
        </>
      }
    </>
  )

};

  return (
    <div className='folder-content'> 
      <h6 className='title'>Folder tree</h6>
      {loading ? (
        <LinearProgress />
      ) : (
        rootFolder &&     
          <ExpandableFolder folder={rootFolder} margin={20} onOpenFolder={(folder) => handleFolderOpen(folder)}/>        
      )}
    </div>
  )
}) 