import React from 'react';
import DeleteFileModal from '../../../components/Modals/DeleteFileModal';
import DeleteFolderModal from '../../../components/Modals/DeleteFolderModal';
import InfoModal from '../../../components/Modals/InfoModal';
import DownloadModal from '../../../components/Modals/DownloadModal';
import DocViewerModal from '../../../components/Modals/DocViewerModal';
import { VersionHistoryModal } from '../../../components/Modals/VersionHistoryModal';
import { useQueryContext } from "../../../Context/QueryContext";
import DeleteFileVersionModal from '../../../components/Modals/DeleteFileVersionModal';
import { IafFileSvc } from '@dtplatform/platform-api';

export const ActionDialogs = ({
  modalAction,
  actionModalObj,
  onClose,
  onFileUpdate,
  onFolderUpdate,
  onDeleteFile,
  onDeleteFolder,
  onDeleteFileVersion,
  versionFileItem
}) => {

  // Context
  const { state } = useQueryContext();
  const { currentFolder } = state;

  const docToView = [{
    _fileId: actionModalObj._fileId
  }]
  const shouldRender = docToView.length > 0;

  switch (modalAction) {
    case 'Info':
      return <InfoModal 
        item={actionModalObj} 
        onFileUpdated={(updatedFile) => onFileUpdate(updatedFile)}
        onFolderUpdated={(updatedFolder) => onFolderUpdate(updatedFolder)}
        onClose={onClose}
      />
    case 'Delete':
      if (actionModalObj._fileId) {
        return (
          <DeleteFileModal 
            item={actionModalObj} 
            onClose={onClose} 
            onFileDelete={(item) => { onDeleteFile(item, currentFolder); onClose; }}
          />
        )
      } else {
        return (
          <DeleteFolderModal 
            folder={actionModalObj} 
            onClose={onClose} 
            onFolderDelete={(obj) => { onDeleteFolder(obj); onClose; }}
          />
        )
      }  
    case 'DeleteVersion':
      return (
        <DeleteFileVersionModal 
          versionObj={actionModalObj} 
          fileItem={versionFileItem}
          onClose={onClose} 
          onDeleteFileVersion={() => { onDeleteFileVersion(); onClose; }}
        />
      )
    case 'Download':
      return <DownloadModal item={actionModalObj} onClose={onClose}/>
    case 'View':
      return shouldRender ?  <DocViewerModal docIds={docToView} onClose={onClose}/> : null
    case 'Version history':
      return (
        <VersionHistoryModal 
          item={actionModalObj} 
          onClose={onClose}
        />
      )
  }
}