import React, { useState } from 'react';
import DropdownMenu from '../../../components/DropdownMenu/DropdownMenu';
import { useQueryContext } from "../../../Context/QueryContext";

const ServerFilter = ({ 
  propOptions, 
  onPropSelected, 
  valueOptions, 
  onValueSelected,
  users,
  resetSelectedOption 
}) => {

  const [selectedProp, setSelectedProp] = useState("");
  const options = valueOptions ? valueOptions.map(option => option.formatted) : [];

  const { state } = useQueryContext();
  const { filtered } = state;

  console.log("propOptions server filter:", propOptions);

  const propSelected = (prop) => {
    setSelectedProp(prop);
    onPropSelected({
      prop: prop,
      users: users
    });
  }

  const selectedValue = (value) => {
    const valueObject = valueOptions.filter(option => option.formatted == value);
    onValueSelected({
      type: selectedProp,
      value: valueObject[0]
    });
  }

  return (
    <>
      <DropdownMenu 
        options={propOptions} 
        onOptionSelected={(option) => {
          propSelected(option)
        }}
        placeholder={"Select filter prop..."}
        resetSelectedOption={resetSelectedOption}
        width={200}
        iconSize={25}
      />
      <DropdownMenu 
        options={options} 
        onOptionSelected={(value) => {
          selectedValue(value)
        }}
        placeholder={"Select filter value..."}
        resetSelectedOption={resetSelectedOption}
        width={200}
        iconSize={25}
      />
    </>
  );
};

export default ServerFilter;
