import React, { useState } from 'react';

function FolderName({ name, onClick }) {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => {
    setIsHovered(true);
  };

  const handleMouseLeave = () => {
      setIsHovered(false);
  };

  const style = {
    color: isHovered ? 'var(--app-accent-color)' : '#000000', 
    cursor: 'pointer',
  };


  return (
    <span 
      onClick={onClick}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      style={style}
    >
      {name}
    </span>
  );
}

export default FolderName;