import React, { useContext, useState } from 'react';
import { Spinner } from "../../../components/icons/Spinners";
import './FolderView.css';
import FolderViewTableHead from './FolderViewTableHead';
import FolderViewHeader from './FolderViewHeader';
import AddFolderDialog from '../../../components/Modals/AddFolderDialog';
import UploadFileDialog from '../../../components/Modals/UploadFileDialog';
import Button from "@mui/material/Button";
import { ArrowLeftIcon } from '../../../components/icons/ArrowIcon/ArrowIcon';
import filesPage from '../../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import PageFooter from '../PageFooter/PageFooter';
import { useQueryContext } from "../../../Context/QueryContext";
import { TableBody } from './TableBody';
import { SearchAndFilter } from './SearchAndFilter';
import { ActionDialogs } from './ActionDialogs';
import { IafLocalFile } from '@dtplatform/ui-utils';
import { IafFile } from '@dtplatform/platform-api';
import { AppContext } from '../../../../client/AppContext';

export const FolderView = ({
  currentFolder,
  childFolders,
  childFiles,
  loading
}) => {
  
  // Context
  const { ctx } = useContext(AppContext);
  console.log("rendering FolderView, ctx", ctx);
  const { state, actions } = useQueryContext();
  const { pageSize, pageNum, backNavcounter, updateCounter } = state;
  const { setBackNavcounter, setPageSize, setPageNum, setUpdateCounter } = actions;

  const root = '/';

  const [createFolderDialog, setCreateFolderDialog] = useState(false);
  const [uploadFileDialog, setUploadFileDialog] = useState(false);
  const [displayActionModal, setDisplayActionModal] = useState(false);
  const [modalAction, setModalAction] = useState("");
  const [actionModalObj, setActionModalObj] = useState({});
  const [showSearch, setShowSearch] = useState(false);
  const [showFilter, setShowFilter] = useState(false);

  const fileActions = ["Info", "Download", "Version history", "View", "Delete" ]; 
  const folderActions = ["Info", "Version history", "Open", "Delete" ]; 
  const colWidths = [ 5, 30, 5, 10, 15, 15, 15, 5 ];

  const colTitles = [ 
    (Object.keys(currentFolder).length > 0 && currentFolder._versions[0]._userAttributes.path !== root)
      ? <Button onClick={() => { onBackNav() }}>
          <ArrowLeftIcon style={{ marginTop: "0px", marginBottom: "0px" }} height={25} width={25} />
        </Button>
      : "",
    "Name", "Version", "Size", "Updated", "Updater", "Created", "" ];

  const openFolderDialog = (boolean) => { 
    setCreateFolderDialog(boolean) 
  };
  const openFileDialog = (boolean) => { 
    setUploadFileDialog(boolean) 
  };
  const toggleSearch = () => {
    setShowSearch(!showSearch)
  };
  const toggleFilter = () => {
    setShowFilter(!showFilter)
  };

  // callbacks
  const onBackNav = () => {
    setBackNavcounter(backNavcounter + 1)
  };
  const onUpdatePageSize = (pageSize) => {
    setPageSize(pageSize)
  };
  const onPageForward = () => {
    setPageNum(pageNum + 1)
  };
  const onPageBack = () => {
    setPageNum(pageNum - 1)
  };
  const handleActionClick = (actionObj) => {
    setModalAction(actionObj.modalAction)
    setActionModalObj(actionObj.item)
    setDisplayActionModal(true);
  };
  const update = () => {
    console.log("triggering refresh");
    setUpdateCounter(updateCounter + 1)
  };

  const createFolder = async (folderDef) => {
    setCreateFolderDialog(false);
    console.log("createfolder ctx", ctx);
    await filesPage.createFolder(folderDef, currentFolder, ctx, PlatformApi)?.then(() => update());
  }

  const uploadFile = async () => {
    try {
      const configFile = await IafLocalFile.selectFiles({
        multiple: false,
        accept:
          ".csv, .jpg, .png, .gif, .pdf, .doc, .docx, .rtf, .xls, .xlsx, .ppt, .pptx, .txt",
      });
      console.log("configFile", configFile)
      if (configFile.length > 0) {
        let file = configFile[0].fileObj;
        const uploadedFile = await IafFile.uploadFile(
          currentFolder, 
          file, 
          undefined, 
          ctx, 
          undefined
        );
        console.log("uploadedFile", uploadedFile);
        if (uploadedFile) {
          update()
          console.log('uploadedFile success', uploadedFile);
        }
      }
      openFileDialog(false); 
    } catch (e) {
      console.log("error uploading file", e)
    }
  };

  const updateFile = async (file) => {
    setUploadFileDialog(false);
    await filesPage.updateFileItem(currentFolder, file, ctx, PlatformApi)?.then(() => update())
  };
  const updateFolder = async (folder) => {
    setUploadFileDialog(false);
    await filesPage.updateFileColl(folder, ctx, PlatformApi)?.then(() => update())
  };
  const deleteFile = async (fileItem, folder) => {
    await filesPage.deleteFile(fileItem, folder, ctx, PlatformApi)?.then(() => update())
  };
  const deleteFolderAndContents = async (obj) => {
    const {folder, subfolders, subfiles} = obj
    if (subfolders.length < 0 || subfiles.length < 0 ) {
      subfolders.length > 0 && await filesPage.deleteSubfolders(subfolders, ctx, PlatformApi)
      subfiles.length > 0 && await filesPage.deleteSubfolders(subfolders, ctx, PlatformApi)
    } 
    await filesPage.deleteFolder(folder, ctx, PlatformApi)?.then(() => update())
  };

  // functional components

  const blindDivContainer = { 
    width: "100%", 
    display: "flex", 
    justifyContent: "center", 
    backgroundColor: "#f5f5f5", 
    height: "70%" 
  };
  const blindDivContent = { 
    marginTop: "50px",
    ...( ! loading && {textAlign: "center"}) 
  };
  const loadingBlind = () => {
    return (
      <div style={blindDivContainer}>
        <div style={blindDivContent}>
          <Spinner/>
        </div>
      </div>
    )
  };
  const noFoldersFilesFound = () => {
    return (
      <div style={blindDivContainer}>
        <div style={blindDivContent}>
          <h6>No folders or files...</h6>
          <h6>Click <b>New Folder</b> or <b>Upload File</b> to add a folder or file.</h6>
        </div>
      </div>
    )
  };
  const renderActionDialog = () => {
    if (modalAction.length > 0 && Object.keys(actionModalObj).length > 0) {
      return (
        <ActionDialogs
          modalAction={modalAction}
          actionModalObj={actionModalObj}
          onClose={() => setDisplayActionModal(false)}
          onFileUpdate={(updatedFile) => updateFile(updatedFile)}
          onFolderUpdate={(updatedFolder) => updateFolder(updatedFolder)}
          onDeleteFile={(item) => deleteFile(item, currentFolder)}
          onDeleteFolder={(obj) => {
            deleteFolderAndContents(obj);
            setDisplayActionModal(false)
          }}
        />
      )
    }
    return null;
  }

  return (
    <div className="folder-view-content">   
      { createFolderDialog && 
        <AddFolderDialog 
          currentFolder={currentFolder._name} 
          childFolders={childFolders}
          onClose={() => openFolderDialog(false)}
          onCreateFolder={(folderDef) => createFolder(folderDef)}
        /> 
      }
      { uploadFileDialog && 
        <UploadFileDialog
          currentFolder={currentFolder._name} 
          onClose={() => openFileDialog(false)}
          onUploadFile={uploadFile}
        /> 
      }
      { displayActionModal && renderActionDialog() }
        <div className="inline">
          <FolderViewHeader 
            title={currentFolder ? currentFolder._name : ""} 
            onFolderCreate={() => openFolderDialog(true)} 
            onFileUpload={() => openFileDialog(true)}
            onShowSearch={() => toggleSearch()}
            onShowFilter={() => toggleFilter()}
          />
        </div>
        {( showSearch || showFilter ) &&
          <SearchAndFilter showSearch={showSearch} showFilter={showFilter}/>
        }
        <div className="table"> 
          <table>
            <FolderViewTableHead 
              colTitles={colTitles} 
              colWidths={[...colWidths]} 
              onSort={(sortObj) => sortFolder(sortObj)} 
            />
            { ! loading && ( childFolders?.length > 0 || childFiles?.length > 0) && 
              <TableBody
                currentFolder={currentFolder}
                childFolders={childFolders}
                childFiles={childFiles}
                colWidths={colWidths}
                folderActions={folderActions}
                fileActions={fileActions}
                onActionClick={(actionObj) => handleActionClick(actionObj)}
              />
            }
          </table>
          { loading && loadingBlind()}
          { 
            ! loading 
            && ( (!childFolders || childFolders?.length == 0) 
            && ( !childFiles || childFiles?.length == 0)) 
            && noFoldersFilesFound()
          }
        </div>   
        <PageFooter 
          pageSizeOptions={[ 5, 10, 20, 50 ]} 
          onSetPageSize={(size) => { onUpdatePageSize(size) }}
          onPageForward={() => { onPageForward() }}
          onPageBack={() => { onPageBack() }}
          pageSize={pageSize}
          pageNum={pageNum}
        />         
    </div> 
  );
}

export default FolderView;