import React from 'react';
import Button from "@mui/material/Button";
import AddIcon from "@mui/icons-material/Add";
import PublishIcon from "@mui/icons-material/Publish";
import ToggleStyledButton from '../../../components/Buttons/ToggleStyledButton';
import { FilterList } from '@mui/icons-material';
import { Search } from '@mui/icons-material';
import StyledButton from '../../../components/Buttons/StyledButton';


const FolderViewHeader = ({ 
  title, 
  onFolderCreate, 
  onFileUpload, 
  onShowSearch, 
  onShowFilter, 
  showArrow, 
  onArrowClick 
}) => {

  const buttonAccent = {
    color: "var(--app-accent-color)",
  };

  const titleStyle = {
    display: 'inline-block', 
    marginRight: '10px',
  };

  const buttonMargin = {
    marginRight: "5px"
  };
  
  return (
    <div style={{ width: "100%", display: "grid", gridTemplateColumns: "auto 1fr", marginBottom: "30px" }}>
 
      <h4 style={titleStyle}>{title}</h4>

      <div style={{ display: "flex", justifyContent: "flex-end" }}>
        <StyledButton text="New Folder" onClick={onFolderCreate}>
          <AddIcon style={{...buttonAccent}}/>
        </StyledButton>
        <StyledButton text="Upload File" onClick={onFileUpload}>
          <PublishIcon style={{...buttonAccent}} />
        </StyledButton>
        <ToggleStyledButton text="Search" onClick={onShowSearch}>
          <Search style={{...buttonAccent}}/>
        </ToggleStyledButton>
        <ToggleStyledButton text="Filter" onClick={onShowFilter}>
          <FilterList style={{...buttonAccent}}/>
        </ToggleStyledButton>        
      </div>
    </div>
  );
};

export default FolderViewHeader;