import React from 'react';
import './FolderView.css';

const FolderViewRow = ({ rowColumns, colWidths, height }) => {
  console.log("FolderViewRow rowColumns", rowColumns)

  const tablerowStyle = {
    height: height,
    backgroundColor: "#f5f5f5",
    border: "1px solid #ddd",
    borderRadius: "8px",
    verticalAlign: "middle",
    marginTop: "3px",
  };

  return (
    <tr style={tablerowStyle}>
      {rowColumns.map((item, index) => (
        <td 
          key={index} 
          style={{ width: `${colWidths[index]}%` }}>
            {item}
        </td>
      ))}
    </tr>
  );
};

export default FolderViewRow;