import React, { useState } from 'react';
import './FolderView.css';
import { ArrowDownIcon, ArrowUpIcon } from '../../../components/icons/ArrowIcon/ArrowIcon';
import { useQueryContext } from '../../../Context/QueryContext';

const FolderViewTableHead = ({ colTitles, colWidths }) => {

  const { state, actions } = useQueryContext();
  const { sortBy, sortDescend } = state;
  const { setSortBy, setSortDescend } = actions;
  const { setPageNum } = actions;
  

  const setSort = (sortTitle) => {
    if (sortTitle === sortBy) {
      setSortDescend(!sortDescend);
    } else {
      setSortDescend(false);
    }
    setPageNum(1)
    setSortBy(sortTitle);
  };

  return (
    <thead className='tablehead'>
      <tr>
        {colTitles.map((title, index) => (
          <td key={index} style={{borderTop: '0px', width: `${colWidths[index]}%` }} className="tableheadrow">
            <div className="inline" onClick={() => {
              typeof title === 'string' && title.length > 0 && setSort(title)
            }}>
              <h6>{title}</h6>
              {typeof title === 'string' && title.length > 0 &&
                ((title === sortBy && sortDescend) ? <ArrowUpIcon width={20} height={20}/> : <ArrowDownIcon width={20} height={20} />)
              }
            </div>   
          </td>
        ))}
      </tr>
    </thead> 
  );
};

export default FolderViewTableHead;