import React, { useState, useEffect, useContext } from 'react';
import './FolderView.css';
import { useQueryContext } from "../../../Context/QueryContext";
import ServerFilter from './FileAndFolderFilter';
import SearchInput from '../../../components/Input/SearchInput';
import ToggleButton from './Toggle';
import Button from "@mui/material/Button";
import { Close } from '@mui/icons-material';
import filesPage from '../../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import { AppContext } from '../../../../client/AppContext';

export const SearchAndFilter = ({
  showSearch,
  showFilter
}) => {

  // Context
  const { projUsers, ctx } = useContext(AppContext);
  const { state, actions } = useQueryContext();
  const { global, filtered, filterType, currentFolder, pageNum } = state;
  const { setGlobal, setFilterType, setFilterValue, setSearchTerm, setFiltered, setPageNum, setClearSearch} = actions;

  const [filterValueOptions, setFilterValueOptions] = useState([]);
  const [selectedOptionReset, setSelectedOptionReset] = useState(false);

  useEffect(() => {
    setGlobal(false);
  }, []); 

  const onResetFilters = () => { 
    setFiltered(false)
    setFilterType('')
    setFilterValue('')
    setSearchTerm('')
    setSelectedOptionReset(true)
    setPageNum(1)
    setClearSearch(true)
  }
  const onSetSearchFilter = (regex) => {
    setFiltered(true)
    setPageNum(1)
    setSearchTerm(regex)
  }
  const onFilterFilesAndFolders = (result) => {
    setFiltered(true)
    setPageNum(1)
    setFilterType(result.type);
    setFilterValue(result.value.dbValue);
  }
  const globalToggle = () => {
    setGlobal(!global)
    setPageNum(1)
  };

  const getFileAndFolderValueOptions = async (type) => {
    const values = await filesPage.getFileAndFolderValueOptions(
      type, 
      global,
      ctx,
      currentFolder,
      projUsers,
      PlatformApi
    );
    console.log("filter values", values)
    setFilterValueOptions(values)
  }

  const filterObjs = filesPage.filterObjs;
  console.log("filterObjs search and filter", filterObjs)
  const propOptions = Object.keys(filterObjs).map(key => key);
  console.log("propOptions search and filter", propOptions)

  const buttonAccent = { color: "var(--app-accent-color)" };
  const buttonMargin = { marginRight: "5px" };

  return (
    <div className="search-and-filter-bar">
      {showSearch && <SearchInput onChange={(text) => onSetSearchFilter(text)} width={200}/>}
      {showFilter && 
        <ServerFilter
          propOptions={propOptions}
          onPropSelected={(obj) => getFileAndFolderValueOptions(obj.prop)}
          valueOptions={filterValueOptions}
          onValueSelected={(result) => onFilterFilesAndFolders(result)}
          users={projUsers}
          resetSelectedOption={selectedOptionReset}
        />
      }
      {( showSearch || showFilter ) && <ToggleButton onClick={() => { globalToggle() }}/>}
      { filtered &&
        <Button className="controllerButtons" onClick={() => { onResetFilters() }}>
          <Close style={{...buttonAccent, ...buttonMargin}}/>
          <span style={buttonAccent}>Remove Filter</span>
        </Button>
      }
    </div>
  );
}