import React, { useContext } from 'react';
import './FolderView.css';
import { FileFolderIcon, FileIcon } from '../../../components/icons/FileServiceIcon';
import FolderViewRow from './FolderViewRow';
import FolderName from './FolderName';
import KebabMenu from '../../../components/KebabMenu/KebabMenu';
import filesPage from '../../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import { useQueryContext } from "../../../Context/QueryContext";
import { AppContext } from '../../../../client/AppContext';

export const TableBody = ({
  childFolders,
  childFiles,
  colWidths,
  folderActions,
  fileActions,
  onActionClick,
}) => {

  console.log("rendering TableBody, childFiles", childFiles);
  // Context
  const { projUsers } = useContext(AppContext);
  const { actions } = useQueryContext();
  const { setCurrentFolder, setBackNav } = actions;

  // callbacks

  const onSetCurrentFolder = (folder) => {
    console.log("setting new current folder from TableBody")
    setCurrentFolder(folder);
    setBackNav(false);
  };

  const getUpdatedByUser = (userId) => {
    const user = projUsers.filter(user => user._id === userId);
    if (user[0]) {
      return user[0]._firstname + " " + user[0]._lastname
    }
  }

  const handleActionClick = (action, item) => {
    onActionClick({
      modalAction: action,
      item: item
    })
  }

  return (
    <tbody >
      { childFolders?.length > 0 && (
        childFolders.map((folder) => (    
          <FolderViewRow 
            key={folder._id}
            rowColumns={[ 
              <FileFolderIcon />, 
              <FolderName name={folder._name} onClick={() => onSetCurrentFolder(folder) }/>,
              folder._tipVersion, 
              "",
              filesPage.formatDate(folder._metadata._updatedAt), 
              getUpdatedByUser(folder._metadata._updatedById),
              filesPage.formatDate(folder._metadata._createdAt),
              <KebabMenu 
                actions={[...folderActions]} 
                onClick={(action) => {
                  handleActionClick(action, folder)
                }}
              /> 
            ]} 
            colWidths={[...colWidths]} 
            height={"50px"}
          />          
        ))
      )}
      {childFiles && (
        childFiles.map((file) => (
          <FolderViewRow 
            key={file._id}
            rowColumns={[ 
              <FileIcon />, 
              file.name, 
              file.tipVersionNumber, 
              `${file.versions[0].fileSize} bytes`,
              filesPage.formatDate(file._metadata._updatedAt), 
              getUpdatedByUser(file._metadata._updatedById),
              filesPage.formatDate(file._metadata._createdAt),
              <KebabMenu actions={[...fileActions]}
                onClick={(action) => {
                  handleActionClick(action, file)
                }}
              />   
            ]}
            colWidths={[...colWidths]} 
            height={"50px"}
          />      
        ))
      )}
    </tbody>
  );
}