import React, { useState, useEffect } from 'react';
import Toggle from 'react-toggle';
import 'react-toggle/style.css';
import { Storage } from '@mui/icons-material';
import { FileFolderIcon, ServerIcon } from '../../../components/icons/FileServiceIcon';

const ToggleButton = ( { onClick } ) => {
  const [isToggled, setIsToggled] = useState(false);

  const handleToggle = () => {
    setIsToggled(prevState => !prevState);
  };

  useEffect(() => {
    onClick(isToggled);
  }, [isToggled]);

  return (
    <div style={{ display: 'flex', alignItems: 'center', marginLeft: '10px' }}>
      <FileFolderIcon 
        height={30} 
        width={30} 
        fill={isToggled ? "grey" : "black" }
        title="Search and filter the current folder"
      />
      <Toggle
        defaultChecked={isToggled}
        onChange={handleToggle}
        className="react-toggle"
        icons={false}
        style={{ backgroundColor: '#888', flex: 1 }}
        title="Search and filter the current folder or all project folders"
      />
      <ServerIcon 
        height={25} 
        width={25} 
        fill={isToggled ? "black" : "grey" }
        title="Search and filter all project folders"
      />
    </div>
  );
};

export default ToggleButton;