
import React, { useContext, useEffect, useState } from "react";
import { FolderView } from "./FolderView/FolderView";
import useFilesAndFolders from "../../Hooks/filesHook"
import { useQueryContext } from "../../Context/QueryContext";
import { AppContext } from "../../../client/AppContext";
import { IafItemSvc } from "@dtplatform/platform-api";

export const FolderViewContainer = ({newFolderNav}) => {
  console.log("rendering FolderViewContainer");

  const { ctx } = useContext(AppContext);
  const { state, actions } = useQueryContext();
  const { global, currentFolder, filterType, filterValue, filtered, searchTerm, backNav, pageSize, pageNum, updateCounter, sortBy, sortDescend } = state;
  const { setCurrentFolder, setGlobal } = actions;
  const [stableCurrentFolder, setStableCurrentFolder] = useState({...currentFolder});
  console.log("rendering FolderViewContainer, currentFolder", currentFolder);

  useEffect(() => {
    const navToNewFolder = () => {
      if (Object.keys(newFolderNav).length > 0 && newFolderNav !== currentFolder) { 
        console.log("navToNewFolder running");
        setCurrentFolder(newFolderNav);
      }
    };
    navToNewFolder();
  }, [newFolderNav]); 

  useEffect(() => {
    const checkstableCurrentFolder = () => {
      if (currentFolder._id !== stableCurrentFolder._id) { 
        setStableCurrentFolder(currentFolder);
      } 
    };
    checkstableCurrentFolder();
  }, [currentFolder]); 

  const { loading, workingFolder, subfolders, subfiles } = useFilesAndFolders( 
    ctx, 
    stableCurrentFolder, 
    filterType, 
    filterValue, 
    filtered,
    searchTerm, 
    global, 
    backNav,
    pageSize, 
    pageNum,
    updateCounter,
    sortBy,
    sortDescend
  );

  return (
    currentFolder && 
      <FolderView
        currentFolder={workingFolder} 
        childFolders={subfolders} 
        childFiles={subfiles} 
        loading={loading}
      />     
  );
}
export default FolderViewContainer;