import React, { useState } from 'react';
import DropdownMenu from '../../../components/DropdownMenu/DropdownMenu';
import Button from "@mui/material/Button";
import { ArrowLeftIcon, ArrowRightIcon } from '../../../components/icons/ArrowIcon/ArrowIcon';
import { useQueryContext } from '../../../Context/QueryContext';
import './PageFooter.css'

const PageFooter = ({ 
  pageSizeOptions, 
  onSetPageSize,
  onPageForward,
  onPageBack,
  pageSize,
  pageNum
}) => {

  const [selectedPageSize, setSelectedPageSize] = useState("");

  const arrowMargins = {
    marginTop: "0px", 
    marginBottom: "0px"
  }

  const pageSizeSelected = (size) => {
    setSelectedPageSize(size);
    onSetPageSize(size);
  }

  const pageForward = () => {
    onPageForward();
  }

  const pageBack = () => {
    pageNum > 1 && onPageBack();
  }

  return (
    <div className="inline contents">
      <p style={{marginBottom: "0px"}}>Files and folders per page:</p>        
      <DropdownMenu 
        options={pageSizeOptions} 
        onOptionSelected={(option) => {
          pageSizeSelected(option)
        }}
        placeholder={pageSize}
        width={50}
        iconSize={25}
      />
      
      <Button className='button' onClick={() => { pageBack() }}>
        <ArrowLeftIcon style={arrowMargins} height={25} width={25} />
      </Button> 
      <p style={{marginBottom: "0px"}}>Page {pageNum}</p>
      <Button onClick={() => { pageForward() }}>
        <ArrowRightIcon style={arrowMargins} height={25} width={25} />
      </Button>
    </div>
  );
};

export default PageFooter;
