import React, { useState } from 'react';
import SplitPane, { Pane } from 'split-pane-react';
import 'split-pane-react/esm/themes/default.css';

export const SplitScreen = ({ leftPane, rightPane }) => {
  const [sizes, setSizes] = useState([100, '30%', 'auto']);

  const layoutCSS = {
    height: '100%',
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center'
  };

  return (
    <div style={{height: '100vh'}}>
      <div className="react-split">
        <SplitPane
          split='vertical'
          sizes={sizes}
          onChange={setSizes}
        >
          <Pane minSize={50}>
            <div style={{ ...layoutCSS }}>
              {leftPane}
            </div>
          </Pane>
          <Pane minSize={250}>
            <div style={{ ...layoutCSS }}>
              {rightPane}
            </div>  
          </Pane>
        </SplitPane>
      </div>      
    </div>

  );
};