/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, { useState, useCallback, useContext, useEffect } from 'react';
import FolderViewContainer from './FolderViewContainer';
import { FolderNavTree } from './FolderNavTree/FolderNavTree';
import './UploadFile.css'
import { SplitScreen } from './SplitScreen';
import { AppContext } from '../../../client/AppContext';
import { IafProj } from '@dtplatform/platform-api';
import * as PlatformApi from '@dtplatform/platform-api';
import { useQueryContext } from '../../Context/QueryContext';
import filesPage from '../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';

const UploadFile = () => {
  console.log("rendering UploadFile");
  const { state } = useQueryContext();
  const { currentFolder } = state;
  const { ctx, project, setProject, rootFolder, setRootFolder, projCheck, setProjCheck, folderCheck, setFolderCheck } = useContext(AppContext);
  const [navToFolder, setNavToFolder] = useState({});

  useEffect(() => {
    const checkProj = async () => {
      if (!projCheck) {
        try {
          const proj = await IafProj.getCurrent();
          console.log("proj", proj)
          console.log("project", project)
          if (! project || (proj._namespaces[0] !== project._namespaces[0])) {
            console.log("setting new project in ctx")
            setProject(proj)
          } 
          setProjCheck(true)
        } catch (error) {
          console.error('Error checkProj:', error);
        }        
      }
    };
    checkProj();
  }, []);

  useEffect(() => {
    const checkCurrentFolder = async () => {
      if (!currentFolder || Object.keys(currentFolder).length == 0) {
        console.log("current folder not set")
        try {
          if (!rootFolder || Object.keys(rootFolder).length == 0) {
            await filesPage.getFolderByPath('/', ctx, PlatformApi).then(folder => {
              if (folder && typeof folder !== 'undefined') {
                console.log("setting root folder at uploadFile", folder)
                setRootFolder(folder)                
              } else {
                console.log("Creating Root Container...");
                PlatformApi.IafFile.createContainer(
                  project,
                  undefined,
                  ctx
                ).then((rootContainer) => {
                  console.log("rootContainer result", rootContainer);
                  setRootFolder(rootContainer) 
                })
              }
            });            
          }
        } catch (error) {
          console.error('Error checkCurrentFolder:', error);
        }        
      }
      setFolderCheck(true);
    };
    checkCurrentFolder();
  }, []);
 
  const handleSetCurrentFolder = useCallback((folder) => {
    setNavToFolder(folder);
  }, []);

  console.log("UploadFile currentFolder", currentFolder)
  console.log("UploadFile rootFolder", rootFolder)
  console.log("UploadFile project", project)

  const namespaceCheck = currentFolder?._namespaces?.[0] === project?._namespaces?.[0];

  return (
    projCheck && folderCheck && namespaceCheck &&
      <SplitScreen
        leftPane={
          <FolderNavTree onSetCurrentFolder={handleSetCurrentFolder}/>
        }
        rightPane={
          <FolderViewContainer newFolderNav={navToFolder}/>  
        }
      />     
  );
};

export default UploadFile;
