/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, { useState } from "react";
import clsx from "clsx";
import moment from 'moment'

import './UserGroupView.scss'

export const InviteCard  = ({invite, isCurrentUser=false, existingUser=false, showActions=false, onCancelInvite, onResendInvite, onAcceptInvite}) => {

  const [isDoingAction, setIsDoingAction] = useState(false)
  const [action, setAction] = useState(null)
  const [actionText, setActionText] = useState('')
  const [actionAcceptText, setActionAcceptText] = useState('')

  const getFormattedDate = (ts) => {
    let expires = moment(ts)
    return expires.format('MMM D, YYYY')
  }

  const confirmAction = (selectedAction) => {

    setAction(selectedAction)

    if (selectedAction === 'CANCEL') {
      setActionText('Confirm Invite Delete')
      setActionAcceptText(' Remove Invite')
    } else if (selectedAction === 'RESEND') {
      setActionText('Confirm Resend Invite')
      setActionAcceptText(' Resend Invite')
    }else if (selectedAction === 'ACCEPT') {
      setActionText('Confirm Invite Accept')
      setActionAcceptText(' Accept Invite')
    }

    setIsDoingAction(true)
  }

  const cancelAction = (e) => {
    if (e) e.preventDefault()

    setAction(null)
    setActionText('')
    setActionAcceptText('')
    setIsDoingAction(false)
  }

  const actionConfirmed = (e) => {
    if(e) e.preventDefault()

    if (action === 'CANCEL') {
      if (onCancelInvite) onCancelInvite(invite)
    }
    else if (action === 'RESEND') {
      if (onResendInvite) onResendInvite(invite)
    }
    else if (action === 'ACCEPT') {
      if (onAcceptInvite) onAcceptInvite(invite)
    }
  }

  let expiresDate = getFormattedDate(invite._expireTime)
  let expired = invite._status === 'EXPIRED'

  return  <li className='user-group-list-item invite'>
            <div className='card-row1'>
              <div className='invite-user-info'>
                {existingUser && <div className={clsx('user-full-name', isCurrentUser && 'current-user')}>{existingUser._lastname + ', ' + existingUser._firstname}</div>}
                <div className='user-email'>{invite._email}</div>
              </div>
              <div className='invite-info'>
                <div className={clsx('invite-expires', expired && 'expired')}><span className='bold'>Expires:</span> {expiresDate}</div>
                <div className='invite-usergroup'><span className='bold'>UserGroup:</span> {invite._usergroup._name}</div>
              </div>
              {showActions && !isDoingAction && <div className='card-actions'>
                {isCurrentUser && !expired && <i className='fas fa-check' onClick={() => confirmAction('ACCEPT')}></i>}
                <i className='fas fa-redo-alt' onClick={() => confirmAction('RESEND')}></i>
                <i className='fas fa-trash' onClick={() => confirmAction('CANCEL')}></i>
              </div>}
            </div>
            {isDoingAction && <div className='card-row2'>
              <div className='confirm-text'>{actionText}</div>
              <div><a href='#' onClick={actionConfirmed}><i className='fas fa-check'></i>{actionAcceptText}</a></div>
              <div><a href='#' onClick={cancelAction}><i className='fas fa-times'></i> Cancel</a></div>
            </div>}
          </li>
}