import Checkbox from "@mui/material/Checkbox/Checkbox";
import CheckIcon from "@mui/material/SvgIcon/SvgIcon";
import React, {useEffect, useState} from "react";
import _ from "lodash";
import {CheckCircle as CheckedCircle, RadioButtonUnchecked as UncheckedCircle} from "@mui/icons-material";

const iconStyle = {fontSize: 18};

export const TickCheckbox = ({...props}) => <Checkbox
    icon={<CheckIcon style={{...iconStyle, color: '#666666'}}/>}
    checkedIcon={<CheckIcon style={{...iconStyle, color: 'var(--app-accent-color)'}}/>}
    {...props}
/>;

export const RoundCheckbox = ({...props}) => <Checkbox
    icon={<UncheckedCircle style={{...iconStyle, color: '#666666'}}/>}
    checkedIcon={<CheckedCircle style={{...iconStyle, color: 'var(--app-accent-color)'}}/>}
    {...props}
/>;

export const useChecked = (inputItems, checkCallback, allCheckCallback) => {
    const [items, setItems] = useState([]);
    //const previousItems = usePrevious(inputItems);

    useEffect(() => {
        setItems(previousItems => {
            function previousInstance(instance) {
                //find previous entity(._id) or file (.name)
                return previousItems.find(item=>item._id && item._id == instance._id || item.name && item.name == instance.name)
            }
            const newItems = inputItems.map(instance => {
                const previous = previousInstance(instance);
                return {...instance, checked: previous ? previous.checked : false};
            })
            return newItems;
        });
    }, [inputItems]);

    const handleCheck = (checkedInstance) => {
        checkCallback?.(checkedInstance, !checkedInstance.checked);
        setItems(instances =>
        instances.map(instance => instance === checkedInstance ? {
            ...checkedInstance,
            checked: !checkedInstance.checked
        } : instance))
    };

    const allChecked = items.every(i => i.checked);

    const handleAllCheck = () => {
        allCheckCallback?.(!allChecked);
        setItems(instances => instances.map(instance => ({
            ...instance,
            checked: !allChecked
        })));
    }

    const resetChecked = (newInstances) => {
        setItems(oldInstances => (newInstances || oldInstances).map(instance => ({
                ...instance,
                checked: false
            }))
        );
    }

    return {allChecked, handleCheck, handleAllCheck, items, resetChecked}

}