export default class IafUtils {
    static platformEvmPropMode = undefined;
    static platformEvmCommandMode = undefined

    static getUrlSearchParams = () => {
        let urlParams = new URLSearchParams(window.location.hash);
        urlParams = new URLSearchParams(
            Array.from(urlParams, ([key, value]) => [key.toLowerCase(), value])
        );
        return urlParams;
    }
    
    static getIafEnabled = (param) => {
        const paramKey = param.toLowerCase();
        if (IafUtils[param] !== undefined) return IafUtils[param];

        IafUtils[param] = JSON.parse(IafUtils.getUrlSearchParams().get(paramKey));
        console.log(`IafUtils.${param}Enabled`, `/${param}`, IafUtils[param]);

        return IafUtils[param];
    }    
    static platformEvmPropModeEnabled = () => IafUtils.getIafEnabled("platformEvmPropMode");
    static platformEvmCommandModeEnabled = () => IafUtils.getIafEnabled("platformEvmCommandMode");
}