const groupBy = (objectArray, property) => {
    return objectArray.reduce((acc, obj) => {
        let key = obj[property];
         key = key.replace(/[\.]+/g, "");
        if (!acc[key]) {
            acc[key] = {};
        }
        // Add object to list for given key's value
        acc[key] = obj;
        return acc;
    }, {});
}


const _mapItemsAsRelated = (parentItems, relatedItems, fromField, relatedField) => {
    let res = [];
    for (let i = 0, l = parentItems.length; i < l; i++) {
        let relatedRecs = [];

        let parentItem = parentItems[i];
        let fromValues = [];

        if (!(parentItem[fromField]) && fromField.indexOf(".") > 1) {
            fromValues = fromField.split(".").reduce((o, i) => o[i] || [], parentItem);
        } else {
            fromValues = Array.isArray(parentItem[fromField]) ? parentItem[fromField] : [parentItem[fromField]];
        }

        if (fromValues && fromValues.length > 0)
            relatedRecs = relatedItems.filter((r) => fromValues.includes(r[relatedField]));

        if (relatedRecs.length > 0) {
            res.push({
                parentItem: parentItems[i],
                relatedItems: relatedRecs
            });
        }
    }
    console.log("_mapItemsAsRelated res: ", JSON.stringify(res))
    return res;
}
const createBIMCollections = async (params, PlatformApi, ctx) => {
     console.log(JSON.stringify({"message":"Creating Model Collections"}));
    let packagename = await PlatformApi
        .IafScriptEngine.getVar("package_name");
    let packagenameShort = await PlatformApi
        .IafScriptEngine.getVar("package_name_short");
        console.log("Create BIM Collection");
    //create Elements Collection
    const elementsCol = {
        "_name": packagename + "_elements",
        "_shortName": packagenameShort + "_ba_elem",
        "_description": "Elements in BA model",
        "_userType": "rvt_elements",
        "_namespaces": ctx._namespaces
    }
    const model_els_coll = await PlatformApi
        .IafScriptEngine.createCollection(elementsCol, ctx);
         console.log(JSON.stringify({"message":"Create BIM Collection - Element Collection"}));
    //create Element Properties Collection
    const modelElemPropsCol = {
        "_name": packagename + "_elem_props",
        "_shortName": packagenameShort + "_elprops",
        "_description": "Element Props in BA model",
        "_userType": "rvt_element_props",
        "_namespaces": ctx._namespaces
    }
    const model_els_props_coll = await PlatformApi
        .IafScriptEngine.createCollection(modelElemPropsCol, ctx);
         console.log(JSON.stringify({"message":"Create BIM Collection - Element Props Collection"}));

    //create Type Elements Collection
    const typeElemsCol = {
        "_name": packagename + "_type_el",
        "_shortName": packagenameShort + "_type_el",
        "_description": "Type Elements in BA Check model",
        "_userType": "rvt_type_elements",
        "_namespaces": ctx._namespaces
    }
    const model_type_el_coll = await PlatformApi
        .IafScriptEngine.createCollection(typeElemsCol, ctx);
         console.log(JSON.stringify({"message":"Create BIM Collection - Type Element Collection"}));

    //create Geometry File Collection
    const geometryFilesCol = {
        "_name": packagename + "_geom_file",
        "_shortName": packagenameShort + "_geom_file",
        "_description": "File Collection for Geometry Files",
        "_userType": "bim_model_geomresources",
        "_namespaces": ctx._namespaces
    }
    const model_geom_file_coll = await PlatformApi
        .IafScriptEngine.createCollection(geometryFilesCol, ctx);
         console.log(JSON.stringify({"message":"Create BIM Collection - Geometry File Collection"}));

    //create Geometry View Collection
    const geometryViewsCol = {
        "_name": packagename + "_geom_view",
        "_shortName": packagenameShort + "_geom_view",
        "_description": "Geometry Views in Model",
        "_userType": "bim_model_geomviews",
        "_namespaces": ctx._namespaces
    }
    const model_geom_views_coll = await PlatformApi
        .IafScriptEngine.createCollection(geometryViewsCol, ctx);
         console.log(JSON.stringify({"message":"Create BIM Collection - Geometry View Collection"}));

    //create Model Composite Item
    const modelCompItem = {
        "_name": packagename,
        "_shortName": packagenameShort + "_modelver",
        "_description": "BIM model version by transform",
        "_userType": "bim_model_version",
        "_namespaces": ctx._namespaces
    }
    PlatformApi
        .IafScriptEngine.setVar("bim_model", await PlatformApi
            .IafScriptEngine.createNamedCompositeItem(modelCompItem, ctx));

         console.log(JSON.stringify({"message":"Create BIM Collection - Model Composite Item"}));
    let _myCollections = {
        "model_els_coll": model_els_coll,
        "model_els_props_coll": model_els_props_coll,
        "model_type_el_coll": model_type_el_coll,
        "model_geom_file_coll": model_geom_file_coll,
        "model_geom_views_coll": model_geom_views_coll

    };
    return await createRelatedItemsAndRelationships(_myCollections, PlatformApi, ctx);

}

const createBIMCollectionVersion = async (params, PlatformApi, ctx) => {
    console.log(JSON.stringify({"message":"Found Previous Model Creating Versions"}));
    const modelRelatedCollection = await PlatformApi
        .IafScriptEngine.getCollectionsInComposite(
            PlatformApi
            .IafScriptEngine.getVar("bim_model")._id,null, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version - bim_model"}));

    await PlatformApi
        .IafScriptEngine.createNamedUserItemVersion({"namedUserItemId":PlatformApi
            .IafScriptEngine.getVar("bim_model")._id},ctx);
            console.log("Create BIM Collection Version bim_model version");
    const model_els_coll = modelRelatedCollection.find(x => x._userType === 'rvt_elements');
    const model_els_props_coll = modelRelatedCollection.find(x => x._userType === 'rvt_element_props');
    const model_type_el_coll = modelRelatedCollection.find(x => x._userType === 'rvt_type_elements');
    const model_geom_file_coll = modelRelatedCollection.find(x => x._userType === 'bim_model_geomresources');
    const model_geom_views_coll = modelRelatedCollection.find(x => x._userType === 'bim_model_geomviews');

    // create the versions

    const model_els_coll_ver = await PlatformApi
        .IafScriptEngine
        .createNamedUserItemVersion({
            "namedUserItemId": model_els_coll._userItemId
        }, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version model_els_coll"}));
    const model_els_props_coll_ver = await PlatformApi
        .IafScriptEngine
        .createNamedUserItemVersion({
            "namedUserItemId": model_els_props_coll._userItemId
        }, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version model_els_props_coll"}));
    const model_type_el_coll_ver = await PlatformApi
        .IafScriptEngine
        .createNamedUserItemVersion({
            "namedUserItemId": model_type_el_coll._userItemId
        }, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version model_type_el_coll"}));
    const model_geom_file_coll_ver = await PlatformApi
        .IafScriptEngine
        .createNamedUserItemVersion({
            "namedUserItemId": model_geom_file_coll._userItemId
        }, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version model_geom_file_coll"}));
    const model_geom_views_coll_ver = await PlatformApi
        .IafScriptEngine
        .createNamedUserItemVersion({
            "namedUserItemId": model_geom_views_coll._userItemId
        }, ctx);
            console.log(JSON.stringify({"message":"Create BIM Collection Version model_geom_views_coll"}));

    // set them in global variables
    PlatformApi
        .IafScriptEngine.setVar("model_els_coll", model_els_coll);
    PlatformApi
        .IafScriptEngine.setVar("model_els_props_coll", model_els_props_coll);
    PlatformApi
        .IafScriptEngine.setVar("model_type_el_coll", model_type_el_coll);
    PlatformApi
        .IafScriptEngine.setVar("model_geom_file_coll", model_geom_file_coll);
    PlatformApi
        .IafScriptEngine.setVar("model_geom_views_coll", model_geom_views_coll);

    let _myCollections = {
        "model_els_coll": model_els_coll,
        "model_els_props_coll": model_els_props_coll,
        "model_type_el_coll": model_type_el_coll,
        "model_geom_file_coll": model_geom_file_coll,
        "model_geom_views_coll": model_geom_views_coll

    };
    return await createRelatedItemsAndRelationships(_myCollections, PlatformApi, ctx);

}

const createRelatedItemsAndRelationships = async (_colls, PlatformApi, ctx) => {
    console.log(JSON.stringify({"message":"Creating Model Relations and Related Items"}));
    await PlatformApi
        .IafScriptEngine.addRelatedCollections({
            "namedCompositeItemId": PlatformApi
                .IafScriptEngine.getVar("bim_model")._id,
            "relatedCollections": [
                _colls.model_els_coll._userItemId,
                _colls.model_els_props_coll._userItemId,
                _colls.model_type_el_coll._userItemId,
                _colls.model_geom_file_coll._userItemId,
                _colls.model_geom_views_coll._userItemId
            ]
        }, ctx);
         console.log("Create Related Collection");
    const bim_els = await PlatformApi
        .IafScriptEngine.createItemsBulk({
            "_userItemId": _colls.model_els_coll._userItemId,
            "_namespaces": ctx._namespaces,
            "items": PlatformApi
                .IafScriptEngine.getVar("manage_els")
        }, ctx);
        console.log("Create Related Collection manage_els");
        
    const type_els = await PlatformApi
        .IafScriptEngine.createItemsBulk({
            "_userItemId": _colls.model_type_el_coll._userItemId,
            "_namespaces": ctx._namespaces,
            "items": PlatformApi
                .IafScriptEngine.getVar("manage_type_els")

        }, ctx);
        console.log("Create Related Collection manage_type_els");
    await PlatformApi
        .IafScriptEngine.createItemsAsRelatedBulk({
            "parentUserItemId": _colls.model_els_coll._userItemId,
            "_userItemId": _colls.model_els_props_coll._userItemId,
            "_namespaces": ctx._namespaces,
            "items": PlatformApi
                .IafScriptEngine.getVar("properties")

        },ctx);
        console.log("Create Related Collection properties");
    const el_to_type_relations = await PlatformApi
        .IafScriptEngine.createRelations({
            "parentUserItemId": _colls.model_els_coll._userItemId,
            "_userItemId": _colls.model_type_el_coll._userItemId,
            "_namespaces": ctx._namespaces,
            "relations": PlatformApi
                .IafScriptEngine.getVar("manage_el_to_type_relations")

        },ctx);
        console.log("Create Related Collection Relations");
    await PlatformApi
        .IafScriptEngine.setVar("outparams", {
            "filecolid": _colls.model_geom_file_coll._userItemId,
            "viewcolid": _colls.model_geom_views_coll._userItemId,
            "compositeitemid": PlatformApi
                .IafScriptEngine.getVar("bim_model")._id

        });
    return true;
}


const extractBimpk = async (param, PlatformApi, ctx) => {
    console.log("extractBimpk running...");
    try {
        //

        // Extract data 
        let _objectsArray = {
            "objects": [],
            "properties": [],
            "types": []
        }
        param.files.forEach((file) => {
            file.occurences.forEach((occ) => {
                occ.objects.objects.forEach((obj) => {
                    let _myObj = {
                        "package_id": obj.id,
                        "type_id": obj.type,
                        "relationships": obj.relationships,
                        "source_id": obj.sourceId,
                        "properties": obj.properties,
                        "source_filename":file.name
                    }
                    
                    _objectsArray.objects.push(_myObj);

                });
                occ.objects.properties.forEach((prop) => {
                    _objectsArray.properties.push(prop);
                })

                occ.objects.types.forEach((type) => {
                    let _type = {
                        "id": type.id,
                        "name": type.name,
                        "source_id": type.sourceId,
                        "properties": type.properties

                    }
                    console.log("extractBimpk _type: ", JSON.stringify(_type));
                    _objectsArray.types.push(_type);
                });
                console.log("Data Extraction is complete, _objectsArray:", JSON.stringify(_objectsArray));
            });

        });
        
        // Data Extraction Completed
        //--------------------------------
        // load the typemap
        let assetTypeMap = null
        try {
            assetTypeMap = await PlatformApi
                .IafScriptEngine.getItems({
                    "collectionDesc": {
                        "_userType": "iaf_dt_type_map_defs_coll",
                        "_namespaces": PlatformApi
                            .IafScriptEngine.getVar("namespaces")
                    },
                    "options": {
                        "page": {
                            "getAllItems": true
                        }
                    }
                }, ctx);
            console.log("extractBimpk assetTypeMap:", JSON.stringify(assetTypeMap));
        } catch (err) {
            console.log('{"level": "info", "message": "Type Map collection does not exist"}')
        }
            
        for (let type of _objectsArray.types) {
            for (let prop of type.properties) {
                let _myProp = _objectsArray.properties.find(x => x.id == prop.id);
                prop.dName = _myProp.dName;
                if (_myProp.hasOwnProperty("Asset Category")) {
                    console.log("_myProp.hasOwnProperty true")
                    prop.baType = _myProp["Asset Category"]
                } else {
                    console.log("_myProp.hasOwnProperty false")
                }

            }
            type._id = await PlatformApi
                .IafScriptEngine.newID("mongo", {
                    "format": "hex"
                });
            type.properties = groupBy(type.properties, "dName");
            if (assetTypeMap && type.properties.hasOwnProperty("Revit Family") && type.properties.hasOwnProperty("Revit Type")) {
                let _myRow = assetTypeMap.find(x => x["Revit Family"] == type.properties["Revit Family"].val && x["Revit Type"] == type.properties["Revit Type"].val);
                if (_myRow) {
                    type.ElementCategory = _myRow.ElementCategory;
                    type.ElementType = _myRow.ElementType;
                }
            };
        };
        console.log(JSON.stringify({"message":"Type Extraction is complete"}));
        console.log("Type Extraction updated types:", JSON.stringify(_objectsArray.types));
        // do the same for properties in the object
        for (let obj of _objectsArray.objects) {
            obj.properties.forEach((prop) => {
                let _myProp = _objectsArray.properties.find(x => x.id == prop.id);
                prop.dName = _myProp.dName;

            });

            obj._id = await PlatformApi
                .IafScriptEngine.newID("mongo", {
                    "format": "hex"
                });
            obj.properties = groupBy(obj.properties, "dName");
            let _myVal = _objectsArray.types.find(x => x.id == obj.type_id);
            obj.ElementCategory = _myVal.ElementCategory;
            obj.ElementType = _myVal.ElementType;
            if (_myVal.hasOwnProperty("baType")) {
                obj.baType = _myVal.baType;
            }

        };
        console.log(JSON.stringify({"message":"Property Extraction is complete"}));
        console.log("Property Extraction updated objects:", JSON.stringify(_objectsArray.objects));
        let _myProperties =[];
        _objectsArray.objects.forEach((object) =>{
            let _myProp = {
                _id:object._id,
                properties:object.properties
            }
            _myProperties.push(_myProp);

        });
        console.log("Property Extraction _myProperties:", JSON.stringify(_myProperties));
        await PlatformApi.IafScriptEngine.setVar("properties", _myProperties);
        _objectsArray.objects.forEach(e => { delete e.properties });
        await PlatformApi.IafScriptEngine.setVar("manage_els", _objectsArray.objects);
        await PlatformApi.IafScriptEngine.setVar("manage_type_els", _objectsArray.types);
        await PlatformApi.IafScriptEngine.setVar("manage_el_to_type_relations", 
            _mapItemsAsRelated(PlatformApi.IafScriptEngine.getVar("manage_els"),
                PlatformApi.IafScriptEngine.getVar("manage_type_els"), "type_id", "id"));
    } catch (err) {
        console.log(err);
    }
}


export default {
    async uploadBimpk(params, PlatformApi, ctx) {

        let param = params.inparams;
        console.log("param",param)
        // set global variables first
        await PlatformApi
            .IafScriptEngine.setVar("namespaces", ctx._namespaces);
        await PlatformApi
            .IafScriptEngine.setVar("package_name", param.filename);
        await PlatformApi
            .IafScriptEngine.setVar("package_name_short", param.filename.substring(0, 11));
        let bim_model = await PlatformApi.IafScriptEngine.getCompositeCollection(
                {
                    "_userType": "bim_model_version",
                    "_versions._userAttributes.bimpk.fileId": param._fileId
                },ctx, {});
              //  console.log("PlatformApi",PlatformApi)

        // let res = await PlatformApi.IafItemSvc.getNamedUserItems({"query":{
        //     "_userType": "bim_model_version",
        //     "_versions._userAttributes.bimpk.fileId": param._fileId,
        //     "_itemClass":"NamedCompositeItem"
        // }},ctx,{});
        // let bim_model = res._list[0];
        console.log(JSON.stringify({"message": "model -> "+JSON.stringify(bim_model)}));
        if (bim_model) {
            PlatformApi
                .IafScriptEngine.setVar("bim_model", bim_model);
            await extractBimpk(param, PlatformApi, ctx);
            await createBIMCollectionVersion(param, PlatformApi, ctx);

        } else {
            await extractBimpk(param, PlatformApi, ctx);
            await createBIMCollections(param, PlatformApi, ctx);

        }
        

        return PlatformApi
            .IafScriptEngine.getVar("outparams");


    }
}