
const isEmpty = (ele) => {
  if (ele === undefined) {
    return true;
  } else if (ele === null) {
    return true;
  }
  return false;
};

const getRelatedFilesContainer = async (project, P_API, context) => {
  let containers = await P_API.IafFile.getContainers(
    project,
    { _name: "Related Files" },
    context
  );
  if (containers === null) {
    let containerInfo = {
      _name: "Related Files",
      _description: "Folder to store related files for model elements.",
      _shortName: "related_files",
      _userType: "file_container",
    };
    let rootContainer = await P_API.IafFile.getRootContainer(project, context);
    if (isEmpty(rootContainer)) {
      rootContainer = await P_API.IafFile.createContainer(
        { _namespaces: project._namespaces },
        undefined,
        context
      );
    }
    let newContainer = await P_API.IafFile.createContainer(
      rootContainer,
      containerInfo,
      context
    );
    return newContainer;
  }
  return containers[0];
};

let modeleleme = {
  async getModelElements(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );

    let bimQuery = {
      parent: {
        query: input.entityInfo,
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        options: {
          page: {
            getAllItems: true,
          },
        },
        sort: {
          _id: 1,
        },
      },
      related: [
        {
          relatedDesc: {
            _relatedUserType: "rvt_type_elements",
          },
          as: "Revit Type Properties",
        },
        {
          relatedDesc: {
            _relatedUserType: "rvt_element_props",
          },
          as: "Revit Element Properties",
        },
      ],
    };
    let elements = await PlatformApi.IafScriptEngine.findWithRelated(
      bimQuery,
      ctx
    );
    let entities = elements._list.map((e) => {
      let properties = {};
      if (!_.isEmpty(e["Revit Type Properties"]._list[0])) {
        Object.keys(e["Revit Type Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Type Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      if (!_.isEmpty(e["Revit Element Properties"]._list[0])) {
        Object.keys(e["Revit Element Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Element Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      let revitFamily = e["Revit Type Properties"]._list[0].properties[
        "Revit Family"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Family"].val
        : "No Family";
      let revitType = e["Revit Type Properties"]._list[0].properties[
        "Revit Type"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Type"].val
        : "No Type";
      let sysElemId =
        e["Revit Element Properties"]._list[0].properties.SystemelementId.val;
      return {
        _id: e._id,
        "Entity Name": revitFamily + "-" + revitType + "-" + sysElemId,
        properties,
        modelViewerIds: [e.package_id],
      };
    });
    return entities;
  },
  async getElementFromModel(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );

    let bimQuery = {
      parent: {
        query: {
          package_id: input.modelInfo.id,
        },
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        options: {
          page: {
            getAllItems: true,
          },
        },
        sort: {
          _id: 1,
        },
      },
      related: [
        {
          relatedDesc: {
            _relatedUserType: "rvt_type_elements",
          },
          as: "Revit Type Properties",
        },
        {
          relatedDesc: {
            _relatedUserType: "rvt_element_props",
          },
          as: "Revit Element Properties",
        },
      ],
    };
    let elements = await PlatformApi.IafScriptEngine.findWithRelated(
      bimQuery,
      ctx
    );
    console.log("getElementFromModel elements", elements);
    let entities = elements._list.map((e) => {
      let properties = {};
      if (!_.isEmpty(e["Revit Type Properties"]._list[0])) {
        Object.keys(e["Revit Type Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Type Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      if (!_.isEmpty(e["Revit Element Properties"]._list[0])) {
        Object.keys(e["Revit Element Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Element Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      let revitFamily = e["Revit Type Properties"]._list[0].properties[
        "Revit Family"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Family"].val
        : "No Family";
      let revitType = e["Revit Type Properties"]._list[0].properties[
        "Revit Type"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Type"].val
        : "No Type";
      let sysElemId =
        e["Revit Element Properties"]._list[0].properties.SystemelementId.val;
      return {
        _id: e._id,
        "Entity Name": revitFamily + "-" + revitType + "-" + sysElemId,
        properties,
        modelViewerIds: [e.package_id],
      };
    });
    return entities[0];
  },
  async getModelElementsByCatAndType(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let bimQuery;
    if (input.entityInfo.ElementCategory[0]) {
      bimQuery = {
        parent: {
          query: {
            ElementCategory: input.entityInfo.ElementCategory[0],
            ElementType: {
              $in: input.entityInfo.ElementType,
            },
          },
          collectionDesc: {
            _userType: "rvt_elements",
            _userItemId: iaf_ext_elements_collection._userItemId,
          },
          options: {
            page: {
              getAllItems: true,
            },
          },
          sort: {
            _id: 1,
          },
        },
        related: [
          {
            relatedDesc: {
              _relatedUserType: "rvt_type_elements",
            },
            as: "Revit Type Properties",
          },
          {
            relatedDesc: {
              _relatedUserType: "rvt_element_props",
            },
            as: "Revit Element Properties",
          },
        ],
      };
    } else {
      bimQuery = {
        parent: {
          query: {
            ElementCategory: input.entityInfo.ElementCategory[0],
          },
          collectionDesc: {
            _userType: "rvt_elements",
            _userItemId: iaf_ext_elements_collection._userItemId,
          },
          options: {
            page: {
              getAllItems: true,
            },
          },
          sort: {
            _id: 1,
          },
        },
        related: [
          {
            relatedDesc: {
              _relatedUserType: "rvt_type_elements",
            },
            as: "Revit Type Properties",
          },
          {
            relatedDesc: {
              _relatedUserType: "rvt_element_props",
            },
            as: "Revit Element Properties",
          },
        ],
      };
    }
    let elements = await PlatformApi.IafScriptEngine.findWithRelated(
      bimQuery,
      ctx
    );
    console.log("getModelElementsByCatAndType elements", elements);
    let entities = elements._list.map((e) => {
      let properties = {};
      if (!_.isEmpty(e["Revit Type Properties"]._list[0])) {
        Object.keys(e["Revit Type Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Type Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      if (!_.isEmpty(e["Revit Element Properties"]._list[0])) {
        Object.keys(e["Revit Element Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Element Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      let revitFamily = e["Revit Type Properties"]._list[0].properties[
        "Revit Family"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Family"].val
        : "No Family";
      let revitType = e["Revit Type Properties"]._list[0].properties[
        "Revit Type"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Type"].val
        : "No Type";
      let sysElemId =
        e["Revit Element Properties"]._list[0].properties.SystemelementId.val;
      return {
        _id: e._id,
        "Entity Name": revitFamily + "-" + revitType + "-" + sysElemId,
        properties,
        modelViewerIds: [e.package_id],
      };
    });
    return entities;
  },
  async getModelElementsBySourceFile(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let bimQuery = {
      parent: {
        query: {
          source_filename: {
            $in: input.entityInfo["Source Files"],
          },
        },
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        options: {
          page: {
            getAllItems: true,
          },
        },
        sort: {
          _id: 1,
        },
      },
      related: [
        {
          relatedDesc: {
            _relatedUserType: "rvt_type_elements",
          },
          as: "Revit Type Properties",
        },
        {
          relatedDesc: {
            _relatedUserType: "rvt_element_props",
          },
          as: "Revit Element Properties",
        },
      ],
    };
    let elements = await PlatformApi.IafScriptEngine.findWithRelated(
      bimQuery,
      ctx
    );
    console.log("getModelElementsBySourceFile elements", elements);
    let entities = elements._list.map((e) => {
      let properties = {};
      if (!_.isEmpty(e["Revit Type Properties"]._list[0])) {
        Object.keys(e["Revit Type Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Type Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      if (!_.isEmpty(e["Revit Element Properties"]._list[0])) {
        Object.keys(e["Revit Element Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Element Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      let revitFamily = e["Revit Type Properties"]._list[0]
        ? e["Revit Type Properties"]._list[0].properties["Revit Family"]
          ? e["Revit Type Properties"]._list[0].properties["Revit Family"].val
          : "No Family"
        : "No Family";
      let revitType = e["Revit Type Properties"]._list[0]
        ? e["Revit Type Properties"]._list[0].properties["Revit Type"]
          ? e["Revit Type Properties"]._list[0].properties["Revit Type"].val
          : "No Type"
        : "No Type";
      let sysElemId = e["Revit Element Properties"]._list[0]
        ? e["Revit Element Properties"]._list[0].properties.SystemelementId.val
        : "";
      return {
        _id: e._id,
        "Entity Name": revitFamily + "-" + revitType + "-" + sysElemId,
        properties,
        modelViewerIds: [e.package_id],
      };
    });
    console.log("getModelElementsBySourceFile entities", entities);
    return entities;
  },
  async getModelElementsByTypeProps(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_current_bim_model = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_current_bim_model"
    );
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let type_elements_coll =
      await PlatformApi.IafScriptEngine.getCollectionInComposite(
        iaf_ext_current_bim_model._userItemId,
        {
          _userType: "rvt_type_elements",
        },
        ctx
      );
    let bimQuery;
    if (input.entityInfo["ElementCategory"]) {
      bimQuery = {
        query: {
          parent: {
            query: {
              ElementType: input.entityInfo["ElementType"][0],
              ElementCategory: input.entityInfo["ElementCategory"][0],
            },
            collectionDesc: {
              _userType: type_elements_coll._userType,
              _userItemId: type_elements_coll._userItemId,
            },
            options: {
              page: {
                getAllItems: true,
              },
              project: {
                _id: 1,
              },
            },
          },
          related: [
            {
              relatedDesc: {
                _isInverse: true,
                _relatedUserType: "rvt_elements",
                _relatedUserItemVersionId:
                  iaf_ext_elements_collection._userItemVersionId,
              },
              options: {
                project: {
                  _id: 1,
                },
              },
              as: "revitElements",
            },
          ],
        },
      };
    } else {
      bimQuery = {
        query: {
          parent: {
            query: {
              ElementType: input.entityInfo["ElementType"][0],
            },
            collectionDesc: {
              _userType: type_elements_coll._userType,
              _userItemId: type_elements_coll._userItemId,
            },
            options: {
              page: {
                getAllItems: true,
              },
              project: {
                _id: 1,
              },
            },
          },
          related: [
            {
              relatedDesc: {
                _isInverse: true,
                _relatedUserType: "rvt_elements",
                _relatedUserItemVersionId:
                  iaf_ext_elements_collection._userItemVersionId,
              },
              options: {
                project: {
                  _id: 1,
                },
              },
              as: "revitElements",
            },
          ],
        },
      };
    }
    let fetchedTypeElems = await PlatformApi.IafScriptEngine.findWithRelated(
      bimQuery.query,
      ctx
    );

    const fetchedIds = fetchedTypeElems._list.flatMap(item => 
      item.revitElements._list.map(element => element._id)
    );
    console.log("fetchedIds", fetchedIds);

    const elemQuery = {
      parent: {
        query: {
          _id: {
            $in: fetchedIds
          },
        },
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        options: {
          page: {
            _pageSize: 200,
          },
        },
        sort: {
          _id: 1,
        },
      },
      related: [
        {
          relatedDesc: {
            _relatedUserType: "rvt_type_elements",
          },
          as: "Revit Type Properties",
        },
        {
          relatedDesc: {
            _relatedUserType: "rvt_element_props",
          },
          as: "Revit Element Properties",
        },
      ],
    }

    let elements;
    await PlatformApi.IafScriptEngine.findWithRelated(elemQuery, ctx).then((res) => {
      elements = res._list;
    })
    
    let entities = elements.map((e) => {
      let properties = {};
      if (!_.isEmpty(e["Revit Type Properties"]._list[0])) {
        Object.keys(e["Revit Type Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Type Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      if (!_.isEmpty(e["Revit Element Properties"]._list[0])) {
        Object.keys(e["Revit Element Properties"]._list[0].properties).forEach(
          (key) => {
            let currentProp =
              e["Revit Element Properties"]._list[0].properties[key];
            properties[key] = {
              dName: currentProp.dName,
              val: currentProp.val
                ? currentProp.val
                : "" + " " + currentProp.uom
                ? currentProp.uom
                : "",
              type: "text",
            };
          }
        );
      }
      let elementCategory = e["Revit Type Properties"]._list[0].ElementCategory;
      let elementType = e["Revit Type Properties"]._list[0].ElementType;
      let revitFamily = e["Revit Type Properties"]._list[0].properties[
        "Revit Family"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Family"].val //Check for revit family in properties
        : e["Revit Type Properties"]._list[0].properties["ElementType"] //Check for Element type for ifc model in properties
        ? e["Revit Type Properties"]._list[0].properties["ElementType"].val
        : "No Family";

      let revitType = e["Revit Type Properties"]._list[0].properties[
        "Revit Type"
      ]
        ? e["Revit Type Properties"]._list[0].properties["Revit Type"].val //Check for revit type in properties
        : e["Revit Type Properties"]._list[0].properties["Name"] //Check for name for ifc model in properties
        ? e["Revit Type Properties"]._list[0].properties["Name"].val
        : "No Type";

      let sysElemId = e["Revit Element Properties"]._list[0].properties
        .SystemelementId
        ? e["Revit Element Properties"]._list[0].properties.SystemelementId.val
        : "No Id";
      let modelViewerIds = properties.IFCTypeObject
        ? [e.source_id]
        : [e.package_id];
      properties["ElementCategory"] = {
        "dName": "ElementCategory",
        "val": elementCategory,
        "type": "text"
      };
      properties["ElementType"] = {
        "dName": "ElementType",
        "val": elementType,
        "type": "text"
      }; 
      return {
        _id: e._id,
        "Entity Name": revitFamily + "-" + revitType + "-" + sysElemId,
        ElementCategory: elementCategory,
        ElementType: elementType,
        properties,
        modelViewerIds,
      };
    });
    return entities;
  },
  async getModelRevitDtTypesForDtCategory(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let distinctTypes = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: iaf_ext_elements_collection._userType,
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        field: "ElementType",
        query: { ElementCategory: input.input.ElementCategory },
      },
      ctx
    );
    console.log("distinctTypes", distinctTypes);
    distinctTypes = _.sortBy(distinctTypes, (type) => type);
    return distinctTypes;
  },
  async getModelRevitDtCategories(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let distinctCats = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: iaf_ext_elements_collection._userType,
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        field: "ElementCategory",
      },
      ctx
    );
    console.log("distinctCats", distinctCats);
    distinctCats = _.sortBy(distinctCats, (type) => type);
    return distinctCats;
  },
  async getTypesOfElementForCategory(input, libraries, ctx, callback) {
    const { PlatformApi } = libraries;
    let iaf_ext_current_bim_model = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_current_bim_model"
    );
    let type_elements_coll =
      await PlatformApi.IafScriptEngine.getCollectionInComposite(
        iaf_ext_current_bim_model._userItemId,
        {
          _userType: "iaf_ref_type_map_defs_coll",
        },
        ctx
      );
    let distinctRevitTypes = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: type_elements_coll._userType,
          _userItemId: type_elements_coll._userItemId,
        },
        field: "ElementCategory",

        query: {},
      },
      ctx
    );
    console.log("distinctRevitTypes", distinctRevitTypes);
    distinctRevitTypes = _.sortBy(distinctRevitTypes, (type) => type);
    return distinctRevitTypes;
  },
  async getModelElementType(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_current_bim_model = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_current_bim_model"
    );
    let type_elements_coll =
      await PlatformApi.IafScriptEngine.getCollectionInComposite(
        iaf_ext_current_bim_model._userItemId,
        {
          _userType: "rvt_type_elements",
        },
        ctx
      );
    console.log("type_elements_coll", type_elements_coll);
    const distinctQuery = {
      collectionDesc: {
        _userType: type_elements_coll._userType,
        _userItemId: type_elements_coll._userItemId,
      },
      field: "ElementType",
      query: { ElementCategory: input.input.ElementCategory },
    };
    console.log("distinctQuery", distinctQuery);
    let distinctRevitFams = await PlatformApi.IafScriptEngine.getDistinct(
      distinctQuery,
      ctx
    );
    console.log("distinctRevitFams", distinctRevitFams);
    distinctRevitFams = _.sortBy(distinctRevitFams, (type) => type);
    return distinctRevitFams;
  },
  async getModelElementCategory(input, libraries, ctx, callback) {
    const { PlatformApi } = libraries;
    let iaf_ext_current_bim_model = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_current_bim_model"
    );
    if (iaf_ext_current_bim_model) {
      let type_elements_coll =
        await PlatformApi.IafScriptEngine.getCollectionInComposite(
          iaf_ext_current_bim_model._userItemId,
          {
            _userType: "rvt_type_elements",
          },
          ctx
        );
      console.log("type_elements_coll", type_elements_coll);
      const distinctQuery = {
        collectionDesc: {
          _userType: type_elements_coll._userType,
          _userItemId: type_elements_coll._userItemId,
        },
        field: "ElementCategory",
        query: {}
      };
      console.log("distinctQuery", distinctQuery);
      let distinctCategories = await PlatformApi.IafScriptEngine.getDistinct(
        distinctQuery,
        ctx
      );

      console.log("distinctCategories", distinctCategories);
      distinctCategories = _.sortBy(distinctCategories, (type) => type);
      return distinctCategories;
    }
  },
  async getRevitSourceFiles(input, libraries, ctx, callback) {
    console.log("input", input);
    const { PlatformApi } = libraries;
    let iaf_ext_elements_collection = PlatformApi.IafScriptEngine.getVar(
      "iaf_ext_elements_collection"
    );
    let distinctSourceFiles = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: iaf_ext_elements_collection._userType,
          _userItemId: iaf_ext_elements_collection._userItemId,
        },
        field: "source_filename",
      },
      ctx
    );
    console.log("distinctSourceFiles", distinctSourceFiles);
    let selects = {
      "Source Files": _.sortBy(distinctSourceFiles, (type) => type),
    };
    return selects;
  },
  async getElementsWarrantyData(input, libraries, ctx, callback) {
    let { PlatformApi } = libraries;
    try {
      let type_coll = PlatformApi.IafScriptEngine.getVar(
        "iaf_ext_elements_collection"
      );
      let warranty_collection = PlatformApi.IafScriptEngine.getVar(
        "iaf_dt_warranty_coll"
      );
      const testAsset = await PlatformApi.IafScriptEngine.findWithRelated(
        {
          parent: {
            query: { _id: input.entityInfo._id },
            collectionDesc: { _userItemId: type_coll._userItemId },
            options: { page: { getAllItems: true } },
          },
          related: [
            {
              relatedDesc: { _relatedUserType: "iaf_dt_warranty_coll" },
              as: "extendedData",
            },
          ],
        },
        ctx
      );
      let tableDataWithHeader = [];
      if (testAsset._list.length > 0) {
        {
          testAsset._list[0].extendedData._list[0]
            ? tableDataWithHeader.push(
                testAsset._list[0].extendedData._list[0].properties
              )
            : tableDataWithHeader.push(undefined);
        }
        tableDataWithHeader.push({
          userItemID: warranty_collection._userItemId,
        });
        if (testAsset._list[0].extendedData._list[0]) {
          let inputId = {
            RelatedItemID: testAsset._list[0].extendedData._list[0]._id,
          };
          tableDataWithHeader.push(inputId);
        }
        if (testAsset._list[0].extendedData._list[0] === undefined) {
          let inputId = {
            RelatedItemID: undefined,
          };
          tableDataWithHeader.push(inputId);
        }
        tableDataWithHeader.push({
          typeCollectionId: type_coll._userItemId,
        });
        tableDataWithHeader.push({
          parentId: testAsset._list[0]._id,
        });
      }
      return tableDataWithHeader;
    } catch (error) {
      console.log(error);
      return error;
    }
  },
  async getCategoriesWithCount(input, libraries, ctx) {
    let { PlatformApi } = libraries;
    let iaf_asset_collection = await PlatformApi.IafScriptEngine.getVar(
      "iaf_ref_type_map_defs_coll"
    );
    let distinctCats = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: iaf_asset_collection._userType,
          _id: iaf_asset_collection._id,
        },
        field: "ElementCategory",
        query: {},
      },
      ctx
    );
    //check this
    distinctCats = _.sortBy(distinctCats, (cat) => cat._id);
    let distinctCatWithTypeCountQuery = distinctCats.map((cat) => {
      return {
        _userItemId: iaf_asset_collection._id,
        query: { ElementCategory: cat },
        options: { page: { _pageSize: 0, getPageInfo: true } },
      };
    });
    let catsPageInfo = await PlatformApi.IafScriptEngine.getItemsMulti(
      distinctCatWithTypeCountQuery,
      ctx
    );
    let distinctCatsWithPageInfo = _.zip(distinctCats, catsPageInfo);
    let distinctCatsWithTypeCount = distinctCatsWithPageInfo.map(
      (catWithPage) => {
        return {
          name: catWithPage[0],
          childCount: catWithPage[1]._total,
        };
      }
    );
    return distinctCatsWithTypeCount;
  },
  async getDtTypesWithChildrenCount(input, libraries, ctx, callback) {
    console.log("input", input);
    let { PlatformApi } = libraries;
    let iaf_asset_collection = await PlatformApi.IafScriptEngine.getVar(
      "iaf_asset_collection"
    );
    let distinctTypes = await PlatformApi.IafScriptEngine.getDistinct(
      {
        collectionDesc: {
          _userType: iaf_asset_collection._userType,
          _id: iaf_asset_collection._id,
        },
        field: "ElementCategory",
        query: { ElementCategory: input.input.ElementCategory },
      },
      ctx
    );
    console.log("distinctTypes", distinctTypes);
    let distinctTypestWithChildCountQuery = distinctTypes.map((type) => {
      return {
        _userItemId: iaf_asset_collection._id,
        query: {
          ElementCategory: input.input.ElementCategory,
          ElementCategory: type,
        },
        options: { page: { _pageSize: 0, getPageInfo: true } },
      };
    });
    console.log(
      "distinctTypestWithChildCountQuery",
      distinctTypestWithChildCountQuery
    );
    let typesPageInfo = await PlatformApi.IafScriptEngine.getItemsMulti(
      distinctTypestWithChildCountQuery,
      ctx
    );

    console.log("typesPageInfo", typesPageInfo);
    let distinctTypesWithPageInfo = _.zip(distinctTypes, typesPageInfo);
    console.log("distinctTypesWithPageInfo", distinctTypesWithPageInfo);

    let distinctTypesWithChildrenCount = distinctTypesWithPageInfo.map(
      (typeWithpage) => {
        return {
          name: typeWithpage[0],
          childCount: typeWithpage[1]._total,
        };
      }
    );
    console.log(
      "distinctTypesWithChildrenCount",
      distinctTypesWithChildrenCount
    );
    return distinctTypesWithChildrenCount;
  },
  async getRelatedFileItemsForModelElements(input, libraries, context) {
    try {
      const P_API = libraries.PlatformApi;
      let project = await P_API.IafProj.getCurrent();
      if (!context) {
        context = { _namespaces: project._namespaces };
      }
      const container = await getRelatedFilesContainer(project, P_API, context);
      const relations = await P_API.IafItemSvc.getRelations(
        container._id,
        {
          query: { _relatedToIds: { $in: [input.entityInfo._id] }},
          options: { page: { getAllItems: true } },
        },
        context
      );
      console.log('relations: ', relations)
      let result = [];
      function formatBytes(bytes, decimals = 2) {
        if (bytes === 0) return "0 Bytes";

        const k = 1024;
        const dm = decimals < 0 ? 0 : decimals;
        const sizes = ["Bytes", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB"];
        const i = Math.floor(Math.log(bytes) / Math.log(k));

        return (
          parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + " " + sizes[i]
        );
      }
      for (let i = 0; i < relations._list.length; i++) {
        const rel = relations._list[i];
        const fileId = rel._relatedFromId;
        const f = await P_API.IafFile.getFileItem(
          container,
          { _id: fileId },
          context
        );
        console.log('file item: ', f)
        const user = await P_API.IafPassSvc.getUserById(
          f._metadata._updatedById,
          context
        );
        console.log('user: ', user)
        const fileData = {
          name: f.name,
          updatedAt: new Date(f._metadata._updatedAt).toDateString(),
          updatedBy: `${user._firstname} ${user._lastname}`,
          size:
          f.versions[0].fileSize !== undefined
              ? formatBytes(f.versions[0].fileSize)
              : 0,
          fileId: fileId,
          id: f._fileId,
          relatedFromId: input.entityInfo._id,  //change to relatedTo?
        }
        console.log('fileData: ', fileData)
        result.push(fileData);
      }
      console.log('result', result)
      if (!result.length) {
        return [{ name: "temp data", is_temp: true }];
      }
      console.log('result', result)
      return result;
    } catch (error) {
      return { error: error.message };
    }
  },
  async getTelemetryCollection(input, libraries, context) {
    try {
      const { PlatformApi } = libraries; 
      const model = PlatformApi.IafScriptEngine.getVar(
        'iaf_ext_current_bim_model'
      )
      console.log('iaf_ext_current_bim_model', model)
      const IafItemSvc = PlatformApi.IafItemSvc;
      let query = {
        _userType: "ref_app_telementary_collection",
        _name: `${model._name} Telemetry Collection`,
      };
      let telemColl = await IafItemSvc.getNamedUserItems(
        {query},
        context,
        undefined
      );
      telemColl = telemColl._list[0]
      console.log('Telemetry Collection', telemColl)
      let selectedElementId = input.entityInfo._id;
      let collectionId = telemColl._id
      return { collectionId, selectedElementId };
    } catch (error) {
      return { error: JSON.stringify(error) };
    }
  },
  async getIotCollection(input, libraries, context) {
    try {
      const { PlatformApi } = libraries; 
      const model = PlatformApi.IafScriptEngine.getVar(
        'iaf_ext_current_bim_model'
      )
      console.log('iaf_ext_current_bim_model', model)
      const IafItemSvc = PlatformApi.IafItemSvc;
      let queryIot = {
        _userType: "ref_app_iot_collection",
        _name: `${model._name} Telemetry Collection`,
      };
      let iotColl = await IafItemSvc.getNamedUserItems(
        {queryIot},
        context,
        undefined
      );
      console.log('iotColl: ', iotColl)
      iotColl = iotColl._list[0]
      let collectionIdIot = iotColl._id;
      let selectedElementId = input.entityInfo._id;
      return { collectionIdIot, selectedElementId };
    } catch (error) {
      return { error: JSON.stringify(error) };
    }
  },

  async uploadRelatedFileItem(input, libraries, context) {
    console.log("running uploadRelatedFileItem", input);
    try {
      if (
        Array.isArray(input.entityInfo.new) &&
        input.entityInfo.new.length === 0
      ) {
        return;
      }
      const P_API = libraries.PlatformApi;
      let project = await P_API.IafProj.getCurrent();
      if (!context) {
        context = { _namespaces: project._namespaces };
      }
      const configFile = await libraries.UiUtils.IafLocalFile.selectFiles({
        multiple: false,
        accept:
          ".csv, .jpg, .png, .gif, .pdf, .doc, .docx, .rtf, .xls, .xlsx, .ppt, .pptx, .txt",
      });
      if (configFile.length > 0) {
        const container = await getRelatedFilesContainer(
          project,
          P_API,
          context
        );
        const file = await P_API.IafFile.uploadFile(
          container,
          configFile[0].fileObj,
          ["related"],
          context
        );
        console.log('file: ', file)
        let entities = input.entityInfo.new;

        // Ensure entities is always an array
        if (!Array.isArray(entities)) {
          entities = [entities];
        }
        const entitiesIds = entities.map(e => e._id);
        const elemsColl = P_API.IafScriptEngine.getVar(
          'iaf_ext_elements_collection'
        )
        console.log('elemsColl: ', elemsColl)
        const relationShip = [{
          _relatedFromId: file._id,
          _relatedToIds: [...entitiesIds],
          _relatedUserItemDbId: elemsColl._itemId,
        }];
        console.log('relationShip: ', relationShip)
        const relations = await P_API.IafItemSvc.addRelations(
          container._id,
          relationShip,
          context
        );

        console.log('relations: ', relations)

        let actions = document.getElementsByClassName(
          "entity-data-groups-selector"
        )[0]?.childNodes;
        if (actions){
        let childrens = Array.from(actions);
        let fileElem = childrens.find((f) => {
          let item = Array.from(f.children);
          let label = item.find((l) => l.tagName == "LABEL");
          return label.innerText === "Files";
        });
        console.log(" ~ file: Untitled-1:9 ~ fileElem ~ fileElem", fileElem);

        if (fileElem) {
          let fileInput = Array.from(fileElem.children).find(
            (f) => f.tagName == "INPUT"
          );
          if (fileInput.checked) {
            fileInput.click();
            fileInput.click();
          } else {
            fileInput.click();
          }
        }
        }

        // Artifical click of files tab from navigator
        let bottomTabs = document.getElementsByClassName(
          "bottom-panel-content-left"
        )[0]?.childNodes;
        if(bottomTabs){
          let bottomTabsArr = Array.from(bottomTabs);
          let fileTab = bottomTabsArr.find((elem)=> elem.innerText === 'Files');
          fileTab?.click();
        }
      }
    } catch (error) {
      console.log(error);
    }
  },

  //Delete related item file
  async deleteRelatedItem(input, libraries, context) {
    console.log('deleteRelatedItem input', input);
    try {
      const fileId = input.query.data.fileId;
      const P_API = libraries.PlatformApi;
      let project = await P_API.IafProj.getCurrent();
      if (!context) {
        context = { _namespaces: project._namespaces };
      }
      const container = await getRelatedFilesContainer(project, P_API, context);
      console.log('container', container)
      const relations = await P_API.IafItemSvc.getRelations(
        container._id,
        {
          query: { _relatedFromId: fileId },
          options: { page: { getAllItems: true } },
        },
        context
      );
      console.log('file relations', relations)
      const relation = relations._list[0];
      console.log('file relation', relation)
      const delRes = await P_API.IafItemSvc.deleteRelations(
        container._id,
        [relation],
        context
      );
      console.log('delRes', delRes)
    } catch (error) {
      console.log(error);
    }
  }
};
export default modeleleme;