let files = {
  async loadFileAttributes(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let proj = await PlatformApi.IafProj.getCurrent(ctx)
    // this call is returning a 500 error need to check this
    // let fileAttributes = await PlatformApi.IafScriptEngine.getCollection({
    //   _userType: "iaf_cde_file_attrib_coll",
    //   _namespaces: proj._namespaces
    // }, ctx)
    let fileAttributes
    let fieldAttribVals = fileAttributes ? fileAttributes[0] : {}
    PlatformApi.IafScriptEngine.setVar('iaf_ext_fileAttributes', fieldAttribVals)
    PlatformApi.IafScriptEngine.setVar('iaf_attributeDisplayNames', [
      { prop: "building", dName: "Building" },
      { prop: "contributor", dName: "Contributor" },
      { prop: "documentType", dName: "Document Type" },
      { prop: "ElementCategory", dName: "ElementCategory" },
      { prop: "ElementType", dName: "ElementType" },
      { prop: "fileDiscipline", dName: "File Discipline" },
      { prop: "fileType", dName: "File Type" },
      { prop: "levelsAndLocations", dName: "Levels and Locations" },
      { prop: "manufacturer", dName: "Manufacturer" },
      { prop: "originator", dName: "Originator" },
      { prop: "revision", dName: "Revision" },
      { prop: "stageDescription", dName: "Stage Description" }
    ])

  },
  async getFileAttributeSelects(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_files_coll = await PlatformApi.IafScriptEngine.getVar('iaf_ext_files_coll')
    console.log("iaf_ext_files_coll", iaf_ext_files_coll)
    let distinctOriginators = await PlatformApi.IafScriptEngine.getDistinct({
      collectionDesc: { _userType: iaf_ext_files_coll._userType, _id: iaf_ext_files_coll._id },
      field: "fileAttributes.originator",
      query: {}
    }, ctx)
    console.log('distinctOriginators', distinctOriginators)
    distinctOriginators = distinctOriginators.filter(attval => attval != '')
    console.log('distinctOriginators2', distinctOriginators)
    distinctOriginators = _.sortBy(distinctOriginators, a => a)
    console.log('distinctOriginators3', distinctOriginators)
    let distinctDocTypes = await PlatformApi.IafScriptEngine.getDistinct({
      collectionDesc: { _userType: iaf_ext_files_coll._userType, _id: iaf_ext_files_coll._id },
      field: "fileAttributes.documentType",
      query: {}
    }, ctx)
    console.log('distinctDocTypes', distinctDocTypes)
    distinctDocTypes = distinctDocTypes.filter(attval => attval)
    console.log('distinctDocTypes2', distinctDocTypes)
    distinctDocTypes = _.sortBy(distinctDocTypes, a => a)
    console.log('distinctDocTypes3', distinctDocTypes)
    let distinctFileDisc = await PlatformApi.IafScriptEngine.getDistinct({
      collectionDesc: { _userType: iaf_ext_files_coll._userType, _id: iaf_ext_files_coll._id },
      field: "fileAttributes.fileDiscipline",
      query: {}
    }, ctx)
    console.log('distinctFileDisc', distinctFileDisc)
    distinctFileDisc = distinctFileDisc.filter(attval => attval)
    console.log('distinctFileDisc2', distinctFileDisc)
    distinctFileDisc = _.sortBy(distinctFileDisc, a => a)
    console.log('distinctFileDisc3', distinctFileDisc)
    let scriptedSelectProps = {
      Originator: distinctOriginators,
      "Document Type": distinctDocTypes,
      "File Discipline": distinctFileDisc
    }
    return scriptedSelectProps
  },
  async getFiles(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_files_coll = await PlatformApi.IafScriptEngine.getVar('iaf_ext_files_coll')
    let fileItems = await PlatformApi.IafScriptEngine.getFileItems(
      {
        collectionDesc: { _userType: iaf_ext_files_coll._userType, _userItemId: iaf_ext_files_coll._userItemId },
        query: input.entityInfo,
        options: { page: { getAllItems: true } }
      }, ctx
    )
    console.log('fileItems', fileItems)
    let filesAsEntities = fileItems.map(file => {
      return {
        _id: file._id,
        "Entity Name": file.name,
        properties: { iaf_attributeDisplayNames, fileAttr: file.fileAttributes }
        // $arrayToObject: {
        //   input: {
        //     $map: {
        //       input: "$iaf_attributeDisplayNames",
        //       as: "attr",
        //       in: {
        //         dName: "$$attr.dName",
        //         val: {
        //           $cond: [
        //             { $findone: [{ $objectToArray: "$$file.fileAttributes" }, { k: "$$attr.prop" }] },
        //             { $value: ["$$attr.prop", "$$file.fileAttributes"] },
        //             null
        //           ]
        //         },
        //         type: {
        //           $cond: [
        //             { $or: [{ $eq: ["dtCategory", "$$attr.prop"] }, { $eq: ["dtType", "$$attr.prop"] }] },
        //             "<<HIERARCHY>>",
        //             "text"
        //           ]
        //         }
        //       },
        //       out: {}
        //     }
        //   },
        //   keyField: "dName"
        // }
        // }
      }
    })
    console.log('fileItems', fileItems)
    return fileItems
  },
  async getBuildings(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { Building: iaf_ext_fileAttributes.building }
    return scriptValues
  },
  async getContributors(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { Contributor: iaf_ext_fileAttributes.contributor }
    return scriptValues
  },
  async getDocTypes(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { 'Document Type': iaf_ext_fileAttributes.documentType }
    return scriptValues
  },
  async getFileDiscs(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { 'File Discipline': iaf_ext_fileAttributes.fileDiscipline }
    return scriptValues
  },
  async getFileTypes(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { 'File Type': iaf_ext_fileAttributes.fileType }
    return scriptValues
  },
  async getLevsAndLocs(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { 'Levels and Locations': iaf_ext_fileAttributes.levelsAndLocations }
    return scriptValues
  },
  // async getFileManufacturers(input, libraries, ctx) {
  //   let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
  //   let scriptValues = { 'Levels and Locations': iaf_ext_fileAttributes.levelsAndLocations }
  //   return scriptValues
  // }

  async getOriginators(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { Originator: iaf_ext_fileAttributes.originator }
    return scriptValues
  },
  async getStageDescs(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_fileAttributes = await PlatformApi.IafScriptEngine.getVar('iaf_ext_fileAttributes')
    let scriptValues = { 'Stage Description': iaf_ext_fileAttributes.stageDescription }
    return scriptValues
  },
  async preprocessUploadFiles(input, libraries, ctx) {
    let { PlatformApi } = libraries
    let iaf_ext_files_coll = await PlatformApi.IafScriptEngine.getVar('iaf_ext_files_coll')
    console.log('input', input)
    let fileQueries = input.files.map(file => {
      return {
        query: { name: file.name },
        _userItemId: iaf_ext_files_coll._userItemId,
        options: { page: { getAllItems: true } }
      }
    })
    console.log('fileQueries', fileQueries)
    let fileItems = await PlatformApi.IafScriptEngine.getItemsMulti(fileQueries, ctx)
    fileItems = _.flatten(fileItems)
    console.log('fileItems', fileItems)
    let accepted = input.files.map(file => {
      return fileItems.map(fileItem => {
        return fileItem === file ? file.fileAttributes : {}
      })
    })
    console.log('accepted', accepted)
    return { accepted: accepted }
  }
}

export default files