async function addDataSources(params, libraries, ctx) {
  console.log("addDataSources params: ", JSON.stringify(params));
  console.log("addDataSources ctx: ", JSON.stringify(ctx));
  const { IafPassSvc } = libraries.PlatformApi;
  const { IafScriptEngine } = libraries;
  const bimpkMultiDsResult = await IafScriptEngine.addDatasource(
    {
      _name: "Run Import Models",
      _description: "BIMPK Import",
      _namespaces: ctx._namespaces,
      _userType: "models_import",
      _schemaversion: "2.0",
      _params: {
        tasks: [
          {
            name: "default_script_target",
            _actualparams: {
              userType: "iaf_import_model",
              _scriptName: "importModels"
            },
            _sequenceno: 1,
          },
        ],
      },
    },
    ctx
  );
  console.log(
    "Completed bimpkMultiDsResult ==== BIMPK Import Add Datasource Response",
    bimpkMultiDsResult
  );
  const bimpkDatasourceResult = await IafScriptEngine.addDatasource(
    {
      _name: "BIMPK Import",
      _description: "BIMPK Import",
      _namespaces: ctx._namespaces,
      _userType: "bimpk_import",
      _schemaversion: "2.0",
      _params: {
        tasks: [
          {
            name: "default_script_target",
            _actualparams: {
              userType: "iaf_import_model",
              _scriptName: "importModel",
            },
            _sequenceno: 1,
          },
        ],
      },
    },
    ctx
  );
  console.log(
    "Completed CreateBIMPKDatasource ==== BIMPK Import Add Datasource Response",
    bimpkDatasourceResult
  );

  const typeMapMultiDsResult = await IafScriptEngine.addDatasource(
    {
      _name: "Run Element Mapping",
      _description:
        "Orchestrator to map elements to elementCategory and elementType from type map coll",
      _namespaces: ctx._namespaces,
      _userType: "map_type_elems_multi",
      _params: {
        tasks: [
          {
            _orchcomp: "default_script_target",
            _name: "Map type map to elements",
            _sequenceno: 1,
            _actualparams: {
              userType: "iaf_map_elms_type",
              _scriptName: "mapRevitTypeCollections",

            },
          },
        ],
      },
    },
    ctx
  );

  console.log("addTypeMap === datasourceResult", typeMapMultiDsResult);


  //   Create Orchestrator to map elements to elementCategory and elementType from type map coll
  const typeMapDatasourceResult = await IafScriptEngine.addDatasource(
    {
      _name: "Map Revit Elements type",
      _description:
        "Orchestrator to map elements to elementCategory and elementType from type map coll",
      _namespaces: ctx._namespaces,
      _userType: "map_revit_type",
      _params: {
        tasks: [
          {
            _orchcomp: "default_script_target",
            _name: "Map type map to elements",
            _sequenceno: 1,
            _actualparams: {
              userType: "iaf_map_elms_type",
              _scriptName: "mapRevitTypeCollection",
            },
          },
        ],
      },
    },
    ctx
  );
  console.log("addTypeMap === datasourceResult", typeMapDatasourceResult);
}
