function Utf8ArrayToStr(array) {
  var out, i, len, c;
  var char2, char3;

  out = "";
  len = array.length;
  i = 0;
  while (i < len) {
    c = array[i++];
    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;
      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode(((c & 0x1f) << 6) | (char2 & 0x3f));
        break;
      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode(
          ((c & 0x0f) << 12) | ((char2 & 0x3f) << 6) | ((char3 & 0x3f) << 0)
        );
        break;
    }
  }

  return out;
}

let apiConfig = "apiconfig.json";

async function apiConfigImport(params, libraries, ctx) {
  console.log("apiConfigImport params: ", JSON.stringify(params));
  console.log("apiConfigImport ctx: ", JSON.stringify(ctx));
  return new Promise(async (resolve, reject) => {
    try {
      const { PlatformApi, IafScriptEngine, fs } = libraries;
      const { zipLink } = params.actualParams;
      let data;
      //* Download project setup zip file
      const response = await fetch(`${zipLink}`);
      const directoryPath = response.unZippedFilePath;
      const filePath = `${directoryPath}/scripts`;
      await readFilesRecursively(filePath);

      async function readFilesRecursively(dir) {
        const files = await fs.readdirSync(dir);
        for (const file of files) {
          const filePath = `${dir}/${file}`;
          if (!file.includes(".")) {
            await readFilesRecursively(filePath); // Await the recursive call
          } else {
            try {
              if (apiConfig === file) {
                const fileData = await fs.readFileSync(filePath);
                data = Utf8ArrayToStr(fileData);
              }
            } catch (error) {
              throw error;
            }
          }
        }
      }

      const configData = [JSON.parse(data)];

      console.log(
        "Started apiConfigImport.",
        "apiConfigImport ==== configData",
        configData
      );

      //Create API configuration with the REST API endpoints
      const configFileItem = await PlatformApi.IafItemSvc.createNamedUserItems(
        [
          {
            _name: "API config",
            _shortName: "api_config",
            _description: "API configuration with the REST API endpoints",
            _namespaces: ctx._namespaces,
            _userType: "api_config",
            _version: { _userData: JSON.stringify(configData) },
          },
        ],
        "UserConfig",
        ctx
      );
      console.log("apiConfigImport ==== configFileItem", configFileItem);

      const configFileItemId = configFileItem?._list?.[0]?._id;
      if (configFileItemId) {
        try {
          const addApiConfigResponse =
            await PlatformApi.IafObjectModelAPISvc.addApiConfig(
              configFileItemId,
              ctx
            );
          console.log(
            "apiConfigImport ==== ApiConfig imported successfully:",
            addApiConfigResponse
          );
        } catch (error) {
          console.error("apiConfigImport ==== Failed to add apiConfig:", error);
        }
      } else {
        console.log("apiConfigImport ==== No configFileItem found");
      }
      console.log("completed apiConfigImport.", configFileItem);
      resolve(true)
    } catch (error) {
      reject(error)
    }
  });
}
