
const typeMapFiles = [
  "1801KS-INV-01-ZZ-M3-Z-0001_Federated_TypeMap.xlsx", 
  "EX11034-INV-Federated_TypeMap.xlsx"
];

async function createCollections(params, libraries, ctx) {
  console.log("Running createCollections");
  console.log("createCollections params: ", JSON.stringify(params));
  console.log("createCollections ctx: ", JSON.stringify(ctx));
  const { PlatformApi, IafScriptEngine, CoreUtils, fs } = libraries;
  const { zipLink } = params.actualParams;
  const { DataXlsx } = CoreUtils;
  let xlsxFiles = [];
  //* Download project setup zip file
  const response = await fetch(`${zipLink}`);
  const directoryPath = response.unZippedFilePath;
  const filePath = `${directoryPath}/scripts`;

  async function readFilesRecursively(dir) {
    console.log("Running readFilesRecursively");
    try {
      const files = await fs.readdirSync(dir);
      for (const file of files) {
        const filePath = `${dir}/${file}`;
        if (!file.includes(".")) {
          await readFilesRecursively(filePath); // Await the recursive call
        } else {
          if (typeMapFiles.includes(file)) {
            console.log("file includes: ", file)
            try {
              const data = await fs.readFileSync(filePath);
              const fileData = {
                filename: file,
                data: data
              };
              console.log("fileData: ", JSON.stringify(fileData))
              xlsxFiles.push(fileData);
            } catch (error) {
              console.log('readFileSync error: ', JSON.stringify(error))
            }
          }
        }
      }
    } catch (e) {
      console.log("readFilesRecursively function error", JSON.stringify(e))
      throw e;
    }
  }

  await readFilesRecursively(filePath);

  const createIndex = async () => {
    console.log('creating index')
    let compositeCollections = await IafScriptEngine.getCompositeCollections(
      {
        query: {
          _userType: "bim_model_version",
          _namespaces: {
            $in: ctx._namespaces,
          },
          _itemClass: "NamedCompositeItem",
        },
      },
      ctx,
      { getLatestVersion: true }
    );
    compositeCollections = compositeCollections._list;
    console.log(
      "Started createIndex.",
      "Create index ==== getCompositeCollection.",
      compositeCollections
    );

    const createModelIndexes = async (modelCompositeUserItemId) => {
      let collectionInComposite = await IafScriptEngine.getCollectionInComposite(
        modelCompositeUserItemId,
        { _userType: "rvt_type_elements" },
        ctx
      );
      console.log(
        "Create index ==== getCollectionInComposite.",
        collectionInComposite
      );
  
      // Revit
      let indexRes = await IafScriptEngine.createOrRecreateIndex(
        {
          // model type elememt colletcion
          _id: collectionInComposite._userItemId,
          indexDefs: [
            {
              key: { "Element Category": 1 },
              options: {
                name: "model_els_coll_id",
                default_language: "english",
              },
            },
          ],
        },
        ctx
      );
      console.log(
        "Completed createIndex.",
        "Create index ==== Create Or Recreate Index Index response.",
        indexRes
      );
      return indexRes._list[0];
    };

    let indexReses = [];
    for (let i = 0; i < compositeCollections.length; i++) {
      const indexRes = await createModelIndexes(compositeCollections[i]._userItemId);
      console.log("Adding index res: ", indexRes);
      indexReses.push(indexRes);
    }
    console.log("indexReses: ", indexReses);
  }

  const addTypeMap = async (fileData) => {
    console.log("Started addTypeMap");
    const filename = fileData.filename;
    const xlsxFile = fileData.data;
  
    try {
      console.log("reading xlsxFile: ", JSON.stringify(xlsxFile));
      const workbook = await DataXlsx.read(xlsxFile);
      console.log("addTypeMap workbook: ", JSON.stringify(workbook));
      const wbJSON = await DataXlsx.workbookToJSON(workbook);
      console.log("addTypeMap wbJSON: ", JSON.stringify(wbJSON));
      const iaf_dt_grid_data = await wbJSON.Sheet1;
      console.log("addTypeMap iaf_dt_grid_data: ", JSON.stringify(iaf_dt_grid_data));
      const iaf_dt_grid_as_objects = await CoreUtils.Util.parseGridData({
        gridData: iaf_dt_grid_data,
      });
      console.log("addTypeMap === iaf_dt_grid_as_objects", JSON.stringify(iaf_dt_grid_as_objects));
      
      let newName;
      if (filename) {
        console.log('editing file name')
        newName = filename;
        if (newName.includes('.')) {
          newName = filename.split('.')[0];
        }
        if (newName.includes('_TypeMap')) {
          newName = newName.replace('_TypeMap', '');
        }
        console.log("newName: ", newName)
      }
      
      let typeColl;
      try {
        typeColl = await IafScriptEngine.createOrRecreateCollection(
          {
            _name: newName,
            _shortName: "typemap_defs",
            _namespaces: ctx._namespaces,
            _description: "Revit Element Type Map Collection",
            _userType: "iaf_ref_type_map_defs_coll",
          },
          ctx
        );
        console.log("addTypeMap typeColl", JSON.stringify(typeColl));
      } catch (error) {
        console.error('Type map createNamedUserItems failed:', error);
        throw error; 
      }
      
      try {
        const atm_defs_items_res = await IafScriptEngine.createItemsBulk(
          {
            _userItemId: typeColl._userItemId,
            _namespaces: ctx._namespaces,
            items: iaf_dt_grid_as_objects,
          },
          ctx
        );
        console.log("addTypeMap === atm_defs_items_res", JSON.stringify(atm_defs_items_res));  
      } catch (error) {
        console.error('Type map createItemsBulk failed:', error);
        throw error; 
      }
      
      return true;
    } catch (error) {
      console.error('Type map processing failed:', error);
      throw error; 
    }
  };
  
  const addMultipleTypeMaps = async (typeMapFiles) => {
    try {
      for (const xlsxFile of typeMapFiles) {
        console.log(`Processing type map file: ${JSON.stringify(xlsxFile)}`);
        await addTypeMap(xlsxFile);
      }
      console.log("All type maps processed successfully");
    } catch (error) {
      console.error("Error processing type maps:", JSON.stringify(error));
      throw error; 
    }
  };

  try {
    await createIndex();
    await addMultipleTypeMaps(xlsxFiles);
  } catch (error) {
    console.error("Error in createCollections:", error);
    throw error; 
  }
}
