async function createOtherCollections(params, libraries, ctx) {
  console.log("createOtherCollections params: ", JSON.stringify(params));
  console.log("createOtherCollections ctx: ", JSON.stringify(ctx));
  const { PlatformApi, IafScriptEngine, CoreUtils, fs } = libraries;
  const project = params.actualParams.project._list[0];
  let telemColls = [];
  let iotColls = [];
  let warrantyColls = [];
  let fileColl;
  let permProfile;

  //get bim models
  let bimModels;
  let bimModelsRes = await IafScriptEngine.getCompositeCollections(
    {
      query: {
        _userType: "bim_model_version",
        _namespaces: {
          $in: ctx._namespaces,
        },
        _itemClass: "NamedCompositeItem",
      },
    },
    ctx,
    { getLatestVersion: true }
  );
  console.log("found Models", bimModelsRes);
  bimModels = bimModelsRes._list;

  const createTelemColl = async (model, telemElems, elemColl) => {
    let modelName = model._name;
    if (modelName.includes('.bimpk')) {
      modelName = modelName.replace('.bimpk', '');
    } 
    // Telemetry Collection
    const telemColl =
      await PlatformApi.IafItemSvc.createNamedUserItems(
        [
          {
            _name: `${modelName} Telemetry Collection`,
            _shortName: "telemetry_coll",
            _description:
              "Named Telemetry Collection to store sensor and points data",
            _namespaces: ctx._namespaces,
            _userType: "ref_app_telementary_collection",
            _tsProperties: {
              _granularity: "minutes",
              _expiry: 1440,
            },
          },
        ],
        "NamedTelemetryCollection",
        ctx
      );
    console.log(
      `Started createTelementaryCollection`,
      "createTelementaryCollection ==== Created Telemetry collection response.",
      telemColl
    );
    telemColls.push(telemColl);

    if (telemElems.length > 0) {
      //* Telemetry Collection Relations
      let telemRelatedItems = [
        {
          floorname: "2nd Floor",
          roomname: "Lab",
          _sourceId: "e3e052f9-0156-11d5-9301-0000863f27ad-00000131",
        },
      ];

      let telementryRelatedItems =
        await PlatformApi.IafItemSvc.createRelatedItems(
          telemColl._list[0]._id,
          telemRelatedItems,
          ctx
        );
      console.log(
        "createTelementaryCollection ==== Telementry RelatedItems response.",
        telementryRelatedItems
      );

      let relationShipsSensor1 = [
        {
          _relatedFromId: telemElems[0]._id, // parent id
          _relatedToIds: telementryRelatedItems._list.map((item) => item._id), // children from tip version
          _relatedUserItemDbId: telemColl._list[0]._id,
        },
      ];

      console.log(
        "relationShipsSensor1",
        relationShipsSensor1
      );
      console.log(
        "telemColl._list[0]._id",
        telemColl._list[0]._id
      );

      let relationsSensor1 = await PlatformApi.IafItemSvc.addRelations(
        elemColl._itemId,
        relationShipsSensor1,
        ctx
      );
      console.log(
        `Completed createTelementaryCollection`,
        "createTelementaryCollection ==== Telementry add relations response.",
        relationsSensor1
      );
      let relationShipsSensor2 = [
        {
          _relatedFromId: telemElems[1]._id, // parent id
          _relatedToIds: telementryRelatedItems._list.map((item) => item._id), // children from tip version
          _relatedUserItemDbId: telemColl._list[0]._id,
        },
      ];
      // To create relation between pump element id,sensor data and collection
      let relationsSensor2 = await PlatformApi.IafItemSvc.addRelations(
        elemColl._itemId,
        relationShipsSensor2,
        ctx
      );
      console.log(
        `Completed createTelementaryCollection`,
        "createTelementaryCollection ==== Telementry add relations response.",
        relationsSensor2
      );
    }
  };

  const createIotColl = async (model, telemElems, elemColl) => {
    let modelName = model._name;
    if (modelName.includes('.bimpk')) {
      modelName = modelName.replace('.bimpk', '');
    } 
    let IotCollection = await PlatformApi.IafItemSvc.createNamedUserItems(
      [
        {
          _name: `${modelName} Telemetry Collection`,
          _shortName: "telementary_coll",
          _description:
            "Named Telemetry Collection to store sensor and points data",
          _namespaces: ctx._namespaces,
          _userType: "ref_app_iot_collection",
          _tsProperties: {
            _granularity: "minutes",
            _expiry: 1440,
          },
        },
      ],
      "NamedTelemetryCollection",
      ctx
    );
    console.log(
      `Started createIotCollection`,
      "createIotCollection ==== Created Iot collection response.",
      IotCollection
    );
    IotCollection = IotCollection._list[0];
    iotColls.push(IotCollection);
    
    if (telemElems.length > 0) {
      //* Iot Collection Relations
      let relatedItemsIot = [
        {
          floorname: "2nd Floor",
          roomname: "Lab",
          _sourceId: "e3e052f9-0156-11d5-9301-0000863f27ad-00000131",
        },
      ];

      let IotRelatedItems = await PlatformApi.IafItemSvc.createRelatedItems(
        IotCollection._id,
        relatedItemsIot,
        ctx
      );
      console.log(
        "createIotCollection ==== Iot RelatedItems response.",
        IotRelatedItems
      );

      let relationShipsSensorIot = [
        {
          _relatedFromId: telemElems[0]._id, // parent id
          _relatedToIds: IotRelatedItems._list.map((item) => item._id), // children from tip version
          _relatedUserItemDbId: IotCollection._id,
        },
      ];

      let relationsSensorIot = await PlatformApi.IafItemSvc.addRelations(
        elemColl._itemId,
        relationShipsSensorIot,
        ctx
      );
      console.log(
        `Completed createIotCollection`,
        "createIotCollection ==== Iot add relations response.",
        relationsSensorIot
      );
      let relationShipsSensorIot2 = [
        {
          _relatedFromId: telemElems[1]._id, // parent id
          _relatedToIds: IotRelatedItems._list.map((item) => item._id), // children from tip version
          _relatedUserItemDbId: IotCollection._id,
        },
      ];
      // To create relation between pump element id,sensor data and collection
      let relationsSensorIot2 = await PlatformApi.IafItemSvc.addRelations(
        elemColl._itemId,
        relationShipsSensorIot2,
        ctx
      );
      console.log(
        `Completed createIotCollection`,
        "createIotCollection ==== Iot add relations response.",
        relationsSensorIot2
      );
    }
  };

  const createTelemAndIotColls = async (model, elemColl) => { 
    //fetching TelemetryElement 
    let telemElemBimQuery = {
      parent: {
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: elemColl._userItemId,
        },
        options: {
          page: {
            getAllItems: true,
          },
        },
        sort: {
          _id: 1,
        },
        query: {
          ElementCategory: { $in: ["Sensor"] },
        },
      },
    };
    let telemElems = await IafScriptEngine.findWithRelated(telemElemBimQuery, ctx);
    console.log("telemElements", telemElems);
    telemElems = telemElems._list

    if (telemElems.length === 0) return;
    
    await createTelemColl(model, telemElems, elemColl);
    await createIotColl(model, telemElems, elemColl);
  }

  const addWarranties = async (model) => {
    //creating warranty collection and relating warranty data
    let modelName = model._name;
    if (modelName.includes('.bimpk')) {
      modelName = modelName.replace('.bimpk', '');
    } 
    let Coll_info = {
      Name: `${model._name} Element Warranty Data`,
      ShortName: "war_data",
      Description: "Element Warranty Data",
      userType: "iaf_dt_warranty_coll",
    };

    let data_obj_coll = await IafScriptEngine.createCollection(
      {
        _name: Coll_info.Name,
        _shortName: Coll_info.ShortName,
        _namespaces: ctx._namespaces,
        _description: Coll_info.Description,
        _userType: Coll_info.userType,
      },
      ctx
    );
    console.log(
      "createWarrantyAndElementRelation ==== data_obj_coll",
      data_obj_coll
    );
    // //fetching door elements
    //await addWarrantiesData(model, data_obj_coll)
  }

  const addWarrantiesData = async (model, data_obj_coll) => {
    let bimQuery = {
      parent: {
        collectionDesc: {
          _userType: "rvt_elements",
          _userItemId: model._userItemId,
        },
        options: { page: { getAllItems: true } },
        sort: { _id: 1 },
        query: { ElementCategory: { $in: ["Door - External"] } },
      },
    };
    const revit_elements = await IafScriptEngine.findWithRelated(bimQuery, ctx);
    console.log("fetchOSTDoors ==== elements", revit_elements);

    let rvt_coll = await IafScriptEngine.getCollectionInComposite(
      model._userItemId,
      { _userType: "rvt_elements" },
      ctx
    );
    console.log("createWarrantyAndElementRelation ==== rvt_coll", rvt_coll);

    let dataObject = {
      properties: {
        "Warranty Description": {
          dName: "Warranty Description",
          val: "The manufacturer warrants this product to be free from defects in workmanship and materials, under normal residential use and conditions, for a period of one (1) year for the original invoice date",
          type: "text",
          epoch: null,
        },
        "Warranty Start Date": {
          dName: "Warranty Start Date",
          val: "09-11-2022",
          type: "date",
        },
        "Warranty Duration": {
          dName: "Warranty Duration",
          val: "1 year",
          type: "text",
        },
      },
    };

    if (revit_elements._list.length > 0) {
      const flatAllDataObjs = new Array(revit_elements._list.length).fill(
        dataObject
      );

      let data_obj_res = await IafScriptEngine.createItemsBulk(
        {
          _userItemId: data_obj_coll._userItemId,
          _namespaces: ctx._namespaces,
          items: flatAllDataObjs,
        },
        ctx
      );
      console.log(
        "createWarrantyAndElementRelation ==== data_obj_res",
        data_obj_res
      );
      warrantyColls.push(data_obj_res);
      //CREATE ITEMS BULK DOESNT RETURN THE CREATED OBJECTS IT RETURNS URIS FOR THE OBJECTS
      //SO GET ALL THOSE IN ONE LIST WHICH WE WILL USE TO GET THE NEW OBJECT IDS OFF THE END

      // Get all _uris from data_obj_res[0] and flatten them into a single array
      const allURIs = data_obj_res[0].flatMap((d) => d._uris);
      console.log("createWarrantyAndElementRelation ==== allURIs", allURIs);

      // Extract the last part of each URI to get dataObjIds
      const dataObjIds = allURIs.map((u) => u.split("/").pop());
      console.log(
        "createWarrantyAndElementRelation ==== dataObjIds",
        dataObjIds
      );
      // Combine revit_elements and dataObjIds into an array of tuples
      const assetsWithDataIds = revit_elements._list.map((e, i) => [
        e,
        dataObjIds[i],
      ]);
      console.log(
        "createWarrantyAndElementRelation ==== assetsWithDataIds",
        assetsWithDataIds
      );

      // Create an array of related items with parentItem and relatedItems properties
      const warrRelatedItems = assetsWithDataIds.map((d) => {
        return { parentItem: d[0], relatedItems: [{ _id: d[1] }] };
      });
      console.log(
        "createWarrantyAndElementRelation ==== warrRelatedItems",
        warrRelatedItems
      );

      const relations = await IafScriptEngine.createRelations(
        {
          parentUserItemId: rvt_coll._userItemId,
          _userItemId: data_obj_coll._userItemId,
          _namespaces: ctx._namespaces,
          relations: warrRelatedItems,
        },
        ctx
      );
      console.log("createWarrantyAndElementRelation ==== relations", relations);

      //GET AN ASSET WITH THE RELATED DATA AS A TEST
      const testAsset = await IafScriptEngine.findWithRelated(
        {
          parent: {
            query: { _id: revit_elements._list[0]._id },
            collectionDesc: { _userItemId: rvt_coll._userItemId },
            options: { page: { getAllItems: true } },
          },
          related: [
            {
              relatedDesc: { _relatedUserType: data_obj_coll._userType },
              as: "Related Data Object",
            },
          ],
        },
        ctx
      );
      console.log(
        "createWarrantyAndElementRelation ==== testAsset for Warranty Collection : ",
        testAsset._list[0]
      );
      console.log(
        "Completed createWarrantyAndElementRelation.",
        "createWarrantyAndElementRelation ==== testAsset for Warranty Collection : ",
        testAsset._list[0]
      );
    }
  }

  return new Promise(async (resolve, reject) => {
    try {
        //creating permission profile
      console.log('Creating permission profile')
      const workspaceId = project._id;
      const irnValue = "passportsvc:workspace:" + workspaceId;
      let permissions = [
        {
          _name: "viewer_orch_perms1",
          _userType: "viewer_orch_perms",
          _namespaces: [ctx._namespaces[0]],
          _permissions: [
            {
              _actions: ["READ", "SHARE"],
              _namespace: ctx._namespaces[0],
              _resourceDesc: {
                _irn: irnValue,
              },
            },
            {
              _actions: ["READ", "SHARE", "DELETE", "CREATE"],
              _namespace: ctx._namespaces[0],
              _resourceDesc: {
                _irn: "itemsvc:nameduseritem:*",
              },
            },
          ],
        },
        {
          _name: "mapbox_token_orch_perms",
          _userType: "mapbox_token_perm",
          _namespaces: [ctx._namespaces[0]],
          _permissions: [
            {
              _actions: ["READ", "SHARE"],
              _namespace: ctx._namespaces[0],
              _resourceDesc: {
                _irn: irnValue,
              },
            },
            {
              _actions: ["READ"],
              _namespace: ctx._namespaces[0],
              _resourceDesc: {
                _irn: "itemsvc:nameduseritem:*",
              },
            }
          ]
        }
      ];
      console.log('permissions: ', JSON.stringify(permissions))
      let result = await PlatformApi.IafPassSvc.createPermissionProfiles(
        permissions,
        ctx
      );
      console.log("createPermissionProfile ==== result", result);
      permProfile = result;

      for (let i = 0; i < bimModels.length; i++) {
        //
        try {
          const elemColl =
            await IafScriptEngine.getCollectionInComposite(
              bimModels[i]._id,
              { _userType: "rvt_elements" },
              ctx
            );
          await createTelemAndIotColls(bimModels[i], elemColl);
          await addWarranties(bimModels[i]);
        } catch (e) {
          console.log("addWarranties error", e)
        }
        
      }

      //Creating Root Container for files
      console.log("Creating Root Container...");
      const rootContainer = await PlatformApi.IafFile.createContainer(
        project,
        undefined,
        ctx
      );
      console.log("rootContainer result", rootContainer);
      fileColl = rootContainer;
      resolve()
    } catch (e) {
      console.log('create other colls err: ', e);
      reject()
    }
  })
}
