const fileAttributesFile = "Kingspan_FileAttributes.xlsx";

async function fileAttributesImport(params, libraries, ctx) {
  console.log("fileAttributesImport params: ", JSON.stringify(params));
  console.log("fileAttributesImport ctx: ", JSON.stringify(ctx));
  return new Promise(async (resolve, reject) => {
    try {
      const { PlatformApi, IafScriptEngine, xlsx, CoreUtils, fs } = libraries;
      const { zipLink } = params.actualParams;
      const { DataXlsx } = CoreUtils;
      let xlsxFile;

      //* Download project setup zip file
      const response = await fetch(`${zipLink}`);
      const directoryPath = response.unZippedFilePath;
      const filePath = `${directoryPath}/scripts`;
      await readFilesRecursively(filePath);

      async function readFilesRecursively(dir) {
        const files = await fs.readdirSync(dir);
        for (const file of files) {
          const filePath = `${dir}/${file}`;
          if (!file.includes(".")) {
            await readFilesRecursively(filePath); // Await the recursive call
          } else {
            try {
              if (fileAttributesFile === file) {
                const fileData = await fs.readFileSync(filePath);
                xlsxFile = fileData;
              }
            } catch (error) {
              null;
            }
          }
        }
      }

      const workbook = await DataXlsx.read(xlsxFile);
      const wbJSON = await DataXlsx.workbookToJSON(workbook);
      let iaf_dt_grid_data = wbJSON["Document Attributes"];
      let iaf_dt_grid_as_objects = await CoreUtils.Util.parseGridData({
        gridData: iaf_dt_grid_data,
      });
      console.log("fileAttributesImport ==== iaf_dt_grid_as_objects");

      let file_attr_defs_coll = await IafScriptEngine.createOrRecreateCollection(
        {
          _name: "File Attributes Collection",
          _shortName: "file_attr_defs",
          _namespaces: ctx._namespaces,
          _description: "File Attributes Collection",
          _userType: "iaf_file_attr_defs_coll",
        },
        ctx
      );

      console.log("fileAttributesImport ==== file_attr_defs_coll", file_attr_defs_coll);

      let file_attr_items_res = await IafScriptEngine.createItemsBulk(
        {
          _userItemId: file_attr_defs_coll._userItemId,
          _namespaces: ctx._namespaces,
          items: iaf_dt_grid_as_objects,
        },
        ctx
      );
      console.log(
        "fileAttributesImport ==== atm_defs_items_res",
        file_attr_items_res
      );

      resolve(true);
    } catch (error) {
      reject(error);
    }
  });
}
