async function bimpkOperations(params, libraries, ctx) {
  console.log("bimpkOperations is now running");
  console.log("bimpkOperations params: ", JSON.stringify(params));
  console.log("bimpkOperations ctx: ", JSON.stringify(ctx));
  const project = params.actualParams.project._list[0];
  console.log("project: ", project);
  const { IafScriptEngine, fs, PlatformApi, ModelFileReader } = libraries;
  const { zipLink } = params.actualParams;
  const bimpkFiles = ["1801KS-INV-01-ZZ-M3-Z-0001_Federated.bimpk", "EX11034-INV-Federated.bimpk"];
  let iaf_bimpk_names; 
  if (project?._userAttributes?.multiModel) {
    iaf_bimpk_names = bimpkFiles;
  } else {
    iaf_bimpk_names = bimpkFiles[0];
  }

  let bimpkMetadata = [];
  //* Download project setup zip file
  const response = await fetch(zipLink);
  const directoryPath = response.unZippedFilePath;
  const filePath = `${directoryPath}/scripts`;

  console.log({
    "zipLink": zipLink,
    "response": response,
    "directoryPath": directoryPath,
    "filePath": filePath,
    "iaf_bimpk_names": iaf_bimpk_names
  });

  await readFilesRecursively(filePath);

  async function readFilesRecursively(dir) {
    console.log("Running readFilesRecursively");
    try {
      const files = await fs.readdirSync(dir);
      for (const file of files) {
        const filePath = `${dir}/${file}`;
        if (!file.includes(".")) {
          await readFilesRecursively(filePath);
        } else {
          try {
            if (iaf_bimpk_names.includes(file)) {
              console.log("file includes: ", file)
              const bimpkMeta = {
                "bimpkFile": file,
                "bimpkFilePath": filePath
              };
              bimpkMetadata.push(bimpkMeta);
              console.log("bimpkMetadata uploadBimpk", JSON.stringify(bimpkMetadata));
            }
          } catch (error) {
            console.log("readFilesRecursively error", JSON.stringify(error))
            throw error;
          }
        }
      };
      console.log("readFilesRecursively result:", JSON.stringify(bimpkMetadata));
    } catch (e) {
      console.log("readFilesRecursively function error", JSON.stringify(e))
      throw e;
    }
  }

  async function uploadBimpk(params, libraries, ctx, bimpkMetadata) {
    console.log("Running UploadBimpk");
    console.log("uploadBimpk params: ", JSON.stringify(params));
    console.log("uploadBimpk ctx: ", JSON.stringify(ctx));
    try {
      const folder = await PlatformApi.IafFileSvc.addFolder(
        'Bimpk Files',
        params.context._namespaces[0],
        undefined,
        params.context
      );
      for (let i = 0; i < bimpkMetadata.length; i++) { 
        console.log("uploadToFilesvc running ", i);
        console.log("bimpkMetadata uploadBimpk", JSON.stringify(bimpkMetadata));
        const filePath = bimpkMetadata[i].bimpkFilePath;
        const filename = bimpkMetadata[i].bimpkFile;
        const opts = { filename }
        const tags = ['#invmodelfile#']
        const uploadParams = { filePath, opts, tags, folder, context: params.context }
        try {
          const uploadedFile = await ModelFileReader.uploadLargeFile(uploadParams);
          console.log("uploadBimpk uploadedFile: ", JSON.stringify(uploadedFile));
        } catch (e) {
          console.log("uploadToFilesvc error", JSON.stringify(e))
          throw e;
        }
      }
    } catch (e) {
      console.log("uploadBimpk error", JSON.stringify(e))
      throw e;
    }
    console.log("Cleaning bimpk uploads");
    try {
      const files = await PlatformApi.IafFileSvc.getFiles({ _name: ".*(.bimpk|.sgpk)" }, ctx);
      console.log("Files to clean: ", JSON.stringify(files));
    } catch (e) {
      console.log("Cleaning bimpk uploads error", JSON.stringify(e))
      throw e;
    }
  }

  async function addBimpkCollections() {
    const iaf_dt_grid_as_objects = [
      {
        "Revit Category": "OST_BuildingPad",
        "Revit Family": "Pad",
        "Revit Type": "A-M_Pad 1",
      },
      {
        "Revit Category": "OST_CableTray",
        baType: "Cable Trays",
        "Revit Family": "Cable Tray with Fittings",
        "Revit Type": "Submains Cable ladder",
        ElementCategory: "Cable Tray",
        ElementType: "Submains Cable ladder",
      },
      {
        "Revit Category": "OST_CableTray",
        baType: "Cable Trays",
        "Revit Family": "Cable Tray with Fittings",
        "Revit Type": "Channel Cable Tray",
        ElementCategory: "Cable Tray",
        ElementType: "Channel",
      },
    ];

    console.log("Started CreateBIMPKDatasource");

    try {
      let atm_defs_coll = await IafScriptEngine.createOrRecreateCollection(
        {
          _name: "ATM Def Collection",
          _shortName: "typemap_defs",
          _namespaces: ctx._namespaces,
          _description: "Asset Type Map Collection",
          _userType: "iaf_dt_type_map_defs_coll",
        },
        ctx
      );
      console.log("ATM Def Collection Create Response: ", JSON.stringify(atm_defs_coll));

      let atm_defs_items_res = await IafScriptEngine.createItemsBulk(
        {
          _userItemId: atm_defs_coll._userItemId,
          _namespaces: ctx._namespaces,
          items: iaf_dt_grid_as_objects,
        },
        ctx
      );
      console.log("Create Items Bulk Response: ", JSON.stringify(atm_defs_items_res));
    } catch (e) {
      console.log("uploadBimpk addBimpkCollections error", e)
      throw e
    }
  }

  console.log("about to run addBimpkCollections")
  await addBimpkCollections();

  // Fetch BIMPK File
  console.log("about to run uploadBimpk")
  await uploadBimpk(params, libraries, ctx, bimpkMetadata);
}
